/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.ResourceExtractionUtil;
import co.elastic.apm.attach.ElasticAttachmentProvider;
import co.elastic.apm.attach.bytebuddy.agent.ByteBuddyAgent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ElasticApmAttacher {
    private static final String TEMP_PROPERTIES_FILE_KEY = "c";

    public static void attach() {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadProperties("elasticapm.properties"));
    }

    public static void attach(String propertiesLocation) {
        ElasticApmAttacher.attach(ElasticApmAttacher.loadProperties(propertiesLocation));
    }

    private static Map<String, String> loadProperties(String propertiesLocation) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        Properties props = new Properties();
        try (InputStream resourceStream = ElasticApmAttacher.class.getClassLoader().getResourceAsStream(propertiesLocation);){
            if (resourceStream != null) {
                props.load(resourceStream);
                for (String propertyName : props.stringPropertyNames()) {
                    propertyMap.put(propertyName, props.getProperty(propertyName));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return propertyMap;
    }

    public static void attach(Map<String, String> configuration) {
        if (Boolean.getBoolean("ElasticApm.attached")) {
            return;
        }
        ElasticApmAttacher.attach(ByteBuddyAgent.ProcessProvider.ForCurrentVm.INSTANCE.resolve(), configuration);
    }

    static File createTempProperties(Map<String, String> configuration) {
        File tempFile = null;
        if (!configuration.isEmpty()) {
            Properties properties = new Properties();
            properties.putAll(configuration);
            String externalConfig = configuration.get("config_file");
            if (null != externalConfig) {
                try (FileInputStream stream = new FileInputStream(externalConfig);){
                    properties.load(stream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                tempFile = File.createTempFile("elstcapm", ".tmp");
                try (FileOutputStream outputStream = new FileOutputStream(tempFile);){
                    properties.store(outputStream, null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tempFile;
    }

    public static void attach(String pid, Map<String, String> configuration) {
        ElasticApmAttacher.attach(pid, configuration, AgentJarFileHolder.INSTANCE.agentJarFile);
    }

    public static void attach(String pid, Map<String, String> configuration, File agentJarFile) {
        File tempFile = ElasticApmAttacher.createTempProperties(configuration);
        String agentArgs = tempFile == null ? null : "c=" + tempFile.getAbsolutePath();
        ByteBuddyAgent.attach(agentJarFile, pid, agentArgs, ElasticAttachmentProvider.get());
        if (tempFile != null && !tempFile.delete()) {
            tempFile.deleteOnExit();
        }
    }

    @Deprecated
    public static void attach(String pid, String agentArgs) {
        ByteBuddyAgent.attach(AgentJarFileHolder.INSTANCE.agentJarFile, pid, agentArgs, ElasticAttachmentProvider.get());
    }

    public static File getBundledAgentJarFile() {
        return AgentJarFileHolder.INSTANCE.agentJarFile;
    }

    private static enum AgentJarFileHolder {
        INSTANCE;

        final File agentJarFile = AgentJarFileHolder.getAgentJarFile();

        private static File getAgentJarFile() {
            if (ElasticApmAttacher.class.getResource("/elastic-apm-agent.jar") == null) {
                return null;
            }
            return ResourceExtractionUtil.extractResourceToTempDirectory("elastic-apm-agent.jar", "elastic-apm-agent", ".jar").toFile();
        }
    }
}

