/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserRegistry {
    private final Map<String, User> users = new HashMap<String, User>();

    private UserRegistry(List<User> users) {
        for (User user : users) {
            this.users.put(user.username, user);
        }
    }

    public static UserRegistry getAllUsersMacOs() throws IOException, InterruptedException {
        String user;
        ArrayList<User> users = new ArrayList<User>();
        Process dscl = new ProcessBuilder("dscl", ".", "list", "/Users").start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(dscl.getInputStream()));
        while ((user = reader.readLine()) != null) {
            if (user.startsWith("_")) continue;
            users.add(User.of(user));
        }
        if (dscl.waitFor() != 0) {
            throw new IllegalStateException();
        }
        return new UserRegistry(users);
    }

    public static UserRegistry empty() {
        return new UserRegistry(Collections.emptyList());
    }

    public static String getCurrentUserName() {
        return System.getProperty("user.name");
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.io.tmpdir"));
    }

    public User getCurrentUser() {
        return this.get(UserRegistry.getCurrentUserName());
    }

    public Collection<String> getAllTempDirs() throws IOException, InterruptedException {
        HashSet<String> tempDirs = new HashSet<String>();
        for (User user : this.users.values()) {
            tempDirs.add(this.findTempDir(user));
        }
        tempDirs.remove(null);
        return tempDirs;
    }

    private String findTempDir(User user) throws IOException, InterruptedException {
        CommandOutput output;
        if (user.canSwitchToUser() && (output = user.executeAsUserWithCurrentClassPath(UserRegistry.class, Collections.emptyList())).exitedNormally()) {
            return output.getOutput().toString().trim();
        }
        return null;
    }

    public Collection<String> getAllUserNames() {
        return this.users.keySet();
    }

    public User get(String username) {
        if (!this.users.containsKey(username)) {
            this.users.put(username, User.of(username));
        }
        return this.users.get(username);
    }

    public static class CommandOutput {
        StringBuilder output;
        int exitCode;
        Throwable exceptionThrown;

        public CommandOutput(StringBuilder output, int exitCode, Throwable exception) {
            this.output = output;
            this.exitCode = exitCode;
            this.exceptionThrown = exception;
        }

        public StringBuilder getOutput() {
            return this.output;
        }

        public boolean exitedNormally() {
            return this.getExceptionThrown() == null && this.exitCode == 0;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public Throwable getExceptionThrown() {
            return this.exceptionThrown;
        }

        public String toString() {
            if (this.exceptionThrown != null) {
                return "Exit Code: " + this.exitCode + "; Output: " + this.output.toString() + "\r\nException: " + this.exceptionThrown;
            }
            return "Exit Code: " + this.exitCode + "; Output: " + this.output.toString();
        }
    }

    public static class User {
        private final String username;
        private final boolean canSwitchToUser;

        private User(String username, boolean canSwitchToUser) {
            this.username = username;
            this.canSwitchToUser = canSwitchToUser;
        }

        private static User of(String username) {
            try {
                return new User(username, User.canSwitchToUser(username));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean canSwitchToUser(String user) {
            if (UserRegistry.getCurrentUserName().equals(user)) {
                return true;
            }
            if (Platform.isWindows()) {
                return false;
            }
            try {
                return new ProcessBuilder(User.sudoCmd(user, Arrays.asList("echo", "ok"))).inheritIO().start().waitFor() == 0;
            }
            catch (Exception ignore) {
                return false;
            }
        }

        public static String getCurrentJvm() {
            return System.getProperty("java.home") + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "java" + (Platform.isWindows() ? ".exe" : "");
        }

        public CommandOutput executeAsUserWithCurrentClassPath(Class<?> mainClass, List<String> args) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(User.getCurrentJvm());
            cmd.add("-cp");
            cmd.add(System.getProperty("java.class.path"));
            cmd.add(mainClass.getName());
            cmd.addAll(args);
            return this.executeAs(cmd);
        }

        public CommandOutput executeAs(List<String> cmd) {
            if (!this.canSwitchToUser) {
                throw new IllegalStateException(String.format("Cannot run as user %s", this.username));
            }
            if (!this.isCurrentUser()) {
                if (Platform.isWindows()) {
                    throw new IllegalStateException(String.format("Cannot run as user %s on Windows", this.username));
                }
                cmd = User.sudoCmd(this.username, cmd);
            }
            return User.executeCommand(cmd);
        }

        private static List<String> sudoCmd(String user, List<String> cmd) {
            ArrayList<String> fullCmd = new ArrayList<String>();
            fullCmd.add("sudo");
            fullCmd.add("-n");
            fullCmd.add("-u");
            fullCmd.add(user);
            fullCmd.addAll(cmd);
            return fullCmd;
        }

        public boolean canSwitchToUser() {
            return this.canSwitchToUser;
        }

        public boolean isCurrentUser() {
            return this.username.equals(UserRegistry.getCurrentUserName());
        }

        public String getUsername() {
            return this.username;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CommandOutput executeCommand(List<String> command) {
            ProcessBuilder buildTheProcess = new ProcessBuilder(command);
            buildTheProcess.redirectErrorStream(true);
            Process spawnedProcess = null;
            int exitValue = -1;
            Throwable exception = null;
            StringBuilder commandOutput = new StringBuilder();
            try {
                long start;
                spawnedProcess = buildTheProcess.start();
                long timeout = 5000L;
                long now = start = System.currentTimeMillis();
                boolean isAlive = true;
                byte[] buffer = new byte[4000];
                try (InputStream in = spawnedProcess.getInputStream();){
                    while (isAlive && now - start < timeout) {
                        while (in.available() > 0) {
                            int lengthRead = in.read(buffer, 0, buffer.length);
                            commandOutput.append(new String(buffer, 0, lengthRead));
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException lengthRead) {
                            // empty catch block
                        }
                        now = System.currentTimeMillis();
                        isAlive = User.processIsAlive(spawnedProcess) || in.available() > 0;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException lengthRead) {
                        // empty catch block
                    }
                    while (in.available() > 0) {
                        int lengthRead = in.read(buffer, 0, buffer.length);
                        commandOutput.append(new String(buffer, 0, lengthRead));
                    }
                }
            }
            catch (Throwable e1) {
                exception = e1;
            }
            finally {
                block33: {
                    if (spawnedProcess != null && User.processIsAlive(spawnedProcess)) {
                        spawnedProcess.destroy();
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException timeout) {}
                    }
                    if (spawnedProcess != null) {
                        try {
                            exitValue = spawnedProcess.exitValue();
                        }
                        catch (IllegalThreadStateException e2) {
                            if (exception != null) break block33;
                            exception = e2;
                        }
                    }
                }
            }
            return new CommandOutput(commandOutput, exitValue, exception);
        }

        public static boolean processIsAlive(Process proc) {
            try {
                proc.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }
    }
}

