/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserRegistry {
    private final Map<String, User> users = new HashMap<String, User>();

    private UserRegistry(List<User> users) {
        for (User user : users) {
            this.users.put(user.username, user);
        }
    }

    public static UserRegistry getAllUsersMacOs() throws IOException, InterruptedException {
        String user;
        ArrayList<User> users = new ArrayList<User>();
        Process dscl = new ProcessBuilder("dscl", ".", "list", "/Users").start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(dscl.getInputStream()));
        while ((user = reader.readLine()) != null) {
            if (user.startsWith("_")) continue;
            users.add(User.of(user));
        }
        if (dscl.waitFor() != 0) {
            throw new IllegalStateException();
        }
        return new UserRegistry(users);
    }

    public static UserRegistry empty() {
        return new UserRegistry(Collections.emptyList());
    }

    public static String getCurrentUserName() {
        return System.getProperty("user.name");
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.io.tmpdir"));
    }

    public User getCurrentUser() {
        return this.get(UserRegistry.getCurrentUserName());
    }

    public Collection<String> getAllTempDirs() throws IOException, InterruptedException {
        HashSet<String> tempDirs = new HashSet<String>();
        for (User user : this.users.values()) {
            tempDirs.add(this.findTempDir(user));
        }
        tempDirs.remove(null);
        return tempDirs;
    }

    private String findTempDir(User user) throws IOException, InterruptedException {
        if (Platform.isWindows()) {
            throw new IllegalStateException("Discovering the temp dir of a given user is not supported in Windows as the runAs method has no implementation for Windows");
        }
        if (user.canSwitchToUser()) {
            Process process = user.runAsUserWithCurrentClassPath(UserRegistry.class).start();
            process.waitFor();
            if (process.exitValue() == 0) {
                return new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            }
        }
        return null;
    }

    public Collection<String> getAllUserNames() {
        return this.users.keySet();
    }

    public User get(String username) {
        if (!this.users.containsKey(username)) {
            this.users.put(username, User.of(username));
        }
        return this.users.get(username);
    }

    public static class User {
        private final String username;
        private final boolean canSwitchToUser;

        private User(String username, boolean canSwitchToUser) {
            this.username = username;
            this.canSwitchToUser = canSwitchToUser;
        }

        private static User of(String username) {
            try {
                if (Platform.isWindows()) {
                    return new User(username, false);
                }
                return new User(username, User.canSwitchToUser(username));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean canSwitchToUser(String user) {
            try {
                return new ProcessBuilder("sudo", "--non-interactive", "-u", user, "echo", "ok").start().waitFor() == 0;
            }
            catch (Exception ignore) {
                return false;
            }
        }

        public static String getCurrentJvm() {
            return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" + (Platform.isWindows() ? ".exe" : "");
        }

        public ProcessBuilder runAsUserWithCurrentClassPath(Class<?> mainClass) {
            return this.runAsUserWithCurrentClassPath(mainClass, Collections.emptyList());
        }

        public ProcessBuilder runAsUserWithCurrentClassPath(Class<?> mainClass, List<String> args) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(User.getCurrentJvm());
            cmd.add("-cp");
            cmd.add(System.getProperty("java.class.path"));
            cmd.add(mainClass.getName());
            cmd.addAll(args);
            return this.runAs(cmd);
        }

        public ProcessBuilder runAs(List<String> cmd) {
            if (!this.canSwitchToUser) {
                throw new IllegalStateException(String.format("Cannot run as user %s", this.username));
            }
            ArrayList<String> fullCmd = new ArrayList<String>();
            fullCmd.add("sudo");
            fullCmd.add("--non-interactive");
            fullCmd.add("-u");
            fullCmd.add(this.username);
            fullCmd.addAll(cmd);
            return new ProcessBuilder(fullCmd);
        }

        public boolean canSwitchToUser() {
            return this.canSwitchToUser;
        }

        public boolean isCurrentUser() {
            return this.username.equals(UserRegistry.getCurrentUserName());
        }

        public String getUsername() {
            return this.username;
        }
    }
}

