/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.android.plugin.tasks;

import co.elastic.apm.android.common.MethodCaller;
import co.elastic.apm.android.common.okhttp.eventlistener.CompositeEventListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import okhttp3.EventListener;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public abstract class OkHttpEventlistenerGenerator
extends DefaultTask {
    @Input
    public abstract Property<String> getJvmTargetVersion();

    @InputFiles
    public abstract ConfigurableFileCollection getAppRuntimeClasspath();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public void action() {
        String name = CompositeEventListener.getGeneratedName();
        byte[] bytes = this.getByteBuddy().subclass(CompositeEventListener.class).name(name).method((ElementMatcher)ElementMatchers.isDeclaredBy((TypeDescription)this.getEventListenerFromProject()).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isStatic())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isConstructor()))).intercept((Implementation)Advice.to(CompositeEventListenerAdvice.class)).make().getBytes();
        String filePath = name.replaceAll("\\.", "/") + ".class";
        this.storeClassFile(bytes, filePath);
    }

    private TypeDescription getEventListenerFromProject() {
        TypePool typePool = this.getTypePool(this.getAppRuntimeClasspath().getFiles());
        return typePool.describe(EventListener.class.getName()).resolve();
    }

    private TypePool getTypePool(Set<File> dependencies) {
        ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
        try {
            for (File dependency : dependencies) {
                if (!dependency.isFile()) continue;
                classFileLocators.add(ClassFileLocator.ForJarFile.of((File)dependency));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return TypePool.Default.of((ClassFileLocator)new ClassFileLocator.Compound(classFileLocators));
    }

    private ByteBuddy getByteBuddy() {
        ClassFileVersion classFileVersion = ClassFileVersion.ofJavaVersionString((String)((String)this.getJvmTargetVersion().get()));
        return new ByteBuddy(classFileVersion);
    }

    private void storeClassFile(byte[] classBytes, String relativePath) {
        boolean dirsCreated;
        File file = new File(((Directory)this.getOutputDir().get()).getAsFile(), relativePath);
        if (!file.getParentFile().exists() && !(dirsCreated = file.getParentFile().mkdirs())) {
            throw new RuntimeException("Could not create dirs for " + relativePath);
        }
        try {
            Files.write(file.toPath(), classBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CompositeEventListenerAdvice {
        @Advice.OnMethodEnter
        public static void onEnter(@Advice.This MethodCaller owner, @Advice.Origin Method self, @Advice.AllArguments Object[] args) {
            owner.doCall(self, args);
        }
    }
}

