/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.android.plugin;

import co.elastic.apm.android.agp.api.AgpCompatibilityEntrypoint;
import co.elastic.apm.android.agp.api.AgpCompatibilityManager;
import co.elastic.apm.android.agp.api.tools.ClasspathProvider;
import co.elastic.apm.android.agp.api.usecase.ApmInfoUseCase;
import co.elastic.apm.android.common.internal.logging.ELoggerFactory;
import co.elastic.apm.android.common.internal.logging.Elog;
import co.elastic.apm.android.plugin.extensions.ElasticApmExtension;
import co.elastic.apm.android.plugin.instrumentation.ElasticLocalInstrumentationFactory;
import co.elastic.apm.android.plugin.logging.GradleLoggerFactory;
import co.elastic.apm.android.plugin.tasks.OkHttpEventlistenerGenerator;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.BaseExtension;
import kotlin.Unit;
import net.bytebuddy.build.gradle.android.ByteBuddyAndroidPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.TaskProvider;

class ApmAndroidAgentPlugin
implements Plugin<Project> {
    private Project project;
    private BaseExtension androidExtension;
    private ElasticApmExtension defaultExtension;
    private AgpCompatibilityManager compatibleManager;

    ApmAndroidAgentPlugin() {
    }

    public void apply(Project project) {
        this.project = project;
        Elog.init((ELoggerFactory)new GradleLoggerFactory());
        this.androidExtension = (BaseExtension)project.getExtensions().getByType(BaseExtension.class);
        this.compatibleManager = AgpCompatibilityEntrypoint.findCompatibleManager((Project)project);
        this.initializeElasticExtension(project);
        this.addBytebuddyPlugin();
        this.addSdkDependency();
        this.addInstrumentationDependency();
        this.addTasks();
        this.applyCompatibleUseCases();
    }

    private void initializeElasticExtension(Project project) {
        this.defaultExtension = (ElasticApmExtension)project.getExtensions().create("elasticApm", ElasticApmExtension.class, new Object[0]);
        this.defaultExtension.getServiceName().convention(project.provider(() -> this.androidExtension.getDefaultConfig().getApplicationId()));
        this.defaultExtension.getServiceVersion().convention(project.provider(() -> this.androidExtension.getDefaultConfig().getVersionName()));
    }

    private void addBytebuddyPlugin() {
        this.project.getPluginManager().apply(ByteBuddyAndroidPlugin.class);
    }

    private void addSdkDependency() {
        this.project.getDependencies().add("implementation", (Object)"co.elastic.apm:android-sdk:0.7.0");
        if (this.kotlinPluginFound()) {
            this.project.getDependencies().add("implementation", (Object)"co.elastic.apm:android-sdk-ktx:0.7.0");
        }
    }

    private boolean kotlinPluginFound() {
        return this.project.getExtensions().findByName("kotlin") != null;
    }

    private void addInstrumentationDependency() {
        this.project.getDependencies().add("byteBuddy", (Object)"co.elastic.apm:android-instrumentation:0.7.0");
    }

    private void addTasks() {
        ExtensionContainer extensions = this.project.getExtensions();
        ApplicationAndroidComponentsExtension extension = (ApplicationAndroidComponentsExtension)extensions.getByType(ApplicationAndroidComponentsExtension.class);
        extension.onVariants(extension.selector().all(), this::enhanceVariant);
    }

    private void enhanceVariant(ApplicationVariant applicationVariant) {
        this.addOkhttpEventListenerGenerator(applicationVariant, this.compatibleManager.getClasspathProvider());
        this.addLocalRemapping(applicationVariant);
    }

    private void addLocalRemapping(ApplicationVariant applicationVariant) {
        applicationVariant.getInstrumentation().transformClassesWith(ElasticLocalInstrumentationFactory.class, InstrumentationScope.PROJECT, none -> Unit.INSTANCE);
    }

    private void addOkhttpEventListenerGenerator(ApplicationVariant applicationVariant, ClasspathProvider classpathProvider) {
        TaskProvider taskProvider = this.project.getTasks().register(applicationVariant.getName() + "GenerateOkhttpEventListener", OkHttpEventlistenerGenerator.class);
        taskProvider.configure(task -> {
            task.getOutputDir().set(this.project.getLayout().getBuildDirectory().dir(task.getName()));
            task.getAppRuntimeClasspath().from(new Object[]{classpathProvider.getRuntimeClasspath((Variant)applicationVariant)});
            task.getJvmTargetVersion().set((Object)this.androidExtension.getCompileOptions().getTargetCompatibility().toString());
        });
        applicationVariant.getArtifacts().use(taskProvider).wiredWith(OkHttpEventlistenerGenerator::getOutputDir).toAppendTo((Artifact.Multiple)MultipleArtifact.ALL_CLASSES_DIRS.INSTANCE);
    }

    private void applyCompatibleUseCases() {
        ApmInfoUseCase apmInfoUseCase = this.compatibleManager.getApmInfoUseCase(parameters -> {
            parameters.getServiceName().set(this.defaultExtension.getServiceName());
            parameters.getServiceVersion().set(this.defaultExtension.getServiceVersion());
            parameters.getServerUrl().set(this.defaultExtension.getServerUrl());
            parameters.getSecretToken().set(this.defaultExtension.getSecretToken());
            parameters.getApiKey().set(this.defaultExtension.getApiKey());
            parameters.getClasspathProvider().set((Object)this.compatibleManager.getClasspathProvider());
        });
        apmInfoUseCase.execute();
    }
}

