/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kwikpicker;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorRes;
import androidx.appcompat.app.AppCompatDialog;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import co.csadev.kwikpicker.GridSpacingItemDecoration;
import co.csadev.kwikpicker.KwikPicker;
import co.csadev.kwikpicker.R;
import co.csadev.kwikpicker.adapter.ImageGalleryAdapter;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u009d\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\n\u0018\u00002\u00020\u0001:\u0001PB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u000fH\u0002J\b\u0010-\u001a\u00020.H\u0002J\u0012\u0010/\u001a\u00020.2\b\u0010,\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u00100\u001a\u00020.2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u00102\u001a\u00020.2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u00103\u001a\u00020.2\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00062\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0012\u00108\u001a\u00020.2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u00109\u001a\u00020.2\b\u00106\u001a\u0004\u0018\u000107H\u0002J\u0012\u0010:\u001a\u00020.2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\b\u0010=\u001a\u00020.H\u0002J\u0010\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020<H\u0016J\u0010\u0010@\u001a\u00020.2\u0006\u0010,\u001a\u00020\u000fH\u0002J\b\u0010A\u001a\u00020.H\u0002J\b\u0010B\u001a\u00020.H\u0002J\b\u0010C\u001a\u00020.H\u0002J\b\u0010D\u001a\u00020.H\u0002J\u0018\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0006H\u0016J\u000e\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020KJ\b\u0010L\u001a\u00020.H\u0002J\b\u0010M\u001a\u00020.H\u0002J\b\u0010N\u001a\u00020.H\u0002J\b\u0010O\u001a\u00020.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lco/csadev/kwikpicker/KwikPicker;", "Lcom/google/android/material/bottomsheet/BottomSheetDialogFragment;", "()V", "EXTRA_CAMERA_IMAGE_URI", "", "REQ_CODE_CAMERA", "", "REQ_CODE_GALLERY", "TAG", "bottomSheetBehaviorCallback", "co/csadev/kwikpicker/KwikPicker$bottomSheetBehaviorCallback$1", "Lco/csadev/kwikpicker/KwikPicker$bottomSheetBehaviorCallback$1;", "builder", "Lco/csadev/kwikpicker/KwikPicker$Builder;", "cameraImageUri", "Landroid/net/Uri;", "contentView", "Landroid/view/View;", "doneButton", "Landroid/widget/Button;", "galleryRecycler", "Landroidx/recyclerview/widget/RecyclerView;", "imageFile", "Ljava/io/File;", "getImageFile", "()Ljava/io/File;", "imageGalleryAdapter", "Lco/csadev/kwikpicker/adapter/ImageGalleryAdapter;", "isMultiSelect", "", "()Z", "selectedPhotosContainer", "Landroid/widget/LinearLayout;", "selectedPhotosContainerFrame", "Landroid/widget/FrameLayout;", "selectedPhotosEmpty", "Landroid/widget/TextView;", "selectedPhotosHorizontal", "Landroid/widget/HorizontalScrollView;", "selectedUriList", "Ljava/util/ArrayList;", "titleText", "viewTitleContainer", "addUri", "uri", "checkMultiMode", "", "complete", "errorMessage", "message", "initView", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onActivityResultCamera", "onActivityResultGallery", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onMultiSelectComplete", "onSaveInstanceState", "outState", "removeImage", "setDoneButton", "setRecyclerView", "setSelectionView", "setTitle", "setupDialog", "dialog", "Landroid/app/Dialog;", "style", "show", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "startCameraIntent", "startGalleryIntent", "updateAdapter", "updateSelectedView", "Builder", "kwikpicker_release"})
public final class KwikPicker
extends BottomSheetDialogFragment {
    private final String TAG = "Kwik";
    private final int REQ_CODE_CAMERA = 1;
    private final int REQ_CODE_GALLERY = 2;
    private final String EXTRA_CAMERA_IMAGE_URI = "camera_image_uri";
    private Builder builder;
    private ImageGalleryAdapter imageGalleryAdapter;
    private View viewTitleContainer;
    private TextView titleText;
    private Button doneButton;
    private FrameLayout selectedPhotosContainerFrame;
    private HorizontalScrollView selectedPhotosHorizontal;
    private LinearLayout selectedPhotosContainer;
    private TextView selectedPhotosEmpty;
    private View contentView;
    private ArrayList<Uri> selectedUriList = new ArrayList();
    private Uri cameraImageUri;
    private RecyclerView galleryRecycler;
    private final bottomSheetBehaviorCallback.1 bottomSheetBehaviorCallback = new BottomSheetBehavior.BottomSheetCallback(this){
        final /* synthetic */ KwikPicker this$0;

        public void onStateChanged(@NotNull View bottomSheet, int newState) {
            Intrinsics.checkParameterIsNotNull((Object)bottomSheet, (String)"bottomSheet");
            if (newState == 5) {
                this.this$0.dismissAllowingStateLoss();
            }
        }

        public void onSlide(@NotNull View bottomSheet, float slideOffset) {
            Intrinsics.checkParameterIsNotNull((Object)bottomSheet, (String)"bottomSheet");
        }
        {
            this.this$0 = $outer;
        }
    };

    private final File getImageFile() {
        File imageFile = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_";
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            imageFile = File.createTempFile(imageFileName, ".jpg", storageDir);
            this.cameraImageUri = Uri.fromFile((File)imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorMessage("Could not create imageFile for camera");
        }
        return imageFile;
    }

    private final boolean isMultiSelect() {
        Builder builder = this.builder;
        return (builder != null ? builder.getOnMultiImageSelectedListener() : null) != null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = savedInstanceState;
        this.cameraImageUri = bundle != null ? (Uri)bundle.getParcelable(this.EXTRA_CAMERA_IMAGE_URI) : null;
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        outState.putParcelable(this.EXTRA_CAMERA_IMAGE_URI, (Parcelable)this.cameraImageUri);
        super.onSaveInstanceState(outState);
    }

    public final void show(@NotNull FragmentManager fragmentManager) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentManager, (String)"fragmentManager");
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.add((Fragment)this, this.getTag());
        ft.commitAllowingStateLoss();
    }

    public void setupDialog(@NotNull Dialog dialog, int style) {
        Intrinsics.checkParameterIsNotNull((Object)dialog, (String)"dialog");
        AppCompatDialog acd = (AppCompatDialog)dialog;
        switch (style) {
            case 3: {
                Window window = ((AppCompatDialog)dialog).getWindow();
                if (window != null) {
                    window.addFlags(24);
                }
                break;
            }
            case 1: 
            case 2: {
                acd.supportRequestWindowFeature(1);
            }
        }
        View view = View.inflate((Context)this.getContext(), (int)R.layout.kwik_picker_content_view, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"View.inflate(context, R.\u2026icker_content_view, null)");
        View view2 = this.contentView = view;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentView");
        }
        dialog.setContentView(view2);
        View view3 = this.contentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentView");
        }
        ViewParent viewParent = view3.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.View");
        }
        ViewGroup.LayoutParams layoutParams = ((View)viewParent).getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.coordinatorlayout.widget.CoordinatorLayout.LayoutParams");
        }
        CoordinatorLayout.LayoutParams layoutParams2 = (CoordinatorLayout.LayoutParams)layoutParams;
        CoordinatorLayout.Behavior behavior = layoutParams2.getBehavior();
        if (behavior != null && behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).setBottomSheetCallback((BottomSheetBehavior.BottomSheetCallback)this.bottomSheetBehaviorCallback);
            Builder builder = this.builder;
            if ((builder != null ? builder.getPeekHeight() : 0) > 0) {
                Builder builder2 = this.builder;
                ((BottomSheetBehavior)behavior).setPeekHeight(builder2 != null ? builder2.getPeekHeight() : 0);
            }
        }
        View view4 = this.contentView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentView");
        }
        this.initView(view4);
        this.setTitle();
        this.setRecyclerView();
        this.setSelectionView();
        this.setDoneButton();
        this.checkMultiMode();
    }

    private final void setSelectionView() {
        Builder builder = this.builder;
        if ((builder != null ? builder.getEmptySelectionText() : null) != null) {
            TextView textView = this.selectedPhotosEmpty;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosEmpty");
            }
            Builder builder2 = this.builder;
            textView.setText((CharSequence)(builder2 != null ? builder2.getEmptySelectionText() : null));
        }
    }

    private final void setDoneButton() {
        Builder builder = this.builder;
        if ((builder != null ? builder.getCompleteButtonText() : null) != null) {
            Button button = this.doneButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
            }
            Builder builder2 = this.builder;
            button.setText((CharSequence)(builder2 != null ? builder2.getCompleteButtonText() : null));
        }
        Button button = this.doneButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
        }
        button.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ KwikPicker this$0;

            public final void onClick(View it) {
                KwikPicker.access$onMultiSelectComplete(this.this$0);
            }
            {
                this.this$0 = kwikPicker;
            }
        });
    }

    private final void onMultiSelectComplete() {
        ArrayList<Uri> arrayList;
        Builder builder = this.builder;
        if (this.selectedUriList.size() < (builder != null ? builder.getSelectMinCount() : -1)) {
            Object object = this.builder;
            if (object == null || (object = ((Builder)object).getSelectMinCountErrorText()) == null) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = this.getResources().getString(R.string.select_min_count);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(R.string.select_min_count)");
                String string3 = string2;
                Object[] objectArray = new Object[1];
                Builder builder2 = this.builder;
                objectArray[0] = builder2 != null ? Integer.valueOf(builder2.getSelectMinCount()) : Integer.valueOf(-1);
                Object[] objectArray2 = objectArray;
                String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                object = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            }
            Object message = object;
            Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)((CharSequence)message), (int)0).show();
            return;
        }
        ArrayList<Uri> it = arrayList = this.selectedUriList;
        Function1<ArrayList<Uri>, Unit> function1 = this.builder;
        if (function1 != null && (function1 = function1.getOnMultiImageSelectedListener()) != null) {
            Unit cfr_ignored_0 = (Unit)function1.invoke(it);
        }
        this.dismissAllowingStateLoss();
    }

    private final void checkMultiMode() {
        if (!this.isMultiSelect()) {
            Button button = this.doneButton;
            if (button == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"doneButton");
            }
            button.setVisibility(8);
            FrameLayout frameLayout = this.selectedPhotosContainerFrame;
            if (frameLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainerFrame");
            }
            frameLayout.setVisibility(8);
        }
    }

    private final void initView(View contentView) {
        View view = contentView.findViewById(R.id.view_title_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"contentView.findViewById\u2026.id.view_title_container)");
        this.viewTitleContainer = view;
        View view2 = contentView.findViewById(R.id.rc_gallery);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView");
        }
        this.galleryRecycler = (RecyclerView)view2;
        View view3 = contentView.findViewById(R.id.tv_title);
        if (view3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        this.titleText = (TextView)view3;
        View view4 = contentView.findViewById(R.id.btn_done);
        if (view4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.Button");
        }
        this.doneButton = (Button)view4;
        View view5 = contentView.findViewById(R.id.selected_photos_container_frame);
        if (view5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout");
        }
        this.selectedPhotosContainerFrame = (FrameLayout)view5;
        View view6 = contentView.findViewById(R.id.hsv_selected_photos);
        if (view6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.HorizontalScrollView");
        }
        this.selectedPhotosHorizontal = (HorizontalScrollView)view6;
        View view7 = contentView.findViewById(R.id.selected_photos_container);
        if (view7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
        }
        this.selectedPhotosContainer = (LinearLayout)view7;
        View view8 = contentView.findViewById(R.id.selected_photos_empty);
        if (view8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
        }
        this.selectedPhotosEmpty = (TextView)view8;
    }

    private final void setRecyclerView() {
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 3);
        RecyclerView recyclerView = this.galleryRecycler;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        }
        RecyclerView recyclerView2 = this.galleryRecycler;
        if (recyclerView2 != null) {
            Builder builder = this.builder;
            recyclerView2.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), builder != null ? builder.getSpacing() : 1, false));
        }
        this.updateAdapter();
    }

    private final void updateAdapter() {
        Context context = this.getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context!!");
        this.imageGalleryAdapter = new ImageGalleryAdapter(context, this.builder);
        RecyclerView recyclerView = this.galleryRecycler;
        if (recyclerView != null) {
            ImageGalleryAdapter imageGalleryAdapter = this.imageGalleryAdapter;
            if (imageGalleryAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageGalleryAdapter");
            }
            recyclerView.setAdapter((RecyclerView.Adapter)imageGalleryAdapter);
        }
        ImageGalleryAdapter imageGalleryAdapter = this.imageGalleryAdapter;
        if (imageGalleryAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageGalleryAdapter");
        }
        imageGalleryAdapter.setOnItemClickListener(new ImageGalleryAdapter.OnItemClickListener(this){
            final /* synthetic */ KwikPicker this$0;

            public void onItemClick(@NotNull View view, int position) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                ImageGalleryAdapter.PickerTile pickerTile = KwikPicker.access$getImageGalleryAdapter$p(this.this$0).getItem(position);
                switch (pickerTile.getTileType()) {
                    case 2: {
                        KwikPicker.access$startCameraIntent(this.this$0);
                        break;
                    }
                    case 3: {
                        KwikPicker.access$startGalleryIntent(this.this$0);
                        break;
                    }
                    case 1: {
                        KwikPicker.access$complete(this.this$0, pickerTile.getImageUri());
                        break;
                    }
                    default: {
                        KwikPicker.errorMessage$default(this.this$0, null, 1, null);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void complete(Uri uri) {
        StringBuilder stringBuilder = new StringBuilder().append("selected uri: ");
        Uri uri2 = uri;
        if (uri2 == null) {
            Intrinsics.throwNpe();
        }
        Log.d((String)this.TAG, (String)stringBuilder.append(uri2.toString()).toString());
        if (this.isMultiSelect()) {
            if (this.selectedUriList.contains(uri)) {
                this.removeImage(uri);
            } else {
                this.addUri(uri);
            }
        } else {
            Function1<Uri, Unit> function1 = this.builder;
            if (function1 != null && (function1 = function1.getOnImageSelectedListener()) != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)uri);
            }
            this.dismissAllowingStateLoss();
        }
    }

    private final boolean addUri(Uri uri) {
        Builder builder;
        Builder builder2 = this.builder;
        if (this.selectedUriList.size() == (builder2 != null ? builder2.getSelectMaxCount() : -1)) {
            String string2;
            Builder builder3 = this.builder;
            if ((builder3 != null ? builder3.getSelectMaxCountErrorText() : null) != null) {
                Builder builder4 = this.builder;
                string2 = builder4 != null ? builder4.getSelectMaxCountErrorText() : null;
            } else {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string3 = this.getResources().getString(R.string.select_max_count);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"resources.getString(R.string.select_max_count)");
                String string4 = string3;
                Object[] objectArray = new Object[1];
                Builder builder5 = this.builder;
                objectArray[0] = builder5 != null ? Integer.valueOf(builder5.getSelectMaxCount()) : Integer.valueOf(-1);
                Object[] objectArray2 = objectArray;
                String string5 = String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length));
                string2 = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
            }
            String message = string2;
            Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)message, (int)0).show();
            return false;
        }
        this.selectedUriList.add(uri);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)((Context)this.getActivity()));
        LinearLayout linearLayout = this.selectedPhotosContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
        }
        View rootView = layoutInflater.inflate(R.layout.kwik_picker_selected_item, (ViewGroup)linearLayout, false);
        View view = rootView.findViewById(R.id.selected_photo);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.ImageView");
        }
        ImageView thumbnail = (ImageView)view;
        View view2 = rootView.findViewById(R.id.iv_close);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.ImageView");
        }
        ImageView closeImage = (ImageView)view2;
        View view3 = rootView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"rootView");
        view3.setTag((Object)uri);
        LinearLayout linearLayout2 = this.selectedPhotosContainer;
        if (linearLayout2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
        }
        linearLayout2.addView(rootView, 0);
        int px = (int)this.getResources().getDimension(R.dimen.kwik_picker_selected_image_height);
        thumbnail.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(px, px));
        Function2<ImageView, Uri, Unit> function2 = this.builder;
        if (function2 != null && (function2 = function2.getImageProvider()) != null) {
            Unit cfr_ignored_0 = (Unit)function2.invoke((Object)thumbnail, (Object)uri);
        }
        if ((builder = this.builder) != null && (builder = builder.getDeSelectIconDrawable()) != null) {
            Builder builder6;
            Builder it = builder6 = builder;
            closeImage.setImageDrawable((Drawable)it);
        }
        closeImage.setOnClickListener(new View.OnClickListener(this, uri){
            final /* synthetic */ KwikPicker this$0;
            final /* synthetic */ Uri $uri;

            public final void onClick(View it) {
                KwikPicker.access$removeImage(this.this$0, this.$uri);
            }
            {
                this.this$0 = kwikPicker;
                this.$uri = uri;
            }
        });
        this.updateSelectedView();
        ImageGalleryAdapter imageGalleryAdapter = this.imageGalleryAdapter;
        if (imageGalleryAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageGalleryAdapter");
        }
        imageGalleryAdapter.setSelectedUriList(this.selectedUriList, uri);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeImage(Uri uri) {
        this.selectedUriList.remove(uri);
        int n = 0;
        LinearLayout linearLayout = this.selectedPhotosContainer;
        if (linearLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
        }
        int n2 = linearLayout.getChildCount();
        while (n < n2) {
            void i;
            View childView;
            LinearLayout linearLayout2 = this.selectedPhotosContainer;
            if (linearLayout2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
            }
            View view = childView = linearLayout2.getChildAt((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"childView");
            if (Intrinsics.areEqual((Object)view.getTag(), (Object)uri)) {
                LinearLayout linearLayout3 = this.selectedPhotosContainer;
                if (linearLayout3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
                }
                linearLayout3.removeViewAt((int)i);
                break;
            }
            ++i;
        }
        this.updateSelectedView();
        ImageGalleryAdapter imageGalleryAdapter = this.imageGalleryAdapter;
        if (imageGalleryAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageGalleryAdapter");
        }
        imageGalleryAdapter.setSelectedUriList(this.selectedUriList, uri);
    }

    private final void updateSelectedView() {
        if (this.selectedUriList.size() == 0) {
            TextView textView = this.selectedPhotosEmpty;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosEmpty");
            }
            textView.setVisibility(0);
            LinearLayout linearLayout = this.selectedPhotosContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
            }
            linearLayout.setVisibility(8);
        } else {
            TextView textView = this.selectedPhotosEmpty;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosEmpty");
            }
            textView.setVisibility(8);
            LinearLayout linearLayout = this.selectedPhotosContainer;
            if (linearLayout == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"selectedPhotosContainer");
            }
            linearLayout.setVisibility(0);
        }
    }

    private final void startCameraIntent() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"activity!!");
        if (cameraIntent.resolveActivity(fragmentActivity.getPackageManager()) == null) {
            this.errorMessage("This Application do not have Camera Application");
            return;
        }
        File imageFile = this.getImageFile();
        Context context = this.getContext();
        if (context == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Context context2 = this.getContext();
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context!!");
        Context context3 = context2.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context!!.applicationContext");
        String string2 = stringBuilder.append(context3.getPackageName()).append(".provider").toString();
        File file = imageFile;
        if (file == null) {
            Intrinsics.throwNpe();
        }
        Uri photoURI = FileProvider.getUriForFile((Context)context, (String)string2, (File)file);
        cameraIntent.putExtra("output", (Parcelable)photoURI);
        this.startActivityForResult(cameraIntent, this.REQ_CODE_CAMERA);
    }

    private final void errorMessage(String message) {
        block2: {
            String errorMessage;
            block1: {
                String string2 = message;
                if (string2 == null) {
                    string2 = "Something went wrong.";
                }
                errorMessage = string2;
                Builder builder = this.builder;
                if ((builder != null ? builder.getOnErrorListener() : null) != null) break block1;
                Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)errorMessage, (int)0).show();
                break block2;
            }
            Function1<String, Unit> function1 = this.builder;
            if (function1 == null || (function1 = function1.getOnErrorListener()) == null) break block2;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)errorMessage);
        }
    }

    static /* bridge */ /* synthetic */ void errorMessage$default(KwikPicker kwikPicker, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        kwikPicker.errorMessage(string);
    }

    private final void startGalleryIntent() {
        Intent galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        FragmentActivity fragmentActivity = this.getActivity();
        if (galleryIntent.resolveActivity((PackageManager)(fragmentActivity != null ? fragmentActivity.getPackageManager() : null)) == null) {
            this.errorMessage("This Application does not have Gallery Application");
            return;
        }
        this.startActivityForResult(galleryIntent, this.REQ_CODE_GALLERY);
    }

    private final void setTitle() {
        Builder builder = this.builder;
        if (builder == null || !builder.getShowTitle()) {
            TextView textView = this.titleText;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            }
            textView.setVisibility(8);
            if (!this.isMultiSelect()) {
                View view = this.viewTitleContainer;
                if (view == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewTitleContainer");
                }
                view.setVisibility(8);
            }
            return;
        }
        Builder builder2 = this.builder;
        if (!TextUtils.isEmpty((CharSequence)(builder2 != null ? builder2.getTitle() : null))) {
            TextView textView = this.titleText;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            }
            Builder builder3 = this.builder;
            textView.setText((CharSequence)(builder3 != null ? builder3.getTitle() : null));
        }
        Builder builder4 = this.builder;
        if ((builder4 != null ? builder4.getTitleBackgroundResId() : 0) > 0) {
            TextView textView = this.titleText;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"titleText");
            }
            Builder builder5 = this.builder;
            textView.setBackgroundResource(builder5 != null ? builder5.getTitleBackgroundResId() : 0);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            return;
        }
        int n = requestCode;
        if (n == this.REQ_CODE_GALLERY) {
            this.onActivityResultGallery(data);
        } else if (n == this.REQ_CODE_CAMERA) {
            this.onActivityResultCamera(this.cameraImageUri);
        } else {
            KwikPicker.errorMessage$default(this, null, 1, null);
        }
    }

    private final void onActivityResultCamera(Uri cameraImageUri) {
        Context context = this.getContext();
        String[] stringArray = new String[1];
        Uri uri = cameraImageUri;
        if (uri == null) {
            Intrinsics.throwNpe();
        }
        stringArray[0] = uri.getPath();
        MediaScannerConnection.scanFile((Context)context, (String[])stringArray, (String[])new String[]{"image/jpeg"}, (MediaScannerConnection.OnScanCompletedListener)((MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.MediaScannerConnectionClient(this, cameraImageUri){
            final /* synthetic */ KwikPicker this$0;
            final /* synthetic */ Uri $cameraImageUri;

            public void onMediaScannerConnected() {
            }

            public void onScanCompleted(@NotNull String s, @NotNull Uri uri) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                    FragmentActivity fragmentActivity = this.this$0.getActivity();
                    if (fragmentActivity == null) break block0;
                    fragmentActivity.runOnUiThread(new Runnable(this){
                        final /* synthetic */ onActivityResultCamera.1 this$0;

                        public final void run() {
                            KwikPicker.access$updateAdapter(this.this$0.this$0);
                            KwikPicker.access$complete(this.this$0.this$0, this.this$0.$cameraImageUri);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = $outer;
                this.$cameraImageUri = $captured_local_variable$1;
            }
        }));
    }

    private final void onActivityResultGallery(Intent data) {
        Uri uri;
        Uri temp;
        Intent intent = data;
        Object object = temp = intent != null ? intent.getData() : null;
        if (temp == null) {
            KwikPicker.errorMessage$default(this, null, 1, null);
            return;
        }
        try {
            uri = Uri.fromFile((File)new File(URI.create(temp.getEncodedPath())));
        }
        catch (Exception ex) {
            uri = temp;
        }
        Uri selectedImageUri = uri;
        this.complete(selectedImageUri);
    }

    @Nullable
    public static final /* synthetic */ Builder access$getBuilder$p(KwikPicker $this) {
        return $this.builder;
    }

    public static final /* synthetic */ void access$onMultiSelectComplete(KwikPicker $this) {
        $this.onMultiSelectComplete();
    }

    @NotNull
    public static final /* synthetic */ ImageGalleryAdapter access$getImageGalleryAdapter$p(KwikPicker $this) {
        ImageGalleryAdapter imageGalleryAdapter = $this.imageGalleryAdapter;
        if (imageGalleryAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageGalleryAdapter");
        }
        return imageGalleryAdapter;
    }

    public static final /* synthetic */ void access$setImageGalleryAdapter$p(KwikPicker $this, @NotNull ImageGalleryAdapter imageGalleryAdapter) {
        $this.imageGalleryAdapter = imageGalleryAdapter;
    }

    public static final /* synthetic */ void access$startCameraIntent(KwikPicker $this) {
        $this.startCameraIntent();
    }

    public static final /* synthetic */ void access$startGalleryIntent(KwikPicker $this) {
        $this.startGalleryIntent();
    }

    public static final /* synthetic */ void access$complete(KwikPicker $this, @Nullable Uri uri) {
        $this.complete(uri);
    }

    public static final /* synthetic */ void access$removeImage(KwikPicker $this, @NotNull Uri uri) {
        $this.removeImage(uri);
    }

    public static final /* synthetic */ void access$updateAdapter(KwikPicker $this) {
        $this.updateAdapter();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\bK\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u009c\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00128\u0010\u0004\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u000e\u0012%\b\u0002\u0010\u0015\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016\u0012+\b\u0002\u0010\u0018\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u0019\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016\u0012%\b\u0002\u0010\u001b\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u0012\b\b\u0002\u0010 \u001a\u00020\u001f\u0012\b\b\u0002\u0010!\u001a\u00020\u000e\u0012\b\b\u0003\u0010\"\u001a\u00020\u000e\u0012\b\b\u0003\u0010#\u001a\u00020\u000e\u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u001c\u0012\b\b\u0002\u0010%\u001a\u00020\u001f\u0012\b\b\u0002\u0010&\u001a\u00020\u000e\u0012\b\b\u0002\u0010'\u001a\u00020\u000e\u0012\b\b\u0002\u0010(\u001a\u00020\u000e\u0012\n\b\u0002\u0010)\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u001c\u0012\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010-J\u000e\u0010j\u001a\u00020k2\u0006\u0010\u0002\u001a\u00020\u0003R\u001a\u0010\"\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u0010)\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00103\"\u0004\b;\u00105R\u001c\u0010*\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u00107\"\u0004\b=\u00109R\u001a\u0010#\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010/\"\u0004\b?\u00101R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00103\"\u0004\bA\u00105RL\u0010\u0004\u001a4\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER7\u0010\u001b\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR7\u0010\u0015\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010G\"\u0004\bK\u0010IR=\u0010\u0018\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\n0\u0019\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\f\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010G\"\u0004\bM\u0010IR\u001a\u0010!\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010/\"\u0004\bO\u00101R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010/\"\u0004\bQ\u00101R\u001a\u0010'\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010/\"\u0004\bS\u00101R\u001c\u0010+\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u00107\"\u0004\bU\u00109R\u001a\u0010(\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010/\"\u0004\bW\u00101R\u001c\u0010,\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u00107\"\u0004\bY\u00109R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u00103\"\u0004\b[\u00105R\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R\u001a\u0010 \u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010]\"\u0004\ba\u0010_R\u001a\u0010%\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010]\"\u0004\bc\u0010_R\u001a\u0010\u0014\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010/\"\u0004\be\u00101R\u001c\u0010$\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u00107\"\u0004\bg\u00109R\u001a\u0010&\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010/\"\u0004\bi\u00101\u00a8\u0006l"}, d2={"Lco/csadev/kwikpicker/KwikPicker$Builder;", "", "context", "Landroid/content/Context;", "imageProvider", "Lkotlin/Function2;", "Landroid/widget/ImageView;", "Lkotlin/ParameterName;", "name", "imageView", "Landroid/net/Uri;", "imageUri", "", "previewMaxCount", "", "cameraTileDrawable", "Landroid/graphics/drawable/Drawable;", "galleryTileDrawable", "deSelectIconDrawable", "selectedForegroundDrawable", "spacing", "onImageSelectedListener", "Lkotlin/Function1;", "uri", "onMultiImageSelectedListener", "Ljava/util/ArrayList;", "uriList", "onErrorListener", "", "message", "showCamera", "", "showGallery", "peekHeight", "cameraTileBackgroundResId", "galleryTileBackgroundResId", "title", "showTitle", "titleBackgroundResId", "selectMaxCount", "selectMinCount", "completeButtonText", "emptySelectionText", "selectMaxCountErrorText", "selectMinCountErrorText", "(Landroid/content/Context;Lkotlin/jvm/functions/Function2;ILandroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;Landroid/graphics/drawable/Drawable;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;ZZIIILjava/lang/String;ZIIILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCameraTileBackgroundResId", "()I", "setCameraTileBackgroundResId", "(I)V", "getCameraTileDrawable", "()Landroid/graphics/drawable/Drawable;", "setCameraTileDrawable", "(Landroid/graphics/drawable/Drawable;)V", "getCompleteButtonText", "()Ljava/lang/String;", "setCompleteButtonText", "(Ljava/lang/String;)V", "getDeSelectIconDrawable", "setDeSelectIconDrawable", "getEmptySelectionText", "setEmptySelectionText", "getGalleryTileBackgroundResId", "setGalleryTileBackgroundResId", "getGalleryTileDrawable", "setGalleryTileDrawable", "getImageProvider", "()Lkotlin/jvm/functions/Function2;", "setImageProvider", "(Lkotlin/jvm/functions/Function2;)V", "getOnErrorListener", "()Lkotlin/jvm/functions/Function1;", "setOnErrorListener", "(Lkotlin/jvm/functions/Function1;)V", "getOnImageSelectedListener", "setOnImageSelectedListener", "getOnMultiImageSelectedListener", "setOnMultiImageSelectedListener", "getPeekHeight", "setPeekHeight", "getPreviewMaxCount", "setPreviewMaxCount", "getSelectMaxCount", "setSelectMaxCount", "getSelectMaxCountErrorText", "setSelectMaxCountErrorText", "getSelectMinCount", "setSelectMinCount", "getSelectMinCountErrorText", "setSelectMinCountErrorText", "getSelectedForegroundDrawable", "setSelectedForegroundDrawable", "getShowCamera", "()Z", "setShowCamera", "(Z)V", "getShowGallery", "setShowGallery", "getShowTitle", "setShowTitle", "getSpacing", "setSpacing", "getTitle", "setTitle", "getTitleBackgroundResId", "setTitleBackgroundResId", "create", "Lco/csadev/kwikpicker/KwikPicker;", "kwikpicker_release"})
    public static final class Builder {
        @NotNull
        private Function2<? super ImageView, ? super Uri, Unit> imageProvider;
        private int previewMaxCount;
        @Nullable
        private Drawable cameraTileDrawable;
        @Nullable
        private Drawable galleryTileDrawable;
        @Nullable
        private Drawable deSelectIconDrawable;
        @Nullable
        private Drawable selectedForegroundDrawable;
        private int spacing;
        @Nullable
        private Function1<? super Uri, Unit> onImageSelectedListener;
        @Nullable
        private Function1<? super ArrayList<Uri>, Unit> onMultiImageSelectedListener;
        @Nullable
        private Function1<? super String, Unit> onErrorListener;
        private boolean showCamera;
        private boolean showGallery;
        private int peekHeight;
        private int cameraTileBackgroundResId;
        private int galleryTileBackgroundResId;
        @Nullable
        private String title;
        private boolean showTitle;
        private int titleBackgroundResId;
        private int selectMaxCount;
        private int selectMinCount;
        @Nullable
        private String completeButtonText;
        @Nullable
        private String emptySelectionText;
        @Nullable
        private String selectMaxCountErrorText;
        @Nullable
        private String selectMinCountErrorText;

        @NotNull
        public final KwikPicker create(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT >= 16 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                throw (Throwable)new RuntimeException("Missing required WRITE_EXTERNAL_STORAGE permission. Did you remember to request it first?");
            }
            if (this.onImageSelectedListener == null && this.onMultiImageSelectedListener == null) {
                throw (Throwable)new RuntimeException("You have to use setOnImageSelectedListener() or setOnMultiImageSelectedListener() for receive selected Uri");
            }
            KwikPicker customBottomSheetDialogFragment = new KwikPicker();
            customBottomSheetDialogFragment.builder = this;
            return customBottomSheetDialogFragment;
        }

        @NotNull
        public final Function2<ImageView, Uri, Unit> getImageProvider() {
            return this.imageProvider;
        }

        public final void setImageProvider(@NotNull Function2<? super ImageView, ? super Uri, Unit> function2) {
            Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
            this.imageProvider = function2;
        }

        public final int getPreviewMaxCount() {
            return this.previewMaxCount;
        }

        public final void setPreviewMaxCount(int n) {
            this.previewMaxCount = n;
        }

        @Nullable
        public final Drawable getCameraTileDrawable() {
            return this.cameraTileDrawable;
        }

        public final void setCameraTileDrawable(@Nullable Drawable drawable2) {
            this.cameraTileDrawable = drawable2;
        }

        @Nullable
        public final Drawable getGalleryTileDrawable() {
            return this.galleryTileDrawable;
        }

        public final void setGalleryTileDrawable(@Nullable Drawable drawable2) {
            this.galleryTileDrawable = drawable2;
        }

        @Nullable
        public final Drawable getDeSelectIconDrawable() {
            return this.deSelectIconDrawable;
        }

        public final void setDeSelectIconDrawable(@Nullable Drawable drawable2) {
            this.deSelectIconDrawable = drawable2;
        }

        @Nullable
        public final Drawable getSelectedForegroundDrawable() {
            return this.selectedForegroundDrawable;
        }

        public final void setSelectedForegroundDrawable(@Nullable Drawable drawable2) {
            this.selectedForegroundDrawable = drawable2;
        }

        public final int getSpacing() {
            return this.spacing;
        }

        public final void setSpacing(int n) {
            this.spacing = n;
        }

        @Nullable
        public final Function1<Uri, Unit> getOnImageSelectedListener() {
            return this.onImageSelectedListener;
        }

        public final void setOnImageSelectedListener(@Nullable Function1<? super Uri, Unit> function1) {
            this.onImageSelectedListener = function1;
        }

        @Nullable
        public final Function1<ArrayList<Uri>, Unit> getOnMultiImageSelectedListener() {
            return this.onMultiImageSelectedListener;
        }

        public final void setOnMultiImageSelectedListener(@Nullable Function1<? super ArrayList<Uri>, Unit> function1) {
            this.onMultiImageSelectedListener = function1;
        }

        @Nullable
        public final Function1<String, Unit> getOnErrorListener() {
            return this.onErrorListener;
        }

        public final void setOnErrorListener(@Nullable Function1<? super String, Unit> function1) {
            this.onErrorListener = function1;
        }

        public final boolean getShowCamera() {
            return this.showCamera;
        }

        public final void setShowCamera(boolean bl) {
            this.showCamera = bl;
        }

        public final boolean getShowGallery() {
            return this.showGallery;
        }

        public final void setShowGallery(boolean bl) {
            this.showGallery = bl;
        }

        public final int getPeekHeight() {
            return this.peekHeight;
        }

        public final void setPeekHeight(int n) {
            this.peekHeight = n;
        }

        public final int getCameraTileBackgroundResId() {
            return this.cameraTileBackgroundResId;
        }

        public final void setCameraTileBackgroundResId(int n) {
            this.cameraTileBackgroundResId = n;
        }

        public final int getGalleryTileBackgroundResId() {
            return this.galleryTileBackgroundResId;
        }

        public final void setGalleryTileBackgroundResId(int n) {
            this.galleryTileBackgroundResId = n;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(@Nullable String string) {
            this.title = string;
        }

        public final boolean getShowTitle() {
            return this.showTitle;
        }

        public final void setShowTitle(boolean bl) {
            this.showTitle = bl;
        }

        public final int getTitleBackgroundResId() {
            return this.titleBackgroundResId;
        }

        public final void setTitleBackgroundResId(int n) {
            this.titleBackgroundResId = n;
        }

        public final int getSelectMaxCount() {
            return this.selectMaxCount;
        }

        public final void setSelectMaxCount(int n) {
            this.selectMaxCount = n;
        }

        public final int getSelectMinCount() {
            return this.selectMinCount;
        }

        public final void setSelectMinCount(int n) {
            this.selectMinCount = n;
        }

        @Nullable
        public final String getCompleteButtonText() {
            return this.completeButtonText;
        }

        public final void setCompleteButtonText(@Nullable String string) {
            this.completeButtonText = string;
        }

        @Nullable
        public final String getEmptySelectionText() {
            return this.emptySelectionText;
        }

        public final void setEmptySelectionText(@Nullable String string) {
            this.emptySelectionText = string;
        }

        @Nullable
        public final String getSelectMaxCountErrorText() {
            return this.selectMaxCountErrorText;
        }

        public final void setSelectMaxCountErrorText(@Nullable String string) {
            this.selectMaxCountErrorText = string;
        }

        @Nullable
        public final String getSelectMinCountErrorText() {
            return this.selectMinCountErrorText;
        }

        public final void setSelectMinCountErrorText(@Nullable String string) {
            this.selectMinCountErrorText = string;
        }

        public Builder(@NotNull Context context, @NotNull Function2<? super ImageView, ? super Uri, Unit> imageProvider, int previewMaxCount, @Nullable Drawable cameraTileDrawable, @Nullable Drawable galleryTileDrawable, @Nullable Drawable deSelectIconDrawable, @Nullable Drawable selectedForegroundDrawable, int spacing, @Nullable Function1<? super Uri, Unit> onImageSelectedListener, @Nullable Function1<? super ArrayList<Uri>, Unit> onMultiImageSelectedListener, @Nullable Function1<? super String, Unit> onErrorListener, boolean showCamera, boolean showGallery, int peekHeight, @ColorRes int cameraTileBackgroundResId, @ColorRes int galleryTileBackgroundResId, @Nullable String title, boolean showTitle, int titleBackgroundResId, int selectMaxCount, int selectMinCount, @Nullable String completeButtonText, @Nullable String emptySelectionText, @Nullable String selectMaxCountErrorText, @Nullable String selectMinCountErrorText) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(imageProvider, (String)"imageProvider");
            this.imageProvider = imageProvider;
            this.previewMaxCount = previewMaxCount;
            this.cameraTileDrawable = cameraTileDrawable;
            this.galleryTileDrawable = galleryTileDrawable;
            this.deSelectIconDrawable = deSelectIconDrawable;
            this.selectedForegroundDrawable = selectedForegroundDrawable;
            this.spacing = spacing;
            this.onImageSelectedListener = onImageSelectedListener;
            this.onMultiImageSelectedListener = onMultiImageSelectedListener;
            this.onErrorListener = onErrorListener;
            this.showCamera = showCamera;
            this.showGallery = showGallery;
            this.peekHeight = peekHeight;
            this.cameraTileBackgroundResId = cameraTileBackgroundResId;
            this.galleryTileBackgroundResId = galleryTileBackgroundResId;
            this.title = title;
            this.showTitle = showTitle;
            this.titleBackgroundResId = titleBackgroundResId;
            this.selectMaxCount = selectMaxCount;
            this.selectMinCount = selectMinCount;
            this.completeButtonText = completeButtonText;
            this.emptySelectionText = emptySelectionText;
            this.selectMaxCountErrorText = selectMaxCountErrorText;
            this.selectMinCountErrorText = selectMinCountErrorText;
        }

        public /* synthetic */ Builder(Context context, Function2 function2, int n, Drawable drawable2, Drawable drawable3, Drawable drawable4, Drawable drawable5, int n2, Function1 function1, Function1 function12, Function1 function13, boolean bl, boolean bl2, int n3, int n4, int n5, String string, boolean bl3, int n6, int n7, int n8, String string2, String string3, String string4, String string5, int n9, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n9 & 4) != 0) {
                n = 25;
            }
            if ((n9 & 8) != 0) {
                drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_camera);
            }
            if ((n9 & 0x10) != 0) {
                drawable3 = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_gallery);
            }
            if ((n9 & 0x20) != 0) {
                drawable4 = null;
            }
            if ((n9 & 0x40) != 0) {
                drawable5 = null;
            }
            if ((n9 & 0x80) != 0) {
                n2 = context.getResources().getDimensionPixelSize(R.dimen.kwik_picker_grid_layout_margin);
            }
            if ((n9 & 0x100) != 0) {
                function1 = null;
            }
            if ((n9 & 0x200) != 0) {
                function12 = null;
            }
            if ((n9 & 0x400) != 0) {
                function13 = null;
            }
            if ((n9 & 0x800) != 0) {
                bl = true;
            }
            if ((n9 & 0x1000) != 0) {
                bl2 = true;
            }
            if ((n9 & 0x2000) != 0) {
                n3 = -1;
            }
            if ((n9 & 0x4000) != 0) {
                n4 = R.color.kwik_picker_camera;
            }
            if ((n9 & 0x8000) != 0) {
                n5 = R.color.kwik_picker_gallery;
            }
            if ((n9 & 0x10000) != 0) {
                string = null;
            }
            if ((n9 & 0x20000) != 0) {
                bl3 = true;
            }
            if ((n9 & 0x40000) != 0) {
                n6 = 0;
            }
            if ((n9 & 0x80000) != 0) {
                n7 = Integer.MAX_VALUE;
            }
            if ((n9 & 0x100000) != 0) {
                n8 = 0;
            }
            if ((n9 & 0x200000) != 0) {
                string2 = "Done";
            }
            if ((n9 & 0x400000) != 0) {
                string3 = "No Image";
            }
            if ((n9 & 0x800000) != 0) {
                string4 = null;
            }
            if ((n9 & 0x1000000) != 0) {
                string5 = null;
            }
            this(context, (Function2<? super ImageView, ? super Uri, Unit>)function2, n, drawable2, drawable3, drawable4, drawable5, n2, (Function1<? super Uri, Unit>)function1, (Function1<? super ArrayList<Uri>, Unit>)function12, (Function1<? super String, Unit>)function13, bl, bl2, n3, n4, n5, string, bl3, n6, n7, n8, string2, string3, string4, string5);
        }
    }
}

