/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u0016\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bJ\u0006\u0010$\u001a\u00020\bJ\u0006\u0010%\u001a\u00020\bJ\u0016\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\bJ\u0016\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\bJ\u0016\u0010*\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\n\u00a8\u0006,"}, d2={"Lco/csadev/kellocharts/util/ChartUtils;", "", "()V", "COLORS", "", "getCOLORS", "()[I", "COLOR_BLUE", "", "getCOLOR_BLUE", "()I", "COLOR_GREEN", "getCOLOR_GREEN", "COLOR_INDEX", "COLOR_ORANGE", "getCOLOR_ORANGE", "COLOR_RED", "getCOLOR_RED", "COLOR_VIOLET", "getCOLOR_VIOLET", "DARKEN_INTENSITY", "", "DARKEN_SATURATION", "DEFAULT_COLOR", "getDEFAULT_COLOR", "DEFAULT_DARKEN_COLOR", "getDEFAULT_DARKEN_COLOR", "darkenColor", "color", "dp2px", "density", "dp", "mm2px", "context", "Landroid/content/Context;", "mm", "nextColor", "pickColor", "px2dp", "px", "px2sp", "scaledDensity", "sp2px", "sp", "kellocharts_release"})
public final class ChartUtils {
    private static final int DEFAULT_COLOR;
    private static final int DEFAULT_DARKEN_COLOR;
    private static final int COLOR_BLUE;
    private static final int COLOR_VIOLET;
    private static final int COLOR_GREEN;
    private static final int COLOR_ORANGE;
    private static final int COLOR_RED;
    @NotNull
    private static final int[] COLORS;
    private static final float DARKEN_SATURATION = 1.1f;
    private static final float DARKEN_INTENSITY = 0.9f;
    private static int COLOR_INDEX;
    public static final ChartUtils INSTANCE;

    public final int getDEFAULT_COLOR() {
        return DEFAULT_COLOR;
    }

    public final int getDEFAULT_DARKEN_COLOR() {
        return DEFAULT_DARKEN_COLOR;
    }

    public final int getCOLOR_BLUE() {
        return COLOR_BLUE;
    }

    public final int getCOLOR_VIOLET() {
        return COLOR_VIOLET;
    }

    public final int getCOLOR_GREEN() {
        return COLOR_GREEN;
    }

    public final int getCOLOR_ORANGE() {
        return COLOR_ORANGE;
    }

    public final int getCOLOR_RED() {
        return COLOR_RED;
    }

    @NotNull
    public final int[] getCOLORS() {
        return COLORS;
    }

    public final int pickColor() {
        return COLORS[(int)Math.round(Math.random() * (double)(COLORS.length - 1))];
    }

    public final int nextColor() {
        if (COLOR_INDEX >= COLORS.length) {
            COLOR_INDEX = 0;
        }
        int n = COLOR_INDEX;
        COLOR_INDEX = n + 1;
        return COLORS[n];
    }

    public final int dp2px(float density, int dp) {
        return dp == 0 ? 0 : (int)((float)dp * density + 0.5f);
    }

    public final int px2dp(float density, int px) {
        return (int)Math.ceil((float)px / density);
    }

    public final int sp2px(float scaledDensity, int sp) {
        return sp == 0 ? 0 : (int)((float)sp * scaledDensity + 0.5f);
    }

    public final int px2sp(float scaledDensity, int px) {
        return (int)Math.ceil((float)px / scaledDensity);
    }

    public final int mm2px(@NotNull Context context, int mm) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        float f = mm;
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (int)(TypedValue.applyDimension((int)5, (float)f, (DisplayMetrics)resources.getDisplayMetrics()) + 0.5f);
    }

    public final int darkenColor(int color) {
        float[] hsv = new float[3];
        int alpha = Color.alpha((int)color);
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = Math.min(hsv[1] * DARKEN_SATURATION, 1.0f);
        hsv[2] = hsv[2] * DARKEN_INTENSITY;
        int tempColor = Color.HSVToColor((float[])hsv);
        return Color.argb((int)alpha, (int)Color.red((int)tempColor), (int)Color.green((int)tempColor), (int)Color.blue((int)tempColor));
    }

    private ChartUtils() {
    }

    static {
        ChartUtils chartUtils;
        INSTANCE = chartUtils = new ChartUtils();
        DEFAULT_COLOR = Color.parseColor((String)"#DFDFDF");
        DEFAULT_DARKEN_COLOR = Color.parseColor((String)"#DDDDDD");
        COLOR_BLUE = Color.parseColor((String)"#33B5E5");
        COLOR_VIOLET = Color.parseColor((String)"#AA66CC");
        COLOR_GREEN = Color.parseColor((String)"#99CC00");
        COLOR_ORANGE = Color.parseColor((String)"#FFBB33");
        COLOR_RED = Color.parseColor((String)"#FF4444");
        COLORS = new int[]{COLOR_BLUE, COLOR_VIOLET, COLOR_GREEN, COLOR_ORANGE, COLOR_RED};
        DARKEN_SATURATION = 1.1f;
        DARKEN_INTENSITY = 0.9f;
    }
}

