/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.provider.LineChartDataProvider;
import co.csadev.kellocharts.renderer.LineChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lco/csadev/kellocharts/renderer/PreviewLineChartRenderer;", "Lco/csadev/kellocharts/renderer/LineChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "dataProvider", "Lco/csadev/kellocharts/provider/LineChartDataProvider;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;Lco/csadev/kellocharts/provider/LineChartDataProvider;)V", "color", "", "previewColor", "getPreviewColor", "()I", "setPreviewColor", "(I)V", "previewPaint", "Landroid/graphics/Paint;", "drawUnclipped", "", "canvas", "Landroid/graphics/Canvas;", "Companion", "kellocharts_release"})
public final class PreviewLineChartRenderer
extends LineChartRenderer {
    private final Paint previewPaint;
    private static final int DEFAULT_PREVIEW_TRANSPARENCY = 64;
    private static final int FULL_ALPHA = 255;
    private static final int DEFAULT_PREVIEW_STROKE_WIDTH_DP = 2;
    public static final Companion Companion = new Companion(null);

    public final int getPreviewColor() {
        return this.previewPaint.getColor();
    }

    public final void setPreviewColor(int color) {
        this.previewPaint.setColor(color);
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.drawUnclipped(canvas);
        Viewport currentViewport = this.getComputator().getCurrentViewport$kellocharts_release();
        float left = this.getComputator().computeRawX(currentViewport.getLeft());
        float top = this.getComputator().computeRawY(currentViewport.getTop());
        float right = this.getComputator().computeRawX(currentViewport.getRight());
        float bottom = this.getComputator().computeRawY(currentViewport.getBottom());
        this.previewPaint.setAlpha(DEFAULT_PREVIEW_TRANSPARENCY);
        this.previewPaint.setStyle(Paint.Style.FILL);
        canvas.drawRect(left, top, right, bottom, this.previewPaint);
        this.previewPaint.setStyle(Paint.Style.STROKE);
        this.previewPaint.setAlpha(FULL_ALPHA);
        canvas.drawRect(left, top, right, bottom, this.previewPaint);
    }

    public PreviewLineChartRenderer(@NotNull Context context, @NotNull Chart chart, @NotNull LineChartDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super(context, chart, dataProvider);
        this.previewPaint = new Paint();
        this.previewPaint.setAntiAlias(true);
        this.previewPaint.setColor(-3355444);
        this.previewPaint.setStrokeWidth((float)ChartUtils.INSTANCE.dp2px(this.getDensity(), DEFAULT_PREVIEW_STROKE_WIDTH_DP));
    }

    static {
        DEFAULT_PREVIEW_TRANSPARENCY = 64;
        FULL_ALPHA = 255;
        DEFAULT_PREVIEW_STROKE_WIDTH_DP = 2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/renderer/PreviewLineChartRenderer$Companion;", "", "()V", "DEFAULT_PREVIEW_STROKE_WIDTH_DP", "", "DEFAULT_PREVIEW_TRANSPARENCY", "FULL_ALPHA", "kellocharts_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

