/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.text.TextUtils;
import co.csadev.kellocharts.formatter.PieChartValueFormatter;
import co.csadev.kellocharts.model.PieChartData;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.SliceValue;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.provider.PieChartDataProvider;
import co.csadev.kellocharts.renderer.AbstractChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0002J\u0018\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\fH\u0016J\u0010\u0010?\u001a\u00020:2\u0006\u0010@\u001a\u000203H\u0016J\u0010\u0010A\u001a\u00020:2\u0006\u0010@\u001a\u000203H\u0002J(\u0010B\u001a\u00020:2\u0006\u0010@\u001a\u0002032\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\fH\u0002J\u000e\u0010G\u001a\u00020:2\u0006\u0010@\u001a\u000203J\u0010\u0010H\u001a\u00020:2\u0006\u0010@\u001a\u000203H\u0002J0\u0010I\u001a\u00020:2\u0006\u0010@\u001a\u0002032\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\f2\u0006\u0010J\u001a\u00020\u0013H\u0002J\u0010\u0010K\u001a\u00020:2\u0006\u0010@\u001a\u000203H\u0002J\u0010\u0010L\u001a\u00020:2\u0006\u0010@\u001a\u000203H\u0016J\u001a\u0010M\u001a\u0004\u0018\u00010D2\u0006\u0010F\u001a\u00020\u00132\b\u0010N\u001a\u0004\u0018\u00010OJ\u0010\u0010P\u001a\u00020:2\u0006\u0010Q\u001a\u00020/H\u0002J\b\u0010R\u001a\u00020:H\u0016J\b\u0010S\u001a\u00020:H\u0016J\b\u0010T\u001a\u00020:H\u0016J(\u0010U\u001a\u00020\f2\u0006\u0010V\u001a\u00020\f2\u0006\u0010W\u001a\u00020\f2\u0006\u0010X\u001a\u00020\f2\u0006\u0010Y\u001a\u00020\fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lco/csadev/kellocharts/renderer/PieChartRenderer;", "Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "dataProvider", "Lco/csadev/kellocharts/provider/PieChartDataProvider;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;Lco/csadev/kellocharts/provider/PieChartDataProvider;)V", "centerCirclePaint", "Landroid/graphics/Paint;", "centerCircleScale", "", "centerCircleText1FontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "centerCircleText1Paint", "centerCircleText2FontMetrics", "centerCircleText2Paint", "rotation", "", "chartRotation", "getChartRotation", "()I", "setChartRotation", "(I)V", "value", "circleFillRatio", "getCircleFillRatio", "()F", "setCircleFillRatio", "(F)V", "circleOval", "Landroid/graphics/RectF;", "getCircleOval", "()Landroid/graphics/RectF;", "setCircleOval", "(Landroid/graphics/RectF;)V", "drawCircleOval", "hasCenterCircle", "", "hasLabels", "hasLabelsOnlyForSelected", "hasLabelsOutside", "maxSum", "separationLinesPaint", "slicePaint", "sliceVector", "Landroid/graphics/PointF;", "softwareBitmap", "Landroid/graphics/Bitmap;", "softwareCanvas", "Landroid/graphics/Canvas;", "tempMaximumViewport", "Lco/csadev/kellocharts/model/Viewport;", "touchAdditional", "valueFormatter", "Lco/csadev/kellocharts/formatter/PieChartValueFormatter;", "calculateCircleOval", "", "calculateMaxViewport", "checkTouch", "touchX", "touchY", "draw", "canvas", "drawCenterCircle", "drawLabel", "sliceValue", "Lco/csadev/kellocharts/model/SliceValue;", "lastAngle", "angle", "drawLabels", "drawSeparationLines", "drawSlice", "mode", "drawSlices", "drawUnclipped", "getValueForAngle", "selectedValue", "Lco/csadev/kellocharts/model/SelectedValue;", "normalizeVector", "point", "onChartDataChanged", "onChartSizeChanged", "onChartViewportChanged", "pointToAngle", "x", "y", "centerX", "centerY", "Companion", "kellocharts_release"})
public final class PieChartRenderer
extends AbstractChartRenderer {
    private int chartRotation;
    private final Paint slicePaint;
    private float maxSum;
    @NotNull
    private RectF circleOval;
    private final RectF drawCircleOval;
    private final PointF sliceVector;
    private final int touchAdditional;
    private float circleFillRatio;
    private boolean hasCenterCircle;
    private float centerCircleScale;
    private final Paint centerCirclePaint;
    private final Paint centerCircleText1Paint;
    private final Paint.FontMetricsInt centerCircleText1FontMetrics;
    private final Paint centerCircleText2Paint;
    private final Paint.FontMetricsInt centerCircleText2FontMetrics;
    private final Paint separationLinesPaint;
    private boolean hasLabelsOutside;
    private boolean hasLabels;
    private boolean hasLabelsOnlyForSelected;
    private PieChartValueFormatter valueFormatter;
    private final Viewport tempMaximumViewport;
    private Bitmap softwareBitmap;
    private final Canvas softwareCanvas;
    private final PieChartDataProvider dataProvider;
    private static final float MAX_WIDTH_HEIGHT = 100.0f;
    private static final int DEFAULT_START_ROTATION = 45;
    private static final float DEFAULT_LABEL_INSIDE_RADIUS_FACTOR = 0.7f;
    private static final float DEFAULT_LABEL_OUTSIDE_RADIUS_FACTOR = 1.0f;
    private static final int DEFAULT_TOUCH_ADDITIONAL_DP = 8;
    private static final int MODE_DRAW = 0;
    private static final int MODE_HIGHLIGHT = 1;
    public static final Companion Companion = new Companion(null);

    public final int getChartRotation() {
        return this.chartRotation;
    }

    public final void setChartRotation(int rotation) {
        int rotation2 = rotation;
        this.chartRotation = rotation2 = (rotation2 % 360 + 360) % 360;
    }

    @NotNull
    public final RectF getCircleOval() {
        return this.circleOval;
    }

    public final void setCircleOval(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.circleOval = rectF;
    }

    public final float getCircleFillRatio() {
        return this.circleFillRatio;
    }

    public final void setCircleFillRatio(float value) {
        this.circleFillRatio = Math.min(1.0f, Math.max(0.0f, value));
        this.calculateCircleOval();
    }

    @Override
    public void onChartSizeChanged() {
        this.calculateCircleOval();
        if (this.getComputator().getChartWidth() > 0 && this.getComputator().getChartHeight() > 0) {
            this.softwareBitmap = Bitmap.createBitmap((int)this.getComputator().getChartWidth(), (int)this.getComputator().getChartHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.softwareCanvas.setBitmap(this.softwareBitmap);
        }
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        PieChartData data = this.dataProvider.getPieChartData();
        this.hasLabelsOutside = data.getHasLabelsOutside();
        this.hasLabels = data.getHasLabels();
        this.hasLabelsOnlyForSelected = data.getHasLabelsOnlyForSelected();
        this.valueFormatter = data.getFormatter();
        this.hasCenterCircle = data.getHasCenterCircle();
        this.centerCircleScale = data.getCenterCircleScale();
        this.centerCirclePaint.setColor(data.getCenterCircleColor());
        if (data.getCenterText1Typeface() != null) {
            this.centerCircleText1Paint.setTypeface(data.getCenterText1Typeface());
        }
        this.centerCircleText1Paint.setTextSize((float)ChartUtils.INSTANCE.sp2px(this.getScaledDensity(), data.getCenterText1FontSize()));
        this.centerCircleText1Paint.setColor(data.getCenterText1Color());
        this.centerCircleText1Paint.getFontMetricsInt(this.centerCircleText1FontMetrics);
        if (data.getCenterText2Typeface() != null) {
            this.centerCircleText2Paint.setTypeface(data.getCenterText2Typeface());
        }
        this.centerCircleText2Paint.setTextSize((float)ChartUtils.INSTANCE.sp2px(this.getScaledDensity(), data.getCenterText2FontSize()));
        this.centerCircleText2Paint.setColor(data.getCenterText2Color());
        this.centerCircleText2Paint.getFontMetricsInt(this.centerCircleText2FontMetrics);
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled()) {
            this.calculateMaxViewport();
            this.getComputator().setMaximumViewport$kellocharts_release(this.tempMaximumViewport);
            this.getComputator().setCurrentViewport$kellocharts_release(this.getComputator().getMaximumViewport());
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Canvas drawCanvas;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.softwareBitmap != null) {
            drawCanvas = this.softwareCanvas;
            drawCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        } else {
            drawCanvas = canvas;
        }
        this.drawSlices(drawCanvas);
        this.drawSeparationLines(drawCanvas);
        if (this.hasCenterCircle) {
            this.drawCenterCircle(drawCanvas);
        }
        this.drawLabels(drawCanvas);
        if (this.softwareBitmap != null) {
            Bitmap bitmap = this.softwareBitmap;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        this.getSelectedValue().clear();
        PieChartData data = this.dataProvider.getPieChartData();
        float centerX = this.circleOval.centerX();
        float centerY = this.circleOval.centerY();
        float circleRadius = this.circleOval.width() / 2.0f;
        this.sliceVector.set(touchX - centerX, touchY - centerY);
        if (this.sliceVector.length() > circleRadius + (float)this.touchAdditional) {
            return false;
        }
        if (data.getHasCenterCircle() && this.sliceVector.length() < circleRadius * data.getCenterCircleScale()) {
            return false;
        }
        float touchAngle = (this.pointToAngle(touchX, touchY, centerX, centerY) - (float)this.chartRotation + 360.0f) % 360.0f;
        float sliceScale = 360.0f / this.maxSum;
        float lastAngle = 0.0f;
        int sliceIndex = 0;
        for (SliceValue sliceValue : data.getValues()) {
            float angle = Math.abs(sliceValue.getValue()) * sliceScale;
            if (touchAngle >= lastAngle) {
                this.getSelectedValue().set(sliceIndex, sliceIndex, SelectedValue.SelectedValueType.NONE);
            }
            lastAngle += angle;
            ++sliceIndex;
        }
        return this.isTouched();
    }

    private final void drawCenterCircle(Canvas canvas) {
        PieChartData data = this.dataProvider.getPieChartData();
        float circleRadius = this.circleOval.width() / 2.0f;
        float centerRadius = circleRadius * data.getCenterCircleScale();
        float centerX = this.circleOval.centerX();
        float centerY = this.circleOval.centerY();
        canvas.drawCircle(centerX, centerY, centerRadius, this.centerCirclePaint);
        if (!TextUtils.isEmpty((CharSequence)data.getCenterText1())) {
            int text1Height = Math.abs(this.centerCircleText1FontMetrics.ascent);
            if (!TextUtils.isEmpty((CharSequence)data.getCenterText2())) {
                int text2Height = Math.abs(this.centerCircleText2FontMetrics.ascent);
                String string = data.getCenterText1();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawText(string, centerX, centerY - (float)text1Height * 0.2f, this.centerCircleText1Paint);
                String string2 = data.getCenterText2();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawText(string2, centerX, centerY + (float)text2Height, this.centerCircleText2Paint);
            } else {
                String string = data.getCenterText1();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawText(string, centerX, centerY + (float)(text1Height / 4), this.centerCircleText1Paint);
            }
        }
    }

    private final void drawSlices(Canvas canvas) {
        PieChartData data = this.dataProvider.getPieChartData();
        float sliceScale = 360.0f / this.maxSum;
        float lastAngle = this.chartRotation;
        int sliceIndex = 0;
        for (SliceValue sliceValue : data.getValues()) {
            float angle = Math.abs(sliceValue.getValue()) * sliceScale;
            if (this.isTouched() && this.getSelectedValue().getFirstIndex() == sliceIndex) {
                this.drawSlice(canvas, sliceValue, lastAngle, angle, MODE_HIGHLIGHT);
            } else {
                this.drawSlice(canvas, sliceValue, lastAngle, angle, MODE_DRAW);
            }
            lastAngle += angle;
            ++sliceIndex;
        }
    }

    private final void drawSeparationLines(Canvas canvas) {
        PieChartData data = this.dataProvider.getPieChartData();
        if (data.getValues().size() < 2) {
            return;
        }
        int sliceSpacing = ChartUtils.INSTANCE.dp2px(this.getDensity(), data.getSliceSpacing());
        if (sliceSpacing < 1) {
            return;
        }
        float sliceScale = 360.0f / this.maxSum;
        float lastAngle = this.chartRotation;
        float circleRadius = this.circleOval.width() / 2.0f;
        this.separationLinesPaint.setStrokeWidth((float)sliceSpacing);
        for (SliceValue sliceValue : data.getValues()) {
            float angle = Math.abs(sliceValue.getValue()) * sliceScale;
            this.sliceVector.set((float)Math.cos(Math.toRadians(lastAngle)), (float)Math.sin(Math.toRadians(lastAngle)));
            this.normalizeVector(this.sliceVector);
            float x1 = this.sliceVector.x * (circleRadius + (float)this.touchAdditional) + this.circleOval.centerX();
            float y1 = this.sliceVector.y * (circleRadius + (float)this.touchAdditional) + this.circleOval.centerY();
            canvas.drawLine(this.circleOval.centerX(), this.circleOval.centerY(), x1, y1, this.separationLinesPaint);
            lastAngle += angle;
        }
    }

    public final void drawLabels(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        PieChartData data = this.dataProvider.getPieChartData();
        float sliceScale = 360.0f / this.maxSum;
        float lastAngle = this.chartRotation;
        int sliceIndex = 0;
        for (SliceValue sliceValue : data.getValues()) {
            float angle = Math.abs(sliceValue.getValue()) * sliceScale;
            if (this.isTouched()) {
                if (this.hasLabels) {
                    this.drawLabel(canvas, sliceValue, lastAngle, angle);
                } else if (this.hasLabelsOnlyForSelected && this.getSelectedValue().getFirstIndex() == sliceIndex) {
                    this.drawLabel(canvas, sliceValue, lastAngle, angle);
                }
            } else if (this.hasLabels) {
                this.drawLabel(canvas, sliceValue, lastAngle, angle);
            }
            lastAngle += angle;
            ++sliceIndex;
        }
    }

    private final void drawSlice(Canvas canvas, SliceValue sliceValue, float lastAngle, float angle, int mode) {
        this.sliceVector.set((float)Math.cos(Math.toRadians(lastAngle + angle / (float)2)), (float)Math.sin(Math.toRadians(lastAngle + angle / (float)2)));
        this.normalizeVector(this.sliceVector);
        this.drawCircleOval.set(this.circleOval);
        if (MODE_HIGHLIGHT == mode) {
            this.drawCircleOval.inset((float)(-this.touchAdditional), (float)(-this.touchAdditional));
            this.slicePaint.setColor(sliceValue.getDarkenColor());
            canvas.drawArc(this.drawCircleOval, lastAngle, angle, true, this.slicePaint);
        } else {
            this.slicePaint.setColor(sliceValue.getColor());
            canvas.drawArc(this.drawCircleOval, lastAngle, angle, true, this.slicePaint);
        }
    }

    private final void drawLabel(Canvas canvas, SliceValue sliceValue, float lastAngle, float angle) {
        float bottom;
        float top;
        float right;
        float left;
        int numChars;
        this.sliceVector.set((float)Math.cos(Math.toRadians(lastAngle + angle / (float)2)), (float)Math.sin(Math.toRadians(lastAngle + angle / (float)2)));
        this.normalizeVector(this.sliceVector);
        PieChartValueFormatter pieChartValueFormatter = this.valueFormatter;
        if (pieChartValueFormatter == null) {
            Intrinsics.throwNpe();
        }
        if ((numChars = pieChartValueFormatter.formatChartValue(this.getLabelBuffer(), sliceValue)) == 0) {
            return;
        }
        float labelWidth = this.getLabelPaint().measureText(this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars);
        int labelHeight = Math.abs(this.getFontMetrics().ascent);
        float centerX = this.circleOval.centerX();
        float centerY = this.circleOval.centerY();
        float circleRadius = this.circleOval.width() / 2.0f;
        float labelRadius = this.hasLabelsOutside ? circleRadius * DEFAULT_LABEL_OUTSIDE_RADIUS_FACTOR : (this.hasCenterCircle ? circleRadius - (circleRadius - circleRadius * this.centerCircleScale) / (float)2 : circleRadius * DEFAULT_LABEL_INSIDE_RADIUS_FACTOR);
        float rawX = labelRadius * this.sliceVector.x + centerX;
        float rawY = labelRadius * this.sliceVector.y + centerY;
        if (this.hasLabelsOutside) {
            if (rawX > centerX) {
                left = rawX + (float)this.getLabelMargin();
                right = rawX + labelWidth + (float)(this.getLabelMargin() * 3);
            } else {
                left = rawX - labelWidth - (float)(this.getLabelMargin() * 3);
                right = rawX - (float)this.getLabelMargin();
            }
            if (rawY > centerY) {
                top = rawY + (float)this.getLabelMargin();
                bottom = rawY + (float)labelHeight + (float)(this.getLabelMargin() * 3);
            } else {
                top = rawY - (float)labelHeight - (float)(this.getLabelMargin() * 3);
                bottom = rawY - (float)this.getLabelMargin();
            }
        } else {
            left = rawX - labelWidth / (float)2 - (float)this.getLabelMargin();
            right = rawX + labelWidth / (float)2 + (float)this.getLabelMargin();
            top = rawY - (float)(labelHeight / 2) - (float)this.getLabelMargin();
            bottom = rawY + (float)(labelHeight / 2) + (float)this.getLabelMargin();
        }
        this.getLabelBackgroundRect().set(left, top, right, bottom);
        this.drawLabelTextAndBackground(canvas, this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars, sliceValue.getDarkenColor());
    }

    private final void normalizeVector(PointF point) {
        float abs = point.length();
        point.set(point.x / abs, point.y / abs);
    }

    private final float pointToAngle(float x, float y, float centerX, float centerY) {
        double diffX = x - centerX;
        double diffY = y - centerY;
        double radian = Math.atan2(-diffX, diffY);
        float angle = ((float)Math.toDegrees(radian) + (float)360) % (float)360;
        return angle += 90.0f;
    }

    private final void calculateCircleOval() {
        Rect contentRect = this.getComputator().getContentRectMinusAllMargins();
        float circleRadius = Math.min((float)contentRect.width() / 2.0f, (float)contentRect.height() / 2.0f);
        float centerX = contentRect.centerX();
        float centerY = contentRect.centerY();
        float left = centerX - circleRadius + (float)this.touchAdditional;
        float top = centerY - circleRadius + (float)this.touchAdditional;
        float right = centerX + circleRadius - (float)this.touchAdditional;
        float bottom = centerY + circleRadius - (float)this.touchAdditional;
        this.circleOval.set(left, top, right, bottom);
        float inest = 0.5f * this.circleOval.width() * (1.0f - this.circleFillRatio);
        this.circleOval.inset(inest, inest);
    }

    private final void calculateMaxViewport() {
        ViewportKt.set(this.tempMaximumViewport, Float.valueOf(0.0f), Float.valueOf(MAX_WIDTH_HEIGHT), Float.valueOf(MAX_WIDTH_HEIGHT), Float.valueOf(0.0f));
        this.maxSum = 0.0f;
        for (SliceValue sliceValue : this.dataProvider.getPieChartData().getValues()) {
            this.maxSum += Math.abs(sliceValue.getValue());
        }
    }

    @Nullable
    public final SliceValue getValueForAngle(int angle, @Nullable SelectedValue selectedValue) {
        PieChartData data = this.dataProvider.getPieChartData();
        float touchAngle = ((float)(angle - this.chartRotation) + 360.0f) % 360.0f;
        float sliceScale = 360.0f / this.maxSum;
        float lastAngle = 0.0f;
        int sliceIndex = 0;
        for (SliceValue sliceValue : data.getValues()) {
            float tempAngle = Math.abs(sliceValue.getValue()) * sliceScale;
            if (touchAngle >= lastAngle) {
                if (selectedValue != null) {
                    selectedValue.set(sliceIndex, sliceIndex, SelectedValue.SelectedValueType.NONE);
                }
                return sliceValue;
            }
            lastAngle += tempAngle;
            ++sliceIndex;
        }
        return null;
    }

    public PieChartRenderer(@NotNull Context context, @NotNull Chart chart, @NotNull PieChartDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super(context, chart);
        this.dataProvider = dataProvider;
        this.chartRotation = DEFAULT_START_ROTATION;
        this.slicePaint = new Paint();
        this.circleOval = new RectF();
        this.drawCircleOval = new RectF();
        this.sliceVector = new PointF();
        this.circleFillRatio = 1.0f;
        this.centerCirclePaint = new Paint();
        this.centerCircleText1Paint = new Paint();
        this.centerCircleText1FontMetrics = new Paint.FontMetricsInt();
        this.centerCircleText2Paint = new Paint();
        this.centerCircleText2FontMetrics = new Paint.FontMetricsInt();
        this.separationLinesPaint = new Paint();
        this.tempMaximumViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.softwareCanvas = new Canvas();
        this.touchAdditional = ChartUtils.INSTANCE.dp2px(this.getDensity(), DEFAULT_TOUCH_ADDITIONAL_DP);
        this.slicePaint.setAntiAlias(true);
        this.slicePaint.setStyle(Paint.Style.FILL);
        this.centerCirclePaint.setAntiAlias(true);
        this.centerCirclePaint.setStyle(Paint.Style.FILL);
        this.centerCirclePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        this.centerCircleText1Paint.setAntiAlias(true);
        this.centerCircleText1Paint.setTextAlign(Paint.Align.CENTER);
        this.centerCircleText2Paint.setAntiAlias(true);
        this.centerCircleText2Paint.setTextAlign(Paint.Align.CENTER);
        this.separationLinesPaint.setAntiAlias(true);
        this.separationLinesPaint.setStyle(Paint.Style.STROKE);
        this.separationLinesPaint.setStrokeCap(Paint.Cap.ROUND);
        this.separationLinesPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.separationLinesPaint.setColor(0);
    }

    static {
        MAX_WIDTH_HEIGHT = 100.0f;
        DEFAULT_START_ROTATION = 45;
        DEFAULT_LABEL_INSIDE_RADIUS_FACTOR = 0.7f;
        DEFAULT_LABEL_OUTSIDE_RADIUS_FACTOR = 1.0f;
        DEFAULT_TOUCH_ADDITIONAL_DP = 8;
        MODE_HIGHLIGHT = 1;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lco/csadev/kellocharts/renderer/PieChartRenderer$Companion;", "", "()V", "DEFAULT_LABEL_INSIDE_RADIUS_FACTOR", "", "DEFAULT_LABEL_OUTSIDE_RADIUS_FACTOR", "DEFAULT_START_ROTATION", "", "DEFAULT_TOUCH_ADDITIONAL_DP", "MAX_WIDTH_HEIGHT", "MODE_DRAW", "MODE_HIGHLIGHT", "kellocharts_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

