/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import co.csadev.kellocharts.model.Column;
import co.csadev.kellocharts.model.ColumnChartData;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.SubcolumnValue;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.provider.ColumnChartDataProvider;
import co.csadev.kellocharts.renderer.AbstractChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010 \u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0016J \u0010-\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010.\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u00103\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u00104\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020\"2\u0006\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u00020\nH\u0002J*\u00109\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020\"2\u0006\u00107\u001a\u00020\u0019H\u0002J\u0010\u0010:\u001a\u00020\u001b2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010;\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010<\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J2\u0010=\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0019H\u0002J\b\u0010>\u001a\u00020\u001bH\u0016J\b\u0010?\u001a\u00020\u001bH\u0016J\b\u0010@\u001a\u00020\u001bH\u0016J:\u0010A\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u0010B\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010C\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J:\u0010D\u001a\u00020\u001b2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u0002062\u0006\u0010B\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010C\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lco/csadev/kellocharts/renderer/ColumnChartRenderer;", "Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "dataProvider", "Lco/csadev/kellocharts/provider/ColumnChartDataProvider;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;Lco/csadev/kellocharts/provider/ColumnChartDataProvider;)V", "baseValue", "", "columnPaint", "Landroid/graphics/Paint;", "drawRect", "Landroid/graphics/RectF;", "fillRatio", "subcolumnSpacing", "", "tempMaximumViewport", "Lco/csadev/kellocharts/model/Viewport;", "touchAdditionalWidth", "touchedPoint", "Landroid/graphics/PointF;", "calculateColumnWidth", "isHorizontal", "", "calculateMaxViewport", "", "calculateMaxViewportForStacked", "data", "Lco/csadev/kellocharts/model/ColumnChartData;", "calculateMaxViewportForSubcolumns", "calculateRectToDraw", "columnValue", "Lco/csadev/kellocharts/model/SubcolumnValue;", "left", "right", "rawBaseY", "rawY", "checkRectToDraw", "columnIndex", "valueIndex", "checkTouch", "touchX", "touchY", "checkTouchForStacked", "checkTouchForSubcolumns", "draw", "canvas", "Landroid/graphics/Canvas;", "drawColumnForStacked", "drawColumnsForSubcolumns", "drawLabel", "column", "Lco/csadev/kellocharts/model/Column;", "isStacked", "offset", "drawSubcolumn", "drawUnclipped", "highlightColumnForStacked", "highlightColumnsForSubcolumns", "highlightSubcolumn", "onChartDataChanged", "onChartSizeChanged", "onChartViewportChanged", "processColumnForStacked", "columnWidth", "mode", "processColumnForSubcolumns", "Companion", "kellocharts_release"})
public class ColumnChartRenderer
extends AbstractChartRenderer {
    private final int touchAdditionalWidth;
    private final int subcolumnSpacing;
    private final Paint columnPaint;
    private final RectF drawRect;
    private final PointF touchedPoint;
    private float fillRatio;
    private float baseValue;
    private final Viewport tempMaximumViewport;
    private final ColumnChartDataProvider dataProvider;
    private static final int DEFAULT_SUBCOLUMN_SPACING_DP = 1;
    private static final int DEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP = 4;
    private static final int MODE_DRAW = 0;
    private static final int MODE_CHECK_TOUCH = 1;
    private static final int MODE_HIGHLIGHT = 2;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onChartSizeChanged() {
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        ColumnChartData data = this.dataProvider.getColumnChartData();
        this.fillRatio = data.getFillRatio();
        this.baseValue = data.getBaseValue();
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled()) {
            this.calculateMaxViewport();
            this.getComputator().setMaximumViewport$kellocharts_release(this.tempMaximumViewport);
            this.getComputator().setCurrentViewport$kellocharts_release(this.getComputator().getMaximumViewport());
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        ColumnChartData data = this.dataProvider.getColumnChartData();
        boolean isHorizontal = data.isHorizontal();
        if (data.isStacked()) {
            this.drawColumnForStacked(canvas, isHorizontal);
            if (this.isTouched()) {
                this.highlightColumnForStacked(canvas, isHorizontal);
            }
        } else {
            this.drawColumnsForSubcolumns(canvas, isHorizontal);
            if (this.isTouched()) {
                this.highlightColumnsForSubcolumns(canvas, isHorizontal);
            }
        }
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        this.getSelectedValue().clear();
        ColumnChartData data = this.dataProvider.getColumnChartData();
        if (data.isStacked()) {
            this.checkTouchForStacked(touchX, touchY, data.isHorizontal());
        } else {
            this.checkTouchForSubcolumns(touchX, touchY, data.isHorizontal());
        }
        return this.isTouched();
    }

    private final void calculateMaxViewport() {
        ColumnChartData data = this.dataProvider.getColumnChartData();
        if (data.isHorizontal()) {
            ViewportKt.set(this.tempMaximumViewport, Float.valueOf(this.baseValue), Float.valueOf((float)data.getColumns().size() - 0.5f), Float.valueOf(this.baseValue), Float.valueOf(-0.5f));
        } else {
            ViewportKt.set(this.tempMaximumViewport, Float.valueOf(-0.5f), Float.valueOf(this.baseValue), Float.valueOf((float)data.getColumns().size() - 0.5f), Float.valueOf(this.baseValue));
        }
        if (data.isStacked()) {
            this.calculateMaxViewportForStacked(data);
        } else {
            this.calculateMaxViewportForSubcolumns(data);
        }
    }

    private final void calculateMaxViewportForSubcolumns(ColumnChartData data) {
        float tempMax = data.isHorizontal() ? this.tempMaximumViewport.getRight() : this.tempMaximumViewport.getTop();
        float tempMin = data.isHorizontal() ? this.tempMaximumViewport.getLeft() : this.tempMaximumViewport.getBottom();
        for (Column column : data.getColumns()) {
            for (SubcolumnValue columnValue : column.getValues()) {
                if (columnValue.getValue() >= this.baseValue && columnValue.getValue() > tempMax) {
                    tempMax = columnValue.getValue();
                }
                if (!(columnValue.getValue() < this.baseValue) || !(columnValue.getValue() < tempMin)) continue;
                tempMin = columnValue.getValue();
            }
        }
        if (data.isHorizontal()) {
            this.tempMaximumViewport.setRight(tempMax);
            this.tempMaximumViewport.setLeft(tempMin);
        } else {
            this.tempMaximumViewport.setTop(tempMax);
            this.tempMaximumViewport.setBottom(tempMin);
        }
    }

    private final void calculateMaxViewportForStacked(ColumnChartData data) {
        float tempMax = data.isHorizontal() ? this.tempMaximumViewport.getRight() : this.tempMaximumViewport.getTop();
        float tempMin = data.isHorizontal() ? this.tempMaximumViewport.getLeft() : this.tempMaximumViewport.getBottom();
        Iterable $receiver$iv = data.getColumns();
        for (Object element$iv : $receiver$iv) {
            Column column = (Column)element$iv;
            float sumPositive = this.baseValue;
            float sumNegative = this.baseValue;
            Iterable $receiver$iv2 = column.getValues();
            for (Object element$iv2 : $receiver$iv2) {
                SubcolumnValue columnValue = (SubcolumnValue)element$iv2;
                if (columnValue.getValue() >= this.baseValue) {
                    sumPositive += columnValue.getValue();
                    continue;
                }
                sumNegative += columnValue.getValue();
            }
            if (sumPositive > tempMax) {
                tempMax = sumPositive;
            }
            if (!(sumNegative < tempMin)) continue;
            tempMin = sumNegative;
        }
        for (Column column : data.getColumns()) {
        }
        if (data.isHorizontal()) {
            this.tempMaximumViewport.setRight(tempMax);
            this.tempMaximumViewport.setLeft(tempMin);
        } else {
            this.tempMaximumViewport.setTop(tempMax);
            this.tempMaximumViewport.setBottom(tempMin);
        }
    }

    private final void drawColumnsForSubcolumns(Canvas canvas, boolean isHorizontal) {
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        int columnIndex = 0;
        for (Column column : data.getColumns()) {
            this.processColumnForSubcolumns(canvas, column, columnWidth, columnIndex, MODE_DRAW, isHorizontal);
            ++columnIndex;
        }
    }

    private final void highlightColumnsForSubcolumns(Canvas canvas, boolean isHorizontal) {
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        Column column = data.getColumns().get(this.getSelectedValue().getFirstIndex());
        this.processColumnForSubcolumns(canvas, column, columnWidth, this.getSelectedValue().getFirstIndex(), MODE_HIGHLIGHT, isHorizontal);
    }

    private final void checkTouchForSubcolumns(float touchX, float touchY, boolean isHorizontal) {
        this.touchedPoint.x = touchX;
        this.touchedPoint.y = touchY;
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        int columnIndex = 0;
        for (Column column : data.getColumns()) {
            this.processColumnForSubcolumns(null, column, columnWidth, columnIndex, MODE_CHECK_TOUCH, isHorizontal);
            ++columnIndex;
        }
    }

    private final void processColumnForSubcolumns(Canvas canvas, Column column, float columnWidth, int columnIndex, int mode, boolean isHorizontal) {
        float subcolumnWidth = (columnWidth - (float)(this.subcolumnSpacing * (column.getValues().size() - 1))) / (float)column.getValues().size();
        if (subcolumnWidth < 1.0f) {
            subcolumnWidth = 1.0f;
        }
        float rawX = isHorizontal ? this.getComputator().computeRawY(columnIndex) : this.getComputator().computeRawX(columnIndex);
        float halfColumnWidth = columnWidth / (float)2;
        float baseRawY = isHorizontal ? this.getComputator().computeRawX(this.baseValue) : this.getComputator().computeRawY(this.baseValue);
        float subcolumnRawX = rawX - halfColumnWidth;
        int valueIndex = 0;
        for (SubcolumnValue columnValue : column.getValues()) {
            this.columnPaint.setColor(columnValue.getColor());
            if (subcolumnRawX > rawX + halfColumnWidth) break;
            float rawY = isHorizontal ? this.getComputator().computeRawX(columnValue.getValue()) : this.getComputator().computeRawY(columnValue.getValue());
            this.calculateRectToDraw(isHorizontal, columnValue, subcolumnRawX, subcolumnRawX + subcolumnWidth, baseRawY, rawY);
            int n = mode;
            if (n == MODE_DRAW) {
                this.drawSubcolumn(canvas, column, columnValue, false);
            } else if (n == MODE_HIGHLIGHT) {
                this.highlightSubcolumn(canvas, column, columnValue, valueIndex, false);
            } else if (n == MODE_CHECK_TOUCH) {
                this.checkRectToDraw(columnIndex, valueIndex);
            } else {
                throw (Throwable)new IllegalStateException("Cannot process column in mode: " + mode);
            }
            subcolumnRawX += subcolumnWidth + (float)this.subcolumnSpacing;
            ++valueIndex;
        }
    }

    private final void drawColumnForStacked(Canvas canvas, boolean isHorizontal) {
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        int columnIndex = 0;
        for (Column column : data.getColumns()) {
            this.processColumnForStacked(canvas, column, columnWidth, columnIndex, MODE_DRAW, isHorizontal);
            ++columnIndex;
        }
    }

    private final void highlightColumnForStacked(Canvas canvas, boolean isHorizontal) {
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        Column column = data.getColumns().get(this.getSelectedValue().getFirstIndex());
        this.processColumnForStacked(canvas, column, columnWidth, this.getSelectedValue().getFirstIndex(), MODE_HIGHLIGHT, isHorizontal);
    }

    private final void checkTouchForStacked(float touchX, float touchY, boolean isHorizontal) {
        this.touchedPoint.x = touchX;
        this.touchedPoint.y = touchY;
        ColumnChartData data = this.dataProvider.getColumnChartData();
        float columnWidth = this.calculateColumnWidth(isHorizontal);
        int columnIndex = 0;
        for (Column column : data.getColumns()) {
            this.processColumnForStacked(null, column, columnWidth, columnIndex, MODE_CHECK_TOUCH, isHorizontal);
            ++columnIndex;
        }
    }

    private final void processColumnForStacked(Canvas canvas, Column column, float columnWidth, int columnIndex, int mode, boolean isHorizontal) {
        float rawX = isHorizontal ? this.getComputator().computeRawY(columnIndex) : this.getComputator().computeRawX(columnIndex);
        float halfColumnWidth = columnWidth / (float)2;
        float mostPositiveValue = this.baseValue;
        float mostNegativeValue = this.baseValue;
        float subcolumnBaseValue = this.baseValue;
        int valueIndex = 0;
        for (SubcolumnValue columnValue : column.getValues()) {
            this.columnPaint.setColor(columnValue.getColor());
            if (columnValue.getValue() >= this.baseValue) {
                subcolumnBaseValue = mostPositiveValue;
                mostPositiveValue += columnValue.getValue();
            } else {
                subcolumnBaseValue = mostNegativeValue;
                mostNegativeValue += columnValue.getValue();
            }
            float rawBaseY = isHorizontal ? this.getComputator().computeRawX(subcolumnBaseValue) : this.getComputator().computeRawY(subcolumnBaseValue);
            float rawY = isHorizontal ? this.getComputator().computeRawX(subcolumnBaseValue + columnValue.getValue()) : this.getComputator().computeRawY(subcolumnBaseValue + columnValue.getValue());
            this.calculateRectToDraw(isHorizontal, columnValue, rawX - halfColumnWidth, rawX + halfColumnWidth, rawBaseY, rawY);
            int n = mode;
            if (n == MODE_DRAW) {
                this.drawSubcolumn(canvas, column, columnValue, true);
            } else if (n == MODE_HIGHLIGHT) {
                this.highlightSubcolumn(canvas, column, columnValue, valueIndex, true);
            } else if (n == MODE_CHECK_TOUCH) {
                this.checkRectToDraw(columnIndex, valueIndex);
            } else {
                throw (Throwable)new IllegalStateException("Cannot process column in mode: " + mode);
            }
            ++valueIndex;
        }
    }

    private final void drawSubcolumn(Canvas canvas, Column column, SubcolumnValue columnValue, boolean isStacked) {
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        canvas2.drawRect(this.drawRect, this.columnPaint);
        if (column.getHasLabels()) {
            this.drawLabel(canvas, column, columnValue, isStacked, this.getLabelOffset());
        }
    }

    private final void highlightSubcolumn(Canvas canvas, Column column, SubcolumnValue columnValue, int valueIndex, boolean isStacked) {
        if (this.getSelectedValue().getSecondIndex() == valueIndex) {
            this.columnPaint.setColor(columnValue.getDarkenColor());
            Canvas canvas2 = canvas;
            if (canvas2 == null) {
                Intrinsics.throwNpe();
            }
            canvas2.drawRect(this.drawRect.left - (float)this.touchAdditionalWidth, this.drawRect.top, this.drawRect.right + (float)this.touchAdditionalWidth, this.drawRect.bottom, this.columnPaint);
            if (column.getHasLabels() || column.getHasLabelsOnlyForSelected()) {
                this.drawLabel(canvas, column, columnValue, isStacked, this.getLabelOffset());
            }
        }
    }

    private final void checkRectToDraw(int columnIndex, int valueIndex) {
        if (this.drawRect.contains(this.touchedPoint.x, this.touchedPoint.y)) {
            this.getSelectedValue().set(columnIndex, valueIndex, SelectedValue.SelectedValueType.COLUMN);
        }
    }

    private final float calculateColumnWidth(boolean isHorizontal) {
        Rect rawRect = this.getComputator().getContentRectMinusAllMargins();
        Viewport rawViewport = this.getComputator().getVisibleViewport();
        float columnWidth = this.fillRatio * (float)(isHorizontal ? rawRect.height() : rawRect.width()) / (isHorizontal ? rawViewport.height() : rawViewport.width());
        if (columnWidth < (float)2) {
            columnWidth = 2.0f;
        }
        return columnWidth;
    }

    private final void calculateRectToDraw(boolean isHorizontal, SubcolumnValue columnValue, float left, float right, float rawBaseY, float rawY) {
        if (isHorizontal) {
            if (columnValue.getValue() >= this.baseValue) {
                this.drawRect.top = left;
                this.drawRect.bottom = right - (float)this.subcolumnSpacing;
            } else {
                this.drawRect.top = left;
                this.drawRect.bottom = right + (float)this.subcolumnSpacing;
            }
            this.drawRect.left = rawBaseY;
            this.drawRect.right = rawY;
            return;
        }
        this.drawRect.left = left;
        this.drawRect.right = right;
        if (columnValue.getValue() >= this.baseValue) {
            this.drawRect.top = rawY;
            this.drawRect.bottom = rawBaseY - (float)this.subcolumnSpacing;
        } else {
            this.drawRect.bottom = rawY;
            this.drawRect.top = rawBaseY + (float)this.subcolumnSpacing;
        }
    }

    private final void drawLabel(Canvas canvas, Column column, SubcolumnValue columnValue, boolean isStacked, float offset) {
        float bottom;
        float top;
        int numChars = column.getFormatter().formatChartValue(this.getLabelBuffer(), columnValue);
        if (numChars == 0) {
            return;
        }
        float labelWidth = this.getLabelPaint().measureText(this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars);
        int labelHeight = Math.abs(this.getFontMetrics().ascent);
        float left = this.drawRect.centerX() - labelWidth / (float)2 - (float)this.getLabelMargin();
        float right = this.drawRect.centerX() + labelWidth / (float)2 + (float)this.getLabelMargin();
        if (isStacked && (float)labelHeight < this.drawRect.height() - (float)(2 * this.getLabelMargin())) {
            if (columnValue.getValue() >= this.baseValue) {
                top = this.drawRect.top;
                bottom = this.drawRect.top + (float)labelHeight + (float)(this.getLabelMargin() * 2);
            } else {
                top = this.drawRect.bottom - (float)labelHeight - (float)(this.getLabelMargin() * 2);
                bottom = this.drawRect.bottom;
            }
        } else if (!isStacked) {
            if (columnValue.getValue() >= this.baseValue) {
                top = this.drawRect.top - offset - (float)labelHeight - (float)(this.getLabelMargin() * 2);
                if (top < (float)this.getComputator().getContentRectMinusAllMargins().top) {
                    top = this.drawRect.top + offset;
                    bottom = this.drawRect.top + offset + (float)labelHeight + (float)(this.getLabelMargin() * 2);
                } else {
                    bottom = this.drawRect.top - offset;
                }
            } else {
                bottom = this.drawRect.bottom + offset + (float)labelHeight + (float)(this.getLabelMargin() * 2);
                if (bottom > (float)this.getComputator().getContentRectMinusAllMargins().bottom) {
                    top = this.drawRect.bottom - offset - (float)labelHeight - (float)(this.getLabelMargin() * 2);
                    bottom = this.drawRect.bottom - offset;
                } else {
                    top = this.drawRect.bottom + offset;
                }
            }
        } else {
            return;
        }
        this.getLabelBackgroundRect().set(left, top, right, bottom);
        this.drawLabelTextAndBackground(canvas, this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars, columnValue.getDarkenColor());
    }

    public ColumnChartRenderer(@NotNull Context context, @NotNull Chart chart, @NotNull ColumnChartDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super(context, chart);
        this.dataProvider = dataProvider;
        this.columnPaint = new Paint();
        this.drawRect = new RectF();
        this.touchedPoint = new PointF();
        this.tempMaximumViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.subcolumnSpacing = ChartUtils.INSTANCE.dp2px(this.getDensity(), DEFAULT_SUBCOLUMN_SPACING_DP);
        this.touchAdditionalWidth = ChartUtils.INSTANCE.dp2px(this.getDensity(), DEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP);
        this.columnPaint.setAntiAlias(true);
        this.columnPaint.setStyle(Paint.Style.FILL);
        this.columnPaint.setStrokeCap(Paint.Cap.SQUARE);
    }

    static {
        DEFAULT_SUBCOLUMN_SPACING_DP = 1;
        DEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP = 4;
        MODE_CHECK_TOUCH = 1;
        MODE_HIGHLIGHT = 2;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lco/csadev/kellocharts/renderer/ColumnChartRenderer$Companion;", "", "()V", "DEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP", "", "getDEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP", "()I", "DEFAULT_SUBCOLUMN_SPACING_DP", "getDEFAULT_SUBCOLUMN_SPACING_DP", "MODE_CHECK_TOUCH", "MODE_DRAW", "MODE_HIGHLIGHT", "kellocharts_release"})
    public static final class Companion {
        public final int getDEFAULT_SUBCOLUMN_SPACING_DP() {
            return DEFAULT_SUBCOLUMN_SPACING_DP;
        }

        public final int getDEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP() {
            return DEFAULT_COLUMN_TOUCH_ADDITIONAL_WIDTH_DP;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

