/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.formatter.BubbleChartValueFormatter;
import co.csadev.kellocharts.model.BubbleChartData;
import co.csadev.kellocharts.model.BubbleValue;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.ValueShape;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.provider.BubbleChartDataProvider;
import co.csadev.kellocharts.renderer.AbstractChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 92\u00020\u0001:\u00019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0002J(\u0010)\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u001bH\u0002J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J(\u0010-\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u0010H\u0002J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u00101\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00103\u001a\u00020\u001fH\u0016J\b\u00104\u001a\u00020\u001fH\u0016J\b\u00105\u001a\u00020\u001fH\u0016J\u0018\u00106\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u00107\u001a\u00020\nH\u0002J\u0006\u00108\u001a\u00020\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lco/csadev/kellocharts/renderer/BubbleChartRenderer;", "Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "dataProvider", "Lco/csadev/kellocharts/provider/BubbleChartDataProvider;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;Lco/csadev/kellocharts/provider/BubbleChartDataProvider;)V", "bubbleCenter", "Landroid/graphics/PointF;", "bubblePaint", "Landroid/graphics/Paint;", "bubbleRect", "Landroid/graphics/RectF;", "bubbleScaleX", "", "bubbleScaleY", "hasLabels", "", "hasLabelsOnlyForSelected", "isBubbleScaledByX", "maxRadius", "minRawRadius", "tempMaximumViewport", "Lco/csadev/kellocharts/model/Viewport;", "touchAdditional", "", "valueFormatter", "Lco/csadev/kellocharts/formatter/BubbleChartValueFormatter;", "calculateMaxViewport", "", "checkTouch", "touchX", "touchY", "draw", "canvas", "Landroid/graphics/Canvas;", "drawBubble", "bubbleValue", "Lco/csadev/kellocharts/model/BubbleValue;", "drawBubbleShapeAndLabel", "rawRadius", "mode", "drawBubbles", "drawLabel", "rawX", "rawY", "drawUnclipped", "highlightBubble", "highlightBubbles", "onChartDataChanged", "onChartSizeChanged", "onChartViewportChanged", "processBubble", "point", "removeMargins", "Companion", "kellocharts_release"})
public final class BubbleChartRenderer
extends AbstractChartRenderer {
    private final int touchAdditional;
    private float bubbleScaleX;
    private float bubbleScaleY;
    private boolean isBubbleScaledByX;
    private float maxRadius;
    private float minRawRadius;
    private final PointF bubbleCenter;
    private final Paint bubblePaint;
    private final RectF bubbleRect;
    private boolean hasLabels;
    private boolean hasLabelsOnlyForSelected;
    private BubbleChartValueFormatter valueFormatter;
    private final Viewport tempMaximumViewport;
    private final BubbleChartDataProvider dataProvider;
    private static final int DEFAULT_TOUCH_ADDITIONAL_DP = 4;
    private static final int MODE_DRAW = 0;
    private static final int MODE_HIGHLIGHT = 1;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onChartSizeChanged() {
        ChartComputator computator = this.getChart().getChartComputator();
        Rect contentRect = computator.getContentRectMinusAllMargins();
        this.isBubbleScaledByX = contentRect.width() < contentRect.height();
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        BubbleChartData data = this.dataProvider.getBubbleChartData();
        this.hasLabels = data.getHasLabels();
        this.hasLabelsOnlyForSelected = data.getHasLabelsOnlyForSelected();
        this.valueFormatter = data.getFormatter();
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled()) {
            this.calculateMaxViewport();
            this.getComputator().setMaximumViewport$kellocharts_release(this.tempMaximumViewport);
            this.getComputator().setCurrentViewport$kellocharts_release(this.getComputator().getMaximumViewport());
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawBubbles(canvas);
        if (this.isTouched()) {
            this.highlightBubbles(canvas);
        }
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        this.getSelectedValue().clear();
        BubbleChartData data = this.dataProvider.getBubbleChartData();
        int valueIndex = 0;
        for (BubbleValue bubbleValue : data.getValues()) {
            float rawRadius = this.processBubble(bubbleValue, this.bubbleCenter);
            if (ValueShape.SQUARE == bubbleValue.getShape()) {
                if (this.bubbleRect.contains(touchX, touchY)) {
                    this.getSelectedValue().set(valueIndex, valueIndex, SelectedValue.SelectedValueType.NONE);
                }
            } else if (ValueShape.CIRCLE == bubbleValue.getShape()) {
                float diffX = touchX - this.bubbleCenter.x;
                float diffY = touchY - this.bubbleCenter.y;
                float touchDistance = (float)Math.sqrt(diffX * diffX + diffY * diffY);
                if (touchDistance <= rawRadius) {
                    this.getSelectedValue().set(valueIndex, valueIndex, SelectedValue.SelectedValueType.NONE);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Invalid bubble shape: ");
                ValueShape valueShape = bubbleValue.getShape();
                if (valueShape == null) {
                    Intrinsics.throwNpe();
                }
                throw (Throwable)new IllegalArgumentException(stringBuilder.append((Object)valueShape).toString());
            }
            ++valueIndex;
        }
        return this.isTouched();
    }

    public final void removeMargins() {
        Rect contentRect = this.getComputator().getContentRectMinusAllMargins();
        if (contentRect.height() == 0 || contentRect.width() == 0) {
            return;
        }
        float pxX = this.getComputator().computeRawDistanceX(this.maxRadius * this.bubbleScaleX);
        float pxY = this.getComputator().computeRawDistanceY(this.maxRadius * this.bubbleScaleY);
        float scaleX = this.getComputator().getMaximumViewport().width() / (float)contentRect.width();
        float scaleY = this.getComputator().getMaximumViewport().height() / (float)contentRect.height();
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.isBubbleScaledByX) {
            dy = (pxY - pxX) * scaleY * 0.75f;
        } else {
            dx = (pxX - pxY) * scaleX * 0.75f;
        }
        Viewport maxViewport = this.getComputator().getMaximumViewport();
        maxViewport.inset(dx, dy);
        Viewport currentViewport = this.getComputator().getCurrentViewport$kellocharts_release();
        currentViewport.inset(dx, dy);
        this.getComputator().setMaximumViewport$kellocharts_release(maxViewport);
        this.getComputator().setCurrentViewport$kellocharts_release(currentViewport);
    }

    private final void drawBubbles(Canvas canvas) {
        BubbleChartData data = this.dataProvider.getBubbleChartData();
        for (BubbleValue bubbleValue : data.getValues()) {
            this.drawBubble(canvas, bubbleValue);
        }
    }

    private final void drawBubble(Canvas canvas, BubbleValue bubbleValue) {
        float rawRadius = this.processBubble(bubbleValue, this.bubbleCenter);
        this.bubbleRect.inset((float)this.touchAdditional, (float)this.touchAdditional);
        this.bubblePaint.setColor(bubbleValue.getColor());
        this.drawBubbleShapeAndLabel(canvas, bubbleValue, rawRadius -= (float)this.touchAdditional, MODE_DRAW);
    }

    private final void drawBubbleShapeAndLabel(Canvas canvas, BubbleValue bubbleValue, float rawRadius, int mode) {
        if (ValueShape.SQUARE == bubbleValue.getShape()) {
            canvas.drawRect(this.bubbleRect, this.bubblePaint);
        } else if (ValueShape.CIRCLE == bubbleValue.getShape()) {
            canvas.drawCircle(this.bubbleCenter.x, this.bubbleCenter.y, rawRadius, this.bubblePaint);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Invalid bubble shape: ");
            ValueShape valueShape = bubbleValue.getShape();
            if (valueShape == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new IllegalArgumentException(stringBuilder.append((Object)valueShape).toString());
        }
        if (MODE_HIGHLIGHT == mode) {
            if (this.hasLabels || this.hasLabelsOnlyForSelected) {
                this.drawLabel(canvas, bubbleValue, this.bubbleCenter.x, this.bubbleCenter.y);
            }
        } else if (MODE_DRAW == mode) {
            if (this.hasLabels) {
                this.drawLabel(canvas, bubbleValue, this.bubbleCenter.x, this.bubbleCenter.y);
            }
        } else {
            throw (Throwable)new IllegalStateException("Cannot process bubble in mode: " + mode);
        }
    }

    private final void highlightBubbles(Canvas canvas) {
        BubbleChartData data = this.dataProvider.getBubbleChartData();
        BubbleValue bubbleValue = data.getValues().get(this.getSelectedValue().getFirstIndex());
        this.highlightBubble(canvas, bubbleValue);
    }

    private final void highlightBubble(Canvas canvas, BubbleValue bubbleValue) {
        float rawRadius = this.processBubble(bubbleValue, this.bubbleCenter);
        this.bubblePaint.setColor(bubbleValue.getDarkenColor());
        this.drawBubbleShapeAndLabel(canvas, bubbleValue, rawRadius, MODE_HIGHLIGHT);
    }

    private final float processBubble(BubbleValue bubbleValue, PointF point) {
        float rawX = this.getComputator().computeRawX(bubbleValue.getX());
        float rawY = this.getComputator().computeRawY(bubbleValue.getY());
        float radius = (float)Math.sqrt((double)Math.abs(bubbleValue.getZ()) / Math.PI);
        float rawRadius = this.isBubbleScaledByX ? this.getComputator().computeRawDistanceX(radius *= this.bubbleScaleX) : this.getComputator().computeRawDistanceY(radius *= this.bubbleScaleY);
        if (rawRadius < this.minRawRadius + (float)this.touchAdditional) {
            rawRadius = this.minRawRadius + (float)this.touchAdditional;
        }
        this.bubbleCenter.set(rawX, rawY);
        if (ValueShape.SQUARE == bubbleValue.getShape()) {
            this.bubbleRect.set(rawX - rawRadius, rawY - rawRadius, rawX + rawRadius, rawY + rawRadius);
        }
        return rawRadius;
    }

    private final void drawLabel(Canvas canvas, BubbleValue bubbleValue, float rawX, float rawY) {
        int numChars;
        Rect contentRect = this.getComputator().getContentRectMinusAllMargins();
        BubbleChartValueFormatter bubbleChartValueFormatter = this.valueFormatter;
        if (bubbleChartValueFormatter == null) {
            Intrinsics.throwNpe();
        }
        if ((numChars = bubbleChartValueFormatter.formatChartValue(this.getLabelBuffer(), bubbleValue)) == 0) {
            return;
        }
        float labelWidth = this.getLabelPaint().measureText(this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars);
        int labelHeight = Math.abs(this.getFontMetrics().ascent);
        float left = rawX - labelWidth / (float)2 - (float)this.getLabelMargin();
        float right = rawX + labelWidth / (float)2 + (float)this.getLabelMargin();
        float top = rawY - (float)(labelHeight / 2) - (float)this.getLabelMargin();
        float bottom = rawY + (float)(labelHeight / 2) + (float)this.getLabelMargin();
        if (top < (float)contentRect.top) {
            top = rawY;
            bottom = rawY + (float)labelHeight + (float)(this.getLabelMargin() * 2);
        }
        if (bottom > (float)contentRect.bottom) {
            top = rawY - (float)labelHeight - (float)(this.getLabelMargin() * 2);
            bottom = rawY;
        }
        if (left < (float)contentRect.left) {
            left = rawX;
            right = rawX + labelWidth + (float)(this.getLabelMargin() * 2);
        }
        if (right > (float)contentRect.right) {
            left = rawX - labelWidth - (float)(this.getLabelMargin() * 2);
            right = rawX;
        }
        this.getLabelBackgroundRect().set(left, top, right, bottom);
        this.drawLabelTextAndBackground(canvas, this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars, bubbleValue.getDarkenColor());
    }

    private final void calculateMaxViewport() {
        float maxZ = Float.MIN_VALUE;
        ViewportKt.set(this.tempMaximumViewport, Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        BubbleChartData data = this.dataProvider.getBubbleChartData();
        for (BubbleValue bubbleValue : data.getValues()) {
            if (Math.abs(bubbleValue.getZ()) > maxZ) {
                maxZ = Math.abs(bubbleValue.getZ());
            }
            if (bubbleValue.getX() < this.tempMaximumViewport.getLeft()) {
                this.tempMaximumViewport.setLeft(bubbleValue.getX());
            }
            if (bubbleValue.getX() > this.tempMaximumViewport.getRight()) {
                this.tempMaximumViewport.setRight(bubbleValue.getX());
            }
            if (bubbleValue.getY() < this.tempMaximumViewport.getBottom()) {
                this.tempMaximumViewport.setBottom(bubbleValue.getY());
            }
            if (!(bubbleValue.getY() > this.tempMaximumViewport.getTop())) continue;
            this.tempMaximumViewport.setTop(bubbleValue.getY());
        }
        this.maxRadius = (float)Math.sqrt((double)maxZ / Math.PI);
        this.bubbleScaleX = this.tempMaximumViewport.width() / (this.maxRadius * (float)4);
        if (this.bubbleScaleX == 0.0f) {
            this.bubbleScaleX = 1.0f;
        }
        this.bubbleScaleY = this.tempMaximumViewport.height() / (this.maxRadius * (float)4);
        if (this.bubbleScaleY == 0.0f) {
            this.bubbleScaleY = 1.0f;
        }
        this.bubbleScaleX *= data.getBubbleScale();
        this.bubbleScaleY *= data.getBubbleScale();
        this.tempMaximumViewport.inset(-this.maxRadius * this.bubbleScaleX, -this.maxRadius * this.bubbleScaleY);
        this.minRawRadius = ChartUtils.INSTANCE.dp2px(this.getDensity(), this.dataProvider.getBubbleChartData().getMinBubbleRadius());
    }

    public BubbleChartRenderer(@NotNull Context context, @NotNull Chart chart, @NotNull BubbleChartDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super(context, chart);
        this.dataProvider = dataProvider;
        this.isBubbleScaledByX = true;
        this.bubbleCenter = new PointF();
        this.bubblePaint = new Paint();
        this.bubbleRect = new RectF();
        this.tempMaximumViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.touchAdditional = ChartUtils.INSTANCE.dp2px(this.getDensity(), DEFAULT_TOUCH_ADDITIONAL_DP);
        this.bubblePaint.setAntiAlias(true);
        this.bubblePaint.setStyle(Paint.Style.FILL);
    }

    static {
        DEFAULT_TOUCH_ADDITIONAL_DP = 4;
        MODE_HIGHLIGHT = 1;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/renderer/BubbleChartRenderer$Companion;", "", "()V", "DEFAULT_TOUCH_ADDITIONAL_DP", "", "MODE_DRAW", "MODE_HIGHLIGHT", "kellocharts_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

