/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.model.Axis;
import co.csadev.kellocharts.model.AxisValue;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.util.AxisAutoValues;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.util.FloatUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 T2\u00020\u0001:\u0001TB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u0002012\u0006\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u000201H\u0002J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J \u0010>\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u000e\u0010?\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u000e\u0010@\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u0018\u0010A\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u001a\u0010B\u001a\u0002092\b\u0010<\u001a\u0004\u0018\u00010=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010C\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0010\u0010D\u001a\u0002092\u0006\u00106\u001a\u00020\u000fH\u0002J\u0010\u0010E\u001a\u0002092\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010F\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010G\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010H\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010I\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010J\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010K\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0010\u0010L\u001a\u0002012\u0006\u00106\u001a\u00020\u000fH\u0002J\u0006\u0010M\u001a\u000209J\b\u0010N\u001a\u000209H\u0002J\u0006\u0010O\u001a\u000209J\u0018\u0010P\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010Q\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0018\u0010R\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u00106\u001a\u00020\u000fH\u0002J\u0006\u0010S\u001a\u000209R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010%\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010(\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010-\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010.0\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/\u00a8\u0006U"}, d2={"Lco/csadev/kellocharts/renderer/AxesRenderer;", "", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;)V", "autoValuesBufferTab", "", "Lco/csadev/kellocharts/util/AxisAutoValues;", "[Lco/csadev/kellocharts/util/AxisAutoValues;", "autoValuesToDrawTab", "", "[[F", "axisMargin", "", "computator", "Lco/csadev/kellocharts/computator/ChartComputator;", "density", "", "fontMetricsTab", "Landroid/graphics/Paint$FontMetricsInt;", "[Landroid/graphics/Paint$FontMetricsInt;", "labelBaselineTab", "labelBuffer", "", "labelDimensionForMarginsTab", "", "labelDimensionForStepsTab", "labelPaintTab", "Landroid/graphics/Paint;", "[Landroid/graphics/Paint;", "labelTextAscentTab", "labelTextDescentTab", "labelWidthTab", "linePaintTab", "linesDrawBufferTab", "nameBaselineTab", "namePaintTab", "rawValuesTab", "scaledDensity", "separationLineTab", "tiltedLabelXTranslation", "tiltedLabelYTranslation", "valuesToDrawNumTab", "valuesToDrawTab", "Lco/csadev/kellocharts/model/AxisValue;", "[[Lco/csadev/kellocharts/model/AxisValue;", "checkRawValue", "", "rect", "Landroid/graphics/Rect;", "rawValue", "axisInside", "position", "isVertical", "drawAxisLabelsAndName", "", "canvas", "Landroid/graphics/Canvas;", "axis", "Lco/csadev/kellocharts/model/Axis;", "drawAxisLines", "drawInBackground", "drawInForeground", "getAxisNameMargin", "initAxis", "initAxisAttributes", "initAxisDimension", "initAxisDimensionForTiltedLabels", "initAxisMargin", "initAxisMeasurements", "initAxisPaints", "initAxisTextAlignment", "insetContentRectWithAxesMargins", "intiTiltedLabelsTranslation", "isAxisVertical", "onChartDataChanged", "onChartDataOrSizeChanged", "onChartSizeChanged", "prepareAutoGeneratedAxis", "prepareAxisToDraw", "prepareCustomAxis", "resetRenderer", "Companion", "kellocharts_release"})
public final class AxesRenderer {
    private ChartComputator computator;
    private final int axisMargin;
    private final float density;
    private final float scaledDensity;
    private final Paint[] labelPaintTab;
    private final Paint[] namePaintTab;
    private final Paint[] linePaintTab;
    private final float[] nameBaselineTab;
    private final float[] labelBaselineTab;
    private final float[] separationLineTab;
    private final int[] labelWidthTab;
    private final int[] labelTextAscentTab;
    private final int[] labelTextDescentTab;
    private final int[] labelDimensionForMarginsTab;
    private final int[] labelDimensionForStepsTab;
    private final int[] tiltedLabelXTranslation;
    private final int[] tiltedLabelYTranslation;
    private final Paint.FontMetricsInt[] fontMetricsTab;
    private final char[] labelBuffer;
    private final int[] valuesToDrawNumTab;
    private final float[][] rawValuesTab;
    private final float[][] autoValuesToDrawTab;
    private final AxisValue[][] valuesToDrawTab;
    private final float[][] linesDrawBufferTab;
    private final AxisAutoValues[] autoValuesBufferTab;
    private final Chart chart;
    private static final int DEFAULT_AXIS_MARGIN_DP = 2;
    private static final int TOP = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    private static final char[] labelWidthChars;
    public static final Companion Companion;

    public final void onChartSizeChanged() {
        this.onChartDataOrSizeChanged();
    }

    public final void onChartDataChanged() {
        this.onChartDataOrSizeChanged();
    }

    private final void onChartDataOrSizeChanged() {
        this.initAxis(this.chart.getChartData().getAxisXTop(), TOP);
        this.initAxis(this.chart.getChartData().getAxisXBottom(), BOTTOM);
        this.initAxis(this.chart.getChartData().getAxisYLeft(), LEFT);
        this.initAxis(this.chart.getChartData().getAxisYRight(), RIGHT);
    }

    public final void resetRenderer() {
        this.computator = this.chart.getChartComputator();
    }

    private final void initAxis(Axis axis, int position) {
        if (axis == null) {
            return;
        }
        this.initAxisAttributes(axis, position);
        this.initAxisMargin(axis, position);
        this.initAxisMeasurements(axis, position);
    }

    private final void initAxisAttributes(Axis axis, int position) {
        this.initAxisPaints(axis, position);
        this.initAxisTextAlignment(axis, position);
        if (axis.getHasTiltedLabels()) {
            this.initAxisDimensionForTiltedLabels(position);
            this.intiTiltedLabelsTranslation(axis, position);
        } else {
            this.initAxisDimension(position);
        }
    }

    private final void initAxisPaints(Axis axis, int position) {
        Typeface typeface = axis.getTypeface();
        if (typeface != null) {
            this.labelPaintTab[position].setTypeface(typeface);
            this.namePaintTab[position].setTypeface(typeface);
        }
        this.labelPaintTab[position].setColor(axis.getTextColor());
        this.labelPaintTab[position].setTextSize((float)ChartUtils.INSTANCE.sp2px(this.scaledDensity, axis.getTextSize()));
        this.labelPaintTab[position].getFontMetricsInt(this.fontMetricsTab[position]);
        this.namePaintTab[position].setColor(axis.getTextColor());
        this.namePaintTab[position].setTextSize((float)ChartUtils.INSTANCE.sp2px(this.scaledDensity, axis.getTextSize()));
        this.linePaintTab[position].setColor(axis.getLineColor());
        this.labelTextAscentTab[position] = Math.abs(this.fontMetricsTab[position].ascent);
        this.labelTextDescentTab[position] = Math.abs(this.fontMetricsTab[position].descent);
        this.labelWidthTab[position] = (int)this.labelPaintTab[position].measureText(labelWidthChars, 0, axis.getMaxLabelChars());
    }

    private final void initAxisTextAlignment(Axis axis, int position) {
        this.namePaintTab[position].setTextAlign(Paint.Align.CENTER);
        if (TOP == position || BOTTOM == position) {
            this.labelPaintTab[position].setTextAlign(Paint.Align.CENTER);
        } else if (LEFT == position) {
            if (axis.isInside()) {
                this.labelPaintTab[position].setTextAlign(Paint.Align.LEFT);
            } else {
                this.labelPaintTab[position].setTextAlign(Paint.Align.RIGHT);
            }
        } else if (RIGHT == position) {
            if (axis.isInside()) {
                this.labelPaintTab[position].setTextAlign(Paint.Align.RIGHT);
            } else {
                this.labelPaintTab[position].setTextAlign(Paint.Align.LEFT);
            }
        }
    }

    private final void initAxisDimensionForTiltedLabels(int position) {
        int pythagoreanFromLabelWidth = (int)Math.sqrt(Math.pow(this.labelWidthTab[position], 2.0) / (double)2);
        int pythagoreanFromAscent = (int)Math.sqrt(Math.pow(this.labelTextAscentTab[position], 2.0) / (double)2);
        this.labelDimensionForMarginsTab[position] = pythagoreanFromAscent + pythagoreanFromLabelWidth;
        this.labelDimensionForStepsTab[position] = Math.round((float)this.labelDimensionForMarginsTab[position] * 0.75f);
    }

    private final void initAxisDimension(int position) {
        if (LEFT == position || RIGHT == position) {
            this.labelDimensionForMarginsTab[position] = this.labelWidthTab[position];
            this.labelDimensionForStepsTab[position] = this.labelTextAscentTab[position];
        } else if (TOP == position || BOTTOM == position) {
            this.labelDimensionForMarginsTab[position] = this.labelTextAscentTab[position] + this.labelTextDescentTab[position];
            this.labelDimensionForStepsTab[position] = this.labelWidthTab[position];
        }
    }

    private final void intiTiltedLabelsTranslation(Axis axis, int position) {
        int pythagoreanFromLabelWidth = (int)Math.sqrt(Math.pow(this.labelWidthTab[position], 2.0) / (double)2);
        int pythagoreanFromAscent = (int)Math.sqrt(Math.pow(this.labelTextAscentTab[position], 2.0) / (double)2);
        int dx = 0;
        int dy = 0;
        if (axis.isInside()) {
            if (LEFT == position) {
                dx = pythagoreanFromAscent;
            } else if (RIGHT == position) {
                dy = -pythagoreanFromLabelWidth / 2;
            } else if (TOP == position) {
                dy = pythagoreanFromAscent + pythagoreanFromLabelWidth / 2 - this.labelTextAscentTab[position];
            } else if (BOTTOM == position) {
                dy = -pythagoreanFromLabelWidth / 2;
            }
        } else if (LEFT == position) {
            dy = -pythagoreanFromLabelWidth / 2;
        } else if (RIGHT == position) {
            dx = pythagoreanFromAscent;
        } else if (TOP == position) {
            dy = -pythagoreanFromLabelWidth / 2;
        } else if (BOTTOM == position) {
            dy = pythagoreanFromAscent + pythagoreanFromLabelWidth / 2 - this.labelTextAscentTab[position];
        }
        this.tiltedLabelXTranslation[position] = dx;
        this.tiltedLabelYTranslation[position] = dy;
    }

    private final void initAxisMargin(Axis axis, int position) {
        int margin = 0;
        if (!(axis.isInside() || !axis.isAutoGenerated() && axis.getValues().isEmpty())) {
            margin += this.axisMargin + this.labelDimensionForMarginsTab[position];
        }
        this.insetContentRectWithAxesMargins(margin += this.getAxisNameMargin(axis, position), position);
    }

    private final int getAxisNameMargin(Axis axis, int position) {
        int margin = 0;
        if (!TextUtils.isEmpty((CharSequence)axis.getName())) {
            margin += this.labelTextAscentTab[position];
            margin += this.labelTextDescentTab[position];
            margin += this.axisMargin;
        }
        return margin;
    }

    private final void insetContentRectWithAxesMargins(int axisMargin, int position) {
        if (LEFT == position) {
            this.chart.getChartComputator().insetContentRect(axisMargin, 0, 0, 0);
        } else if (RIGHT == position) {
            this.chart.getChartComputator().insetContentRect(0, 0, axisMargin, 0);
        } else if (TOP == position) {
            this.chart.getChartComputator().insetContentRect(0, axisMargin, 0, 0);
        } else if (BOTTOM == position) {
            this.chart.getChartComputator().insetContentRect(0, 0, 0, axisMargin);
        }
    }

    private final void initAxisMeasurements(Axis axis, int position) {
        if (LEFT == position) {
            if (axis.isInside()) {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAllMargins().left + this.axisMargin;
                ChartComputator chartComputator2 = this.computator;
                if (chartComputator2 == null) {
                    Intrinsics.throwNpe();
                }
                this.nameBaselineTab[position] = chartComputator2.getContentRectMinusAxesMargins().left - this.axisMargin - this.labelTextDescentTab[position];
            } else {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAxesMargins().left - this.axisMargin;
                this.nameBaselineTab[position] = this.labelBaselineTab[position] - (float)this.axisMargin - (float)this.labelTextDescentTab[position] - (float)this.labelDimensionForMarginsTab[position];
            }
            ChartComputator chartComputator = this.computator;
            if (chartComputator == null) {
                Intrinsics.throwNpe();
            }
            this.separationLineTab[position] = chartComputator.getContentRectMinusAllMargins().left;
        } else if (RIGHT == position) {
            if (axis.isInside()) {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAllMargins().right - this.axisMargin;
                ChartComputator chartComputator3 = this.computator;
                if (chartComputator3 == null) {
                    Intrinsics.throwNpe();
                }
                this.nameBaselineTab[position] = chartComputator3.getContentRectMinusAxesMargins().right + this.axisMargin + this.labelTextAscentTab[position];
            } else {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAxesMargins().right + this.axisMargin;
                this.nameBaselineTab[position] = this.labelBaselineTab[position] + (float)this.axisMargin + (float)this.labelTextAscentTab[position] + (float)this.labelDimensionForMarginsTab[position];
            }
            ChartComputator chartComputator = this.computator;
            if (chartComputator == null) {
                Intrinsics.throwNpe();
            }
            this.separationLineTab[position] = chartComputator.getContentRectMinusAllMargins().right;
        } else if (BOTTOM == position) {
            if (axis.isInside()) {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAllMargins().bottom - this.axisMargin - this.labelTextDescentTab[position];
                ChartComputator chartComputator4 = this.computator;
                if (chartComputator4 == null) {
                    Intrinsics.throwNpe();
                }
                this.nameBaselineTab[position] = chartComputator4.getContentRectMinusAxesMargins().bottom + this.axisMargin + this.labelTextAscentTab[position];
            } else {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAxesMargins().bottom + this.axisMargin + this.labelTextAscentTab[position];
                this.nameBaselineTab[position] = this.labelBaselineTab[position] + (float)this.axisMargin + (float)this.labelDimensionForMarginsTab[position];
            }
            ChartComputator chartComputator = this.computator;
            if (chartComputator == null) {
                Intrinsics.throwNpe();
            }
            this.separationLineTab[position] = chartComputator.getContentRectMinusAllMargins().bottom;
        } else if (TOP == position) {
            if (axis.isInside()) {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAllMargins().top + this.axisMargin + this.labelTextAscentTab[position];
                ChartComputator chartComputator5 = this.computator;
                if (chartComputator5 == null) {
                    Intrinsics.throwNpe();
                }
                this.nameBaselineTab[position] = chartComputator5.getContentRectMinusAxesMargins().top - this.axisMargin - this.labelTextDescentTab[position];
            } else {
                ChartComputator chartComputator = this.computator;
                if (chartComputator == null) {
                    Intrinsics.throwNpe();
                }
                this.labelBaselineTab[position] = chartComputator.getContentRectMinusAxesMargins().top - this.axisMargin - this.labelTextDescentTab[position];
                this.nameBaselineTab[position] = this.labelBaselineTab[position] - (float)this.axisMargin - (float)this.labelDimensionForMarginsTab[position];
            }
            ChartComputator chartComputator = this.computator;
            if (chartComputator == null) {
                Intrinsics.throwNpe();
            }
            this.separationLineTab[position] = chartComputator.getContentRectMinusAllMargins().top;
        } else {
            throw (Throwable)new IllegalArgumentException("Invalid axis position: " + position);
        }
    }

    public final void drawInBackground(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Axis axis = this.chart.getChartData().getAxisYLeft();
        if (axis != null) {
            this.prepareAxisToDraw(axis, LEFT);
            this.drawAxisLines(canvas, axis, LEFT);
        }
        if ((axis = this.chart.getChartData().getAxisYRight()) != null) {
            this.prepareAxisToDraw(axis, RIGHT);
            this.drawAxisLines(canvas, axis, RIGHT);
        }
        if ((axis = this.chart.getChartData().getAxisXBottom()) != null) {
            this.prepareAxisToDraw(axis, BOTTOM);
            this.drawAxisLines(canvas, axis, BOTTOM);
        }
        if ((axis = this.chart.getChartData().getAxisXTop()) != null) {
            this.prepareAxisToDraw(axis, TOP);
            this.drawAxisLines(canvas, axis, TOP);
        }
    }

    private final void prepareAxisToDraw(Axis axis, int position) {
        if (axis.isAutoGenerated()) {
            this.prepareAutoGeneratedAxis(axis, position);
        } else {
            this.prepareCustomAxis(axis, position);
        }
    }

    public final void drawInForeground(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Axis axis = this.chart.getChartData().getAxisYLeft();
        if (axis != null) {
            this.drawAxisLabelsAndName(canvas, axis, LEFT);
        }
        if ((axis = this.chart.getChartData().getAxisYRight()) != null) {
            this.drawAxisLabelsAndName(canvas, axis, RIGHT);
        }
        if ((axis = this.chart.getChartData().getAxisXBottom()) != null) {
            this.drawAxisLabelsAndName(canvas, axis, BOTTOM);
        }
        if ((axis = this.chart.getChartData().getAxisXTop()) != null) {
            this.drawAxisLabelsAndName(canvas, axis, TOP);
        }
    }

    private final void prepareCustomAxis(Axis axis, int position) {
        float viewportMax;
        float viewportMin;
        ChartComputator chartComputator = this.computator;
        if (chartComputator == null) {
            Intrinsics.throwNpe();
        }
        Viewport maxViewport = chartComputator.getMaximumViewport();
        ChartComputator chartComputator2 = this.computator;
        if (chartComputator2 == null) {
            Intrinsics.throwNpe();
        }
        Viewport visibleViewport = chartComputator2.getVisibleViewport();
        ChartComputator chartComputator3 = this.computator;
        if (chartComputator3 == null) {
            Intrinsics.throwNpe();
        }
        Rect contentRect = chartComputator3.getContentRectMinusAllMargins();
        boolean isAxisVertical = this.isAxisVertical(position);
        float scale = 1.0f;
        if (isAxisVertical) {
            if (maxViewport.height() > 0.0f && visibleViewport.height() > 0.0f) {
                scale = (float)contentRect.height() * (maxViewport.height() / visibleViewport.height());
            }
            viewportMin = visibleViewport.getBottom();
            viewportMax = visibleViewport.getTop();
        } else {
            if (maxViewport.width() > 0.0f && visibleViewport.width() > 0.0f) {
                scale = (float)contentRect.width() * (maxViewport.width() / visibleViewport.width());
            }
            viewportMin = visibleViewport.getLeft();
            viewportMax = visibleViewport.getRight();
        }
        if (scale == 0.0f) {
            scale = 1.0f;
        }
        int module = (int)Math.max(1.0, Math.ceil((double)axis.getValues().size() * (double)this.labelDimensionForStepsTab[position] * 1.5 / (double)scale));
        if (axis.getHasLines() && this.linesDrawBufferTab[position].length < axis.getValues().size() * 4) {
            this.linesDrawBufferTab[position] = new float[axis.getValues().size() * 4];
        }
        if (this.rawValuesTab[position].length < axis.getValues().size()) {
            this.rawValuesTab[position] = new float[axis.getValues().size()];
        }
        if (this.valuesToDrawTab[position].length < axis.getValues().size()) {
            this.valuesToDrawTab[position] = new AxisValue[axis.getValues().size()];
        }
        int valueIndex = 0;
        int valueToDrawIndex = 0;
        for (AxisValue axisValue : axis.getValues()) {
            float value = axisValue.getValue();
            if (!(value >= viewportMin) || !(value <= viewportMax)) continue;
            if (valueIndex % module == 0) {
                float rawValue;
                if (isAxisVertical) {
                    ChartComputator chartComputator4 = this.computator;
                    if (chartComputator4 == null) {
                        Intrinsics.throwNpe();
                    }
                    rawValue = chartComputator4.computeRawY(value);
                } else {
                    ChartComputator chartComputator5 = this.computator;
                    if (chartComputator5 == null) {
                        Intrinsics.throwNpe();
                    }
                    rawValue = chartComputator5.computeRawX(value);
                }
                if (this.checkRawValue(contentRect, rawValue, axis.isInside(), position, isAxisVertical)) {
                    this.rawValuesTab[position][valueToDrawIndex] = rawValue;
                    this.valuesToDrawTab[position][valueToDrawIndex] = axisValue;
                    ++valueToDrawIndex;
                }
            }
            ++valueIndex;
        }
        this.valuesToDrawNumTab[position] = valueToDrawIndex;
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareAutoGeneratedAxis(Axis axis, int position) {
        int contentRectDimension;
        float stop;
        float start;
        ChartComputator chartComputator = this.computator;
        if (chartComputator == null) {
            Intrinsics.throwNpe();
        }
        Viewport visibleViewport = chartComputator.getVisibleViewport();
        ChartComputator chartComputator2 = this.computator;
        if (chartComputator2 == null) {
            Intrinsics.throwNpe();
        }
        Rect contentRect = chartComputator2.getContentRectMinusAllMargins();
        boolean isAxisVertical = this.isAxisVertical(position);
        int maxLabels = axis.getMaxLabels();
        if (isAxisVertical) {
            start = visibleViewport.getBottom();
            stop = visibleViewport.getTop();
            contentRectDimension = contentRect.height();
        } else {
            start = visibleViewport.getLeft();
            stop = visibleViewport.getRight();
            contentRectDimension = contentRect.width();
        }
        FloatUtils.INSTANCE.computeAutoGeneratedAxisValues(start, stop, maxLabels > 0 ? maxLabels : Math.abs(contentRectDimension) / this.labelDimensionForStepsTab[position] / 2, this.autoValuesBufferTab[position]);
        if (axis.getHasLines() && this.linesDrawBufferTab[position].length < this.autoValuesBufferTab[position].getValuesNumber() * 4) {
            this.linesDrawBufferTab[position] = new float[this.autoValuesBufferTab[position].getValuesNumber() * 4];
        }
        if (this.rawValuesTab[position].length < this.autoValuesBufferTab[position].getValuesNumber()) {
            this.rawValuesTab[position] = new float[this.autoValuesBufferTab[position].getValuesNumber()];
        }
        if (this.autoValuesToDrawTab[position].length < this.autoValuesBufferTab[position].getValuesNumber()) {
            this.autoValuesToDrawTab[position] = new float[this.autoValuesBufferTab[position].getValuesNumber()];
        }
        int valueToDrawIndex = 0;
        int n = 0;
        int n2 = this.autoValuesBufferTab[position].getValuesNumber();
        while (n < n2) {
            float rawValue;
            void i;
            if (isAxisVertical) {
                ChartComputator chartComputator3 = this.computator;
                if (chartComputator3 == null) {
                    Intrinsics.throwNpe();
                }
                rawValue = chartComputator3.computeRawY(this.autoValuesBufferTab[position].getValues()[i]);
            } else {
                ChartComputator chartComputator4 = this.computator;
                if (chartComputator4 == null) {
                    Intrinsics.throwNpe();
                }
                rawValue = chartComputator4.computeRawX(this.autoValuesBufferTab[position].getValues()[i]);
            }
            if (this.checkRawValue(contentRect, rawValue, axis.isInside(), position, isAxisVertical)) {
                this.rawValuesTab[position][valueToDrawIndex] = rawValue;
                this.autoValuesToDrawTab[position][valueToDrawIndex] = this.autoValuesBufferTab[position].getValues()[i];
                ++valueToDrawIndex;
            }
            ++i;
        }
        this.valuesToDrawNumTab[position] = valueToDrawIndex;
    }

    private final boolean checkRawValue(Rect rect, float rawValue, boolean axisInside, int position, boolean isVertical) {
        if (axisInside) {
            if (isVertical) {
                float marginBottom = this.labelTextAscentTab[BOTTOM] + this.axisMargin;
                float marginTop = this.labelTextAscentTab[TOP] + this.axisMargin;
                return rawValue <= (float)rect.bottom - marginBottom && rawValue >= (float)rect.top + marginTop;
            }
            float margin = this.labelWidthTab[position] / 2;
            return rawValue >= (float)rect.left + margin && rawValue <= (float)rect.right - margin;
        }
        return true;
    }

    private final void drawAxisLines(Canvas canvas, Axis axis, int position) {
        float lineY2;
        float lineX2;
        float lineY1;
        float separationY2;
        float separationX2;
        float separationY1;
        ChartComputator chartComputator = this.computator;
        if (chartComputator == null) {
            Intrinsics.throwNpe();
        }
        Rect contentRectMargins = chartComputator.getContentRectMinusAxesMargins();
        float separationX1 = separationY1 = (separationX2 = (separationY2 = 0.0f));
        float lineX1 = lineY1 = (lineX2 = (lineY2 = 0.0f));
        boolean isAxisVertical = this.isAxisVertical(position);
        if (LEFT == position || RIGHT == position) {
            separationX1 = separationX2 = this.separationLineTab[position];
            separationY1 = contentRectMargins.bottom;
            separationY2 = contentRectMargins.top;
            lineX1 = contentRectMargins.left;
            lineX2 = contentRectMargins.right;
        } else if (TOP == position || BOTTOM == position) {
            separationX1 = contentRectMargins.left;
            separationX2 = contentRectMargins.right;
            separationY1 = separationY2 = this.separationLineTab[position];
            lineY1 = contentRectMargins.top;
            lineY2 = contentRectMargins.bottom;
        }
        if (axis.getHasSeparationLine()) {
            canvas.drawLine(separationX1, separationY1, separationX2, separationY2, this.labelPaintTab[position]);
        }
        if (axis.getHasLines()) {
            int valueToDrawIndex;
            for (valueToDrawIndex = 0; valueToDrawIndex < this.valuesToDrawNumTab[position]; ++valueToDrawIndex) {
                if (isAxisVertical) {
                    lineY1 = lineY2 = this.rawValuesTab[position][valueToDrawIndex];
                } else {
                    lineX1 = lineX2 = this.rawValuesTab[position][valueToDrawIndex];
                }
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 0] = lineX1;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 1] = lineY1;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 2] = lineX2;
                this.linesDrawBufferTab[position][valueToDrawIndex * 4 + 3] = lineY2;
            }
            canvas.drawLines(this.linesDrawBufferTab[position], 0, valueToDrawIndex * 4, this.linePaintTab[position]);
        }
    }

    private final void drawAxisLabelsAndName(Canvas canvas, Axis axis, int position) {
        int valueToDrawIndex;
        float labelY;
        float labelX = labelY = 0.0f;
        boolean isAxisVertical = this.isAxisVertical(position);
        boolean isAxisReversed = axis.isReversed();
        if (LEFT == position || RIGHT == position) {
            labelX = this.labelBaselineTab[position];
        } else if (TOP == position || BOTTOM == position) {
            labelY = this.labelBaselineTab[position];
        }
        int reverseIndex = isAxisReversed ? 0 : this.valuesToDrawNumTab[position];
        int n = valueToDrawIndex = isAxisReversed ? this.valuesToDrawNumTab[position] - 1 : 0;
        while (true) {
            boolean bl = isAxisReversed ? valueToDrawIndex >= 0 : valueToDrawIndex < this.valuesToDrawNumTab[position];
            if (!bl) break;
            int charsNumber = 0;
            if (axis.isAutoGenerated()) {
                float value = this.autoValuesToDrawTab[position][valueToDrawIndex];
                charsNumber = axis.getFormatter().formatValueForAutoGeneratedAxis(this.labelBuffer, value, this.autoValuesBufferTab[position].getDecimals());
            } else {
                AxisValue axisValue = this.valuesToDrawTab[position][valueToDrawIndex];
                if (axisValue != null) {
                    charsNumber = axis.getFormatter().formatValueForManualAxis(this.labelBuffer, axisValue);
                }
            }
            if (isAxisVertical) {
                labelY = this.rawValuesTab[position][isAxisReversed ? reverseIndex : valueToDrawIndex];
            } else {
                labelX = this.rawValuesTab[position][isAxisReversed ? reverseIndex : valueToDrawIndex];
            }
            if (axis.getHasTiltedLabels()) {
                canvas.save();
                canvas.translate((float)this.tiltedLabelXTranslation[position], (float)this.tiltedLabelYTranslation[position]);
                canvas.rotate(-45.0f, labelX, labelY);
                canvas.drawText(this.labelBuffer, this.labelBuffer.length - charsNumber, charsNumber, labelX, labelY, this.labelPaintTab[position]);
                canvas.restore();
            } else {
                canvas.drawText(this.labelBuffer, this.labelBuffer.length - charsNumber, charsNumber, labelX, labelY, this.labelPaintTab[position]);
            }
            if (isAxisReversed) {
                --valueToDrawIndex;
                ++reverseIndex;
                continue;
            }
            ++valueToDrawIndex;
            --reverseIndex;
        }
        ChartComputator chartComputator = this.computator;
        if (chartComputator == null) {
            Intrinsics.throwNpe();
        }
        Rect contentRectMargins = chartComputator.getContentRectMinusAxesMargins();
        if (!TextUtils.isEmpty((CharSequence)axis.getName())) {
            if (isAxisVertical) {
                canvas.save();
                canvas.rotate(-90.0f, (float)contentRectMargins.centerY(), (float)contentRectMargins.centerY());
                String string = axis.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawText(string, (float)contentRectMargins.centerY(), this.nameBaselineTab[position], this.namePaintTab[position]);
                canvas.restore();
            } else {
                String string = axis.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                canvas.drawText(string, (float)contentRectMargins.centerX(), this.nameBaselineTab[position], this.namePaintTab[position]);
            }
        }
    }

    private final boolean isAxisVertical(int position) {
        boolean bl;
        if (LEFT == position || RIGHT == position) {
            bl = true;
        } else if (TOP == position || BOTTOM == position) {
            bl = false;
        } else {
            throw (Throwable)new IllegalArgumentException("Invalid axis position " + position);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public AxesRenderer(@NotNull Context context, @NotNull Chart chart) {
        int it;
        Object[] objectArray;
        float[][] fArrayArray;
        int n;
        int i$iv;
        int size$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        this.chart = chart;
        this.labelPaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
        this.namePaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
        this.linePaintTab = new Paint[]{new Paint(), new Paint(), new Paint(), new Paint()};
        this.nameBaselineTab = new float[4];
        this.labelBaselineTab = new float[4];
        this.separationLineTab = new float[4];
        this.labelWidthTab = new int[4];
        this.labelTextAscentTab = new int[4];
        this.labelTextDescentTab = new int[4];
        this.labelDimensionForMarginsTab = new int[4];
        this.labelDimensionForStepsTab = new int[4];
        this.tiltedLabelXTranslation = new int[4];
        this.tiltedLabelYTranslation = new int[4];
        this.fontMetricsTab = new Paint.FontMetricsInt[]{new Paint.FontMetricsInt(), new Paint.FontMetricsInt(), new Paint.FontMetricsInt(), new Paint.FontMetricsInt()};
        this.labelBuffer = new char[64];
        this.valuesToDrawNumTab = new int[4];
        int n2 = 4;
        AxesRenderer axesRenderer = this;
        Object result$iv = new float[size$iv][];
        int n3 = 0;
        int n4 = ((float[][])result$iv).length;
        while (n3 < n4) {
            void var7_9 = i$iv;
            n = i$iv++;
            fArrayArray = result$iv;
            objectArray = new float[]{};
            fArrayArray[n] = objectArray;
        }
        fArrayArray = result$iv;
        axesRenderer.rawValuesTab = fArrayArray;
        size$iv = 4;
        axesRenderer = this;
        result$iv = new float[size$iv][];
        i$iv = 0;
        n4 = ((float[][])result$iv).length;
        while (i$iv < n4) {
            it = i$iv;
            n = i$iv++;
            fArrayArray = result$iv;
            objectArray = new float[]{};
            fArrayArray[n] = objectArray;
        }
        fArrayArray = result$iv;
        axesRenderer.autoValuesToDrawTab = fArrayArray;
        size$iv = 4;
        axesRenderer = this;
        result$iv = new AxisValue[size$iv][];
        i$iv = 0;
        n4 = ((float[][])result$iv).length;
        while (i$iv < n4) {
            it = i$iv;
            n = i$iv++;
            fArrayArray = result$iv;
            objectArray = new AxisValue[0];
            fArrayArray[n] = objectArray;
        }
        fArrayArray = result$iv;
        axesRenderer.valuesToDrawTab = (AxisValue[][])fArrayArray;
        size$iv = 4;
        axesRenderer = this;
        result$iv = new float[size$iv][];
        i$iv = 0;
        n4 = ((float[][])result$iv).length;
        while (i$iv < n4) {
            it = i$iv;
            n = i$iv++;
            fArrayArray = result$iv;
            objectArray = new float[]{};
            fArrayArray[n] = objectArray;
        }
        fArrayArray = result$iv;
        axesRenderer.linesDrawBufferTab = fArrayArray;
        this.autoValuesBufferTab = new AxisAutoValues[]{new AxisAutoValues(), new AxisAutoValues(), new AxisAutoValues(), new AxisAutoValues()};
        this.computator = this.chart.getChartComputator();
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.density = resources.getDisplayMetrics().density;
        Resources resources2 = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"context.resources");
        this.scaledDensity = resources2.getDisplayMetrics().scaledDensity;
        this.axisMargin = ChartUtils.INSTANCE.dp2px(this.density, DEFAULT_AXIS_MARGIN_DP);
        size$iv = 0;
        int n5 = 3;
        while (size$iv <= n5) {
            void position;
            this.labelPaintTab[position].setStyle(Paint.Style.FILL);
            this.labelPaintTab[position].setAntiAlias(true);
            this.namePaintTab[position].setStyle(Paint.Style.FILL);
            this.namePaintTab[position].setAntiAlias(true);
            this.linePaintTab[position].setStyle(Paint.Style.STROKE);
            this.linePaintTab[position].setAntiAlias(true);
            ++position;
        }
    }

    static {
        Companion = new Companion(null);
        DEFAULT_AXIS_MARGIN_DP = 2;
        LEFT = 1;
        RIGHT = 2;
        BOTTOM = 3;
        labelWidthChars = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lco/csadev/kellocharts/renderer/AxesRenderer$Companion;", "", "()V", "BOTTOM", "", "DEFAULT_AXIS_MARGIN_DP", "LEFT", "RIGHT", "TOP", "labelWidthChars", "", "kellocharts_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

