/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.model.ChartData;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.renderer.ChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010[\u001a\u00020\\H\u0016J0\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020_2\u0006\u0010@\u001a\u00020A2\u0006\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\bH\u0004J\b\u0010c\u001a\u00020\\H\u0016J\b\u0010d\u001a\u00020\\H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,R\u001a\u0010-\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010,\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010/R\u001a\u00102\u001a\u00020+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010,\"\u0004\b3\u0010/R\u001a\u00104\u001a\u000205X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020AX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\n\"\u0004\bH\u0010\fR\u001a\u0010I\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\n\"\u0004\bK\u0010\fR\u001a\u0010L\u001a\u000205X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u00107\"\u0004\bN\u00109R$\u0010O\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010\u001b\"\u0004\bQ\u0010\u001dR\u001a\u0010R\u001a\u00020\u001fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010!\"\u0004\bT\u0010#R\u001a\u0010U\u001a\u00020VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010Z\u00a8\u0006e"}, d2={"Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "Lco/csadev/kellocharts/renderer/ChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;)V", "DEFAULT_LABEL_MARGIN_DP", "", "getDEFAULT_LABEL_MARGIN_DP", "()I", "setDEFAULT_LABEL_MARGIN_DP", "(I)V", "getChart", "()Lco/csadev/kellocharts/view/Chart;", "setChart", "(Lco/csadev/kellocharts/view/Chart;)V", "computator", "Lco/csadev/kellocharts/computator/ChartComputator;", "getComputator", "()Lco/csadev/kellocharts/computator/ChartComputator;", "setComputator", "(Lco/csadev/kellocharts/computator/ChartComputator;)V", "value", "Lco/csadev/kellocharts/model/Viewport;", "currentViewport", "getCurrentViewport", "()Lco/csadev/kellocharts/model/Viewport;", "setCurrentViewport", "(Lco/csadev/kellocharts/model/Viewport;)V", "density", "", "getDensity", "()F", "setDensity", "(F)V", "fontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "getFontMetrics", "()Landroid/graphics/Paint$FontMetricsInt;", "setFontMetrics", "(Landroid/graphics/Paint$FontMetricsInt;)V", "isTouched", "", "()Z", "isValueLabelBackgroundAuto", "setValueLabelBackgroundAuto", "(Z)V", "isValueLabelBackgroundEnabled", "setValueLabelBackgroundEnabled", "isViewportCalculationEnabled", "setViewportCalculationEnabled", "labelBackgroundPaint", "Landroid/graphics/Paint;", "getLabelBackgroundPaint", "()Landroid/graphics/Paint;", "setLabelBackgroundPaint", "(Landroid/graphics/Paint;)V", "labelBackgroundRect", "Landroid/graphics/RectF;", "getLabelBackgroundRect", "()Landroid/graphics/RectF;", "setLabelBackgroundRect", "(Landroid/graphics/RectF;)V", "labelBuffer", "", "getLabelBuffer", "()[C", "setLabelBuffer", "([C)V", "labelMargin", "getLabelMargin", "setLabelMargin", "labelOffset", "getLabelOffset", "setLabelOffset", "labelPaint", "getLabelPaint", "setLabelPaint", "maximumViewport", "getMaximumViewport", "setMaximumViewport", "scaledDensity", "getScaledDensity", "setScaledDensity", "selectedValue", "Lco/csadev/kellocharts/model/SelectedValue;", "getSelectedValue", "()Lco/csadev/kellocharts/model/SelectedValue;", "setSelectedValue", "(Lco/csadev/kellocharts/model/SelectedValue;)V", "clearTouch", "", "drawLabelTextAndBackground", "canvas", "Landroid/graphics/Canvas;", "startIndex", "numChars", "autoBackgroundColor", "onChartDataChanged", "resetRenderer", "kellocharts_release"})
public abstract class AbstractChartRenderer
implements ChartRenderer {
    private int DEFAULT_LABEL_MARGIN_DP;
    @NotNull
    private ChartComputator computator;
    @NotNull
    private Paint labelPaint;
    @NotNull
    private Paint labelBackgroundPaint;
    @NotNull
    private RectF labelBackgroundRect;
    @NotNull
    private Paint.FontMetricsInt fontMetrics;
    private boolean isViewportCalculationEnabled;
    private float density;
    private float scaledDensity;
    @NotNull
    private SelectedValue selectedValue;
    @NotNull
    private char[] labelBuffer;
    private int labelOffset;
    private int labelMargin;
    private boolean isValueLabelBackgroundEnabled;
    private boolean isValueLabelBackgroundAuto;
    @NotNull
    private Chart chart;

    public final int getDEFAULT_LABEL_MARGIN_DP() {
        return this.DEFAULT_LABEL_MARGIN_DP;
    }

    public final void setDEFAULT_LABEL_MARGIN_DP(int n) {
        this.DEFAULT_LABEL_MARGIN_DP = n;
    }

    @NotNull
    protected final ChartComputator getComputator() {
        return this.computator;
    }

    protected final void setComputator(@NotNull ChartComputator chartComputator) {
        Intrinsics.checkParameterIsNotNull((Object)chartComputator, (String)"<set-?>");
        this.computator = chartComputator;
    }

    @NotNull
    protected final Paint getLabelPaint() {
        return this.labelPaint;
    }

    protected final void setLabelPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"<set-?>");
        this.labelPaint = paint;
    }

    @NotNull
    protected final Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    protected final void setLabelBackgroundPaint(@NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"<set-?>");
        this.labelBackgroundPaint = paint;
    }

    @NotNull
    protected final RectF getLabelBackgroundRect() {
        return this.labelBackgroundRect;
    }

    protected final void setLabelBackgroundRect(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.labelBackgroundRect = rectF;
    }

    @NotNull
    protected final Paint.FontMetricsInt getFontMetrics() {
        return this.fontMetrics;
    }

    protected final void setFontMetrics(@NotNull Paint.FontMetricsInt fontMetricsInt) {
        Intrinsics.checkParameterIsNotNull((Object)fontMetricsInt, (String)"<set-?>");
        this.fontMetrics = fontMetricsInt;
    }

    @Override
    public boolean isViewportCalculationEnabled() {
        return this.isViewportCalculationEnabled;
    }

    @Override
    public void setViewportCalculationEnabled(boolean bl) {
        this.isViewportCalculationEnabled = bl;
    }

    protected final float getDensity() {
        return this.density;
    }

    protected final void setDensity(float f) {
        this.density = f;
    }

    protected final float getScaledDensity() {
        return this.scaledDensity;
    }

    protected final void setScaledDensity(float f) {
        this.scaledDensity = f;
    }

    @Override
    @NotNull
    public SelectedValue getSelectedValue() {
        return this.selectedValue;
    }

    @Override
    public void setSelectedValue(@NotNull SelectedValue selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"<set-?>");
        this.selectedValue = selectedValue;
    }

    @NotNull
    protected final char[] getLabelBuffer() {
        return this.labelBuffer;
    }

    protected final void setLabelBuffer(@NotNull char[] cArray) {
        Intrinsics.checkParameterIsNotNull((Object)cArray, (String)"<set-?>");
        this.labelBuffer = cArray;
    }

    protected final int getLabelOffset() {
        return this.labelOffset;
    }

    protected final void setLabelOffset(int n) {
        this.labelOffset = n;
    }

    protected final int getLabelMargin() {
        return this.labelMargin;
    }

    protected final void setLabelMargin(int n) {
        this.labelMargin = n;
    }

    protected final boolean isValueLabelBackgroundEnabled() {
        return this.isValueLabelBackgroundEnabled;
    }

    protected final void setValueLabelBackgroundEnabled(boolean bl) {
        this.isValueLabelBackgroundEnabled = bl;
    }

    protected final boolean isValueLabelBackgroundAuto() {
        return this.isValueLabelBackgroundAuto;
    }

    protected final void setValueLabelBackgroundAuto(boolean bl) {
        this.isValueLabelBackgroundAuto = bl;
    }

    @Override
    public boolean isTouched() {
        return this.getSelectedValue().isSet();
    }

    @Override
    @NotNull
    public Viewport getCurrentViewport() {
        return this.computator.getCurrentViewport$kellocharts_release();
    }

    @Override
    public void setCurrentViewport(@NotNull Viewport value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.computator.setCurrentViewport$kellocharts_release(value);
    }

    @Override
    @NotNull
    public Viewport getMaximumViewport() {
        return this.computator.getMaximumViewport();
    }

    @Override
    public void setMaximumViewport(@NotNull Viewport value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.computator.setMaximumViewport$kellocharts_release(value);
    }

    @Override
    public void resetRenderer() {
        this.computator = this.chart.getChartComputator();
    }

    @Override
    public void onChartDataChanged() {
        ChartData data = this.chart.getChartData();
        Typeface typeface = this.chart.getChartData().getValueLabelTypeface();
        if (typeface != null) {
            this.labelPaint.setTypeface(typeface);
        }
        this.labelPaint.setColor(data.getValueLabelTextColor());
        this.labelPaint.setTextSize((float)ChartUtils.INSTANCE.sp2px(this.scaledDensity, data.getValueLabelTextSize()));
        this.labelPaint.getFontMetricsInt(this.fontMetrics);
        this.isValueLabelBackgroundEnabled = data.isValueLabelBackgroundEnabled();
        this.isValueLabelBackgroundAuto = data.isValueLabelBackgroundAuto();
        this.labelBackgroundPaint.setColor(data.getValueLabelBackgroundColor());
        this.getSelectedValue().clear();
    }

    protected final void drawLabelTextAndBackground(@NotNull Canvas canvas, @NotNull char[] labelBuffer, int startIndex, int numChars, int autoBackgroundColor) {
        float textY;
        float textX;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)labelBuffer, (String)"labelBuffer");
        if (this.isValueLabelBackgroundEnabled) {
            if (this.isValueLabelBackgroundAuto) {
                this.labelBackgroundPaint.setColor(autoBackgroundColor);
            }
            canvas.drawRect(this.labelBackgroundRect, this.labelBackgroundPaint);
            textX = this.labelBackgroundRect.left + (float)this.labelMargin;
            textY = this.labelBackgroundRect.bottom - (float)this.labelMargin;
        } else {
            textX = this.labelBackgroundRect.left;
            textY = this.labelBackgroundRect.bottom;
        }
        canvas.drawText(labelBuffer, startIndex, numChars, textX, textY, this.labelPaint);
    }

    @Override
    public void clearTouch() {
        this.getSelectedValue().clear();
    }

    @NotNull
    protected final Chart getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"<set-?>");
        this.chart = chart;
    }

    public AbstractChartRenderer(@NotNull Context context, @NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        this.chart = chart;
        this.DEFAULT_LABEL_MARGIN_DP = 4;
        this.labelPaint = new Paint();
        this.labelBackgroundPaint = new Paint();
        this.labelBackgroundRect = new RectF();
        this.fontMetrics = new Paint.FontMetricsInt();
        this.isViewportCalculationEnabled = true;
        this.selectedValue = new SelectedValue(0, 0, null, 7, null);
        this.labelBuffer = new char[64];
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.density = resources.getDisplayMetrics().density;
        Resources resources2 = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"context.resources");
        this.scaledDensity = resources2.getDisplayMetrics().scaledDensity;
        this.computator = this.chart.getChartComputator();
        this.labelOffset = this.labelMargin = ChartUtils.INSTANCE.dp2px(this.density, this.DEFAULT_LABEL_MARGIN_DP);
        this.labelPaint.setAntiAlias(true);
        this.labelPaint.setStyle(Paint.Style.FILL);
        this.labelPaint.setTextAlign(Paint.Align.LEFT);
        this.labelPaint.setTypeface(Typeface.defaultFromStyle((int)1));
        this.labelPaint.setColor(-1);
        this.labelBackgroundPaint.setAntiAlias(true);
        this.labelBackgroundPaint.setStyle(Paint.Style.FILL);
    }
}

