/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.gesture;

import android.content.Context;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import androidx.core.widget.ScrollerCompat;
import co.csadev.kellocharts.gesture.ChartTouchHandler;
import co.csadev.kellocharts.view.PieChartView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lco/csadev/kellocharts/gesture/PieChartTouchHandler;", "Lco/csadev/kellocharts/gesture/ChartTouchHandler;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/PieChartView;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/PieChartView;)V", "isRotationEnabled", "", "()Z", "setRotationEnabled", "(Z)V", "pieChart", "getPieChart", "()Lco/csadev/kellocharts/view/PieChartView;", "setPieChart", "(Lco/csadev/kellocharts/view/PieChartView;)V", "scroller", "Landroidx/core/widget/ScrollerCompat;", "getScroller", "()Landroidx/core/widget/ScrollerCompat;", "setScroller", "(Landroidx/core/widget/ScrollerCompat;)V", "computeScroll", "handleTouchEvent", "event", "Landroid/view/MotionEvent;", "ChartGestureListener", "ChartScaleGestureListener", "Companion", "kellocharts_release"})
public final class PieChartTouchHandler
extends ChartTouchHandler {
    @NotNull
    private ScrollerCompat scroller;
    @NotNull
    private PieChartView pieChart;
    private boolean isRotationEnabled;
    private static final int FLING_VELOCITY_DOWNSCALE = 4;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ScrollerCompat getScroller() {
        return this.scroller;
    }

    protected final void setScroller(@NotNull ScrollerCompat scrollerCompat) {
        Intrinsics.checkParameterIsNotNull((Object)scrollerCompat, (String)"<set-?>");
        this.scroller = scrollerCompat;
    }

    @NotNull
    protected final PieChartView getPieChart() {
        return this.pieChart;
    }

    protected final void setPieChart(@NotNull PieChartView pieChartView) {
        Intrinsics.checkParameterIsNotNull((Object)pieChartView, (String)"<set-?>");
        this.pieChart = pieChartView;
    }

    public final boolean isRotationEnabled() {
        return this.isRotationEnabled;
    }

    public final void setRotationEnabled(boolean bl) {
        this.isRotationEnabled = bl;
    }

    @Override
    public boolean computeScroll() {
        if (!this.isRotationEnabled) {
            return false;
        }
        if (this.scroller.computeScrollOffset()) {
            this.pieChart.setChartRotation(this.scroller.getCurrY(), false);
        }
        return false;
    }

    @Override
    public boolean handleTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        boolean needInvalidate = super.handleTouchEvent(event);
        if (this.isRotationEnabled) {
            needInvalidate = this.getGestureDetector().onTouchEvent(event) || needInvalidate;
        }
        return needInvalidate;
    }

    public PieChartTouchHandler(@NotNull Context context, @NotNull PieChartView chart) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        super(context, chart);
        this.isRotationEnabled = true;
        this.pieChart = chart;
        ScrollerCompat scrollerCompat = ScrollerCompat.create((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)scrollerCompat, (String)"ScrollerCompat.create(context)");
        this.scroller = scrollerCompat;
        this.setGestureDetector(new GestureDetector(context, (GestureDetector.OnGestureListener)new ChartGestureListener()));
        this.setScaleGestureDetector(new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ChartScaleGestureListener()));
        this.setZoomEnabled(false);
    }

    static {
        FLING_VELOCITY_DOWNSCALE = 4;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/gesture/PieChartTouchHandler$ChartScaleGestureListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lco/csadev/kellocharts/gesture/PieChartTouchHandler;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "kellocharts_release"})
    private final class ChartScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J(\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lco/csadev/kellocharts/gesture/PieChartTouchHandler$ChartGestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lco/csadev/kellocharts/gesture/PieChartTouchHandler;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "onDown", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onScroll", "distanceX", "distanceY", "vectorToScalarScroll", "dx", "dy", "x", "y", "kellocharts_release"})
    private final class ChartGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDown(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (PieChartTouchHandler.this.isRotationEnabled()) {
                PieChartTouchHandler.this.getScroller().abortAnimation();
                return true;
            }
            return false;
        }

        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return false;
        }

        public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (PieChartTouchHandler.this.isRotationEnabled()) {
                RectF circleOval = PieChartTouchHandler.this.getPieChart().getCircleOval();
                float centerX = circleOval.centerX();
                float centerY = circleOval.centerY();
                float scrollTheta = this.vectorToScalarScroll(distanceX, distanceY, e2.getX() - centerX, e2.getY() - centerY);
                PieChartTouchHandler.this.getPieChart().setChartRotation(PieChartTouchHandler.this.getPieChart().getChartRotation() - (int)scrollTheta / Companion.getFLING_VELOCITY_DOWNSCALE(), false);
                return true;
            }
            return false;
        }

        public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (PieChartTouchHandler.this.isRotationEnabled()) {
                RectF circleOval = PieChartTouchHandler.this.getPieChart().getCircleOval();
                float centerX = circleOval.centerX();
                float centerY = circleOval.centerY();
                float scrollTheta = this.vectorToScalarScroll(velocityX, velocityY, e2.getX() - centerX, e2.getY() - centerY);
                PieChartTouchHandler.this.getScroller().abortAnimation();
                PieChartTouchHandler.this.getScroller().fling(0, PieChartTouchHandler.this.getPieChart().getChartRotation(), 0, (int)scrollTheta / Companion.getFLING_VELOCITY_DOWNSCALE(), 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
                return true;
            }
            return false;
        }

        private final float vectorToScalarScroll(float dx, float dy, float x, float y) {
            float l = (float)Math.sqrt(dx * dx + dy * dy);
            float crossX = -y;
            float dot = crossX * dx + x * dy;
            float sign = Math.signum(dot);
            return l * sign;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/gesture/PieChartTouchHandler$Companion;", "", "()V", "FLING_VELOCITY_DOWNSCALE", "", "getFLING_VELOCITY_DOWNSCALE", "()I", "kellocharts_release"})
    public static final class Companion {
        public final int getFLING_VELOCITY_DOWNSCALE() {
            return FLING_VELOCITY_DOWNSCALE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

