/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.gesture;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import androidx.core.widget.ScrollerCompat;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lco/csadev/kellocharts/gesture/ChartScroller;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "scroller", "Landroidx/core/widget/ScrollerCompat;", "scrollerStartViewport", "Lco/csadev/kellocharts/model/Viewport;", "surfaceSizeBuffer", "Landroid/graphics/Point;", "computeScrollOffset", "", "computator", "Lco/csadev/kellocharts/computator/ChartComputator;", "fling", "velocityX", "", "velocityY", "scroll", "distanceX", "", "distanceY", "scrollResult", "Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;", "startScroll", "ScrollResult", "kellocharts_release"})
public final class ChartScroller {
    private final Viewport scrollerStartViewport;
    private final Point surfaceSizeBuffer;
    private final ScrollerCompat scroller;

    public final boolean startScroll(@NotNull ChartComputator computator) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        this.scroller.abortAnimation();
        ViewportKt.set(this.scrollerStartViewport, computator.getCurrentViewport$kellocharts_release());
        return true;
    }

    public final boolean scroll(@NotNull ChartComputator computator, float distanceX, float distanceY, @NotNull ScrollResult scrollResult) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        Intrinsics.checkParameterIsNotNull((Object)scrollResult, (String)"scrollResult");
        Viewport maxViewport = computator.getMaximumViewport();
        Viewport visibleViewport = computator.getVisibleViewport();
        Viewport currentViewport = computator.getCurrentViewport$kellocharts_release();
        Rect contentRect = computator.getContentRectMinusAllMargins();
        boolean canScrollLeft = currentViewport.getLeft() > maxViewport.getLeft();
        boolean canScrollRight = currentViewport.getRight() < maxViewport.getRight();
        boolean canScrollTop = currentViewport.getTop() < maxViewport.getTop();
        boolean canScrollBottom = currentViewport.getBottom() > maxViewport.getBottom();
        boolean canScrollX = false;
        boolean canScrollY = false;
        if (canScrollLeft && distanceX <= 0.0f) {
            canScrollX = true;
        } else if (canScrollRight && distanceX >= 0.0f) {
            canScrollX = true;
        }
        if (canScrollTop && distanceY <= 0.0f) {
            canScrollY = true;
        } else if (canScrollBottom && distanceY >= 0.0f) {
            canScrollY = true;
        }
        if (canScrollX || canScrollY) {
            computator.computeScrollSurfaceSize(this.surfaceSizeBuffer);
            float viewportOffsetX = distanceX * visibleViewport.width() / (float)contentRect.width();
            float viewportOffsetY = -distanceY * visibleViewport.height() / (float)contentRect.height();
            computator.setViewportTopLeft(currentViewport.getLeft() + viewportOffsetX, currentViewport.getTop() + viewportOffsetY);
        }
        scrollResult.setCanScrollX(canScrollX);
        scrollResult.setCanScrollY(canScrollY);
        return canScrollX || canScrollY;
    }

    public final boolean computeScrollOffset(@NotNull ChartComputator computator) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        if (this.scroller.computeScrollOffset()) {
            Viewport maxViewport = computator.getMaximumViewport();
            computator.computeScrollSurfaceSize(this.surfaceSizeBuffer);
            float currXRange = maxViewport.getLeft() + maxViewport.width() * (float)this.scroller.getCurrX() / (float)this.surfaceSizeBuffer.x;
            float currYRange = maxViewport.getTop() - maxViewport.height() * (float)this.scroller.getCurrY() / (float)this.surfaceSizeBuffer.y;
            computator.setViewportTopLeft(currXRange, currYRange);
            return true;
        }
        return false;
    }

    public final boolean fling(int velocityX, int velocityY, @NotNull ChartComputator computator) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        computator.computeScrollSurfaceSize(this.surfaceSizeBuffer);
        ViewportKt.set(this.scrollerStartViewport, computator.getCurrentViewport$kellocharts_release());
        int startX = (int)((float)this.surfaceSizeBuffer.x * (this.scrollerStartViewport.getLeft() - computator.getMaximumViewport().getLeft()) / computator.getMaximumViewport().width());
        int startY = (int)((float)this.surfaceSizeBuffer.y * (computator.getMaximumViewport().getTop() - this.scrollerStartViewport.getTop()) / computator.getMaximumViewport().height());
        this.scroller.abortAnimation();
        int width = computator.getContentRectMinusAllMargins().width();
        int height = computator.getContentRectMinusAllMargins().height();
        this.scroller.fling(startX, startY, velocityX, velocityY, 0, this.surfaceSizeBuffer.x - width + 1, 0, this.surfaceSizeBuffer.y - height + 1);
        return true;
    }

    public ChartScroller(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.scrollerStartViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.surfaceSizeBuffer = new Point();
        ScrollerCompat scrollerCompat = ScrollerCompat.create((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)scrollerCompat, (String)"ScrollerCompat.create(context)");
        this.scroller = scrollerCompat;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;", "", "()V", "canScrollX", "", "getCanScrollX", "()Z", "setCanScrollX", "(Z)V", "canScrollY", "getCanScrollY", "setCanScrollY", "kellocharts_release"})
    public static final class ScrollResult {
        private boolean canScrollX;
        private boolean canScrollY;

        public final boolean getCanScrollX() {
            return this.canScrollX;
        }

        public final void setCanScrollX(boolean bl) {
            this.canScrollX = bl;
        }

        public final boolean getCanScrollY() {
            return this.canScrollY;
        }

        public final void setCanScrollY(boolean bl) {
            this.canScrollY = bl;
        }
    }
}

