/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.formatter;

import android.util.Log;
import co.csadev.kellocharts.util.FloatUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0019J\u001e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003J \u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u0005J,\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00032\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0005H\u0007J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006&"}, d2={"Lco/csadev/kellocharts/formatter/ValueFormatterHelper;", "", "decimalDigitsNumber", "", "appendedText", "", "prependedText", "decimalSeparator", "", "(I[C[CC)V", "getAppendedText", "()[C", "setAppendedText", "([C)V", "getDecimalDigitsNumber", "()I", "setDecimalDigitsNumber", "(I)V", "getDecimalSeparator", "()C", "setDecimalSeparator", "(C)V", "getPrependedText", "setPrependedText", "appendText", "", "formattedValue", "determineDecimalSeparator", "formatFloatValue", "value", "", "formatFloatValueWithPrependedAndAppendedText", "label", "defaultDigitsNumber", "getAppliedDecimalDigitsNumber", "prependText", "charsNumber", "Companion", "kellocharts_release"})
public final class ValueFormatterHelper {
    private int decimalDigitsNumber;
    @NotNull
    private char[] appendedText;
    @NotNull
    private char[] prependedText;
    private char decimalSeparator;
    private static final int DEFAULT_DIGITS_NUMBER = 0;
    private static final String TAG = "ValueFormatterHelper";
    public static final Companion Companion = new Companion(null);

    public final void determineDecimalSeparator() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)numberFormat).getDecimalFormatSymbols();
            Intrinsics.checkExpressionValueIsNotNull((Object)decimalFormatSymbols, (String)"numberFormat.decimalFormatSymbols");
            this.decimalSeparator = decimalFormatSymbols.getDecimalSeparator();
        }
    }

    @NotNull
    public final ValueFormatterHelper setDecimalSeparator(char decimalSeparator) {
        char nullChar = '\u0000';
        if (nullChar != decimalSeparator) {
            this.decimalSeparator = decimalSeparator;
        }
        return this;
    }

    @JvmOverloads
    public final int formatFloatValueWithPrependedAndAppendedText(@NotNull char[] formattedValue, float value, int defaultDigitsNumber, @Nullable char[] label) {
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        if (label != null) {
            int labelLength = label.length;
            if (labelLength > formattedValue.length) {
                Log.w((String)TAG, (String)"Label length is larger than buffer size(64chars), some chars will be skipped!");
                labelLength = formattedValue.length;
            }
            System.arraycopy(label, 0, formattedValue, formattedValue.length - labelLength, labelLength);
            return labelLength;
        }
        int appliedDigitsNumber = this.getAppliedDecimalDigitsNumber(defaultDigitsNumber);
        int charsNumber = this.formatFloatValue(formattedValue, value, appliedDigitsNumber);
        this.appendText(formattedValue);
        this.prependText(formattedValue, charsNumber);
        return charsNumber + this.prependedText.length + this.appendedText.length;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int formatFloatValueWithPrependedAndAppendedText$default(ValueFormatterHelper valueFormatterHelper, char[] cArray, float f, int n, char[] cArray2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            cArray2 = null;
        }
        return valueFormatterHelper.formatFloatValueWithPrependedAndAppendedText(cArray, f, n, cArray2);
    }

    @JvmOverloads
    public final int formatFloatValueWithPrependedAndAppendedText(@NotNull char[] formattedValue, float value, int defaultDigitsNumber) {
        return ValueFormatterHelper.formatFloatValueWithPrependedAndAppendedText$default(this, formattedValue, value, defaultDigitsNumber, null, 8, null);
    }

    public final int formatFloatValueWithPrependedAndAppendedText(@NotNull char[] formattedValue, float value, @Nullable char[] label) {
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        return this.formatFloatValueWithPrependedAndAppendedText(formattedValue, value, DEFAULT_DIGITS_NUMBER, label);
    }

    public final int formatFloatValue(@NotNull char[] formattedValue, float value, int decimalDigitsNumber) {
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        return FloatUtils.INSTANCE.formatFloat(formattedValue, value, formattedValue.length - this.appendedText.length, decimalDigitsNumber, this.decimalSeparator);
    }

    public final void appendText(@NotNull char[] formattedValue) {
        char[] cArray;
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        char[] cArray2 = cArray = this.appendedText;
        if (!(cArray2.length == 0)) {
            System.arraycopy(this.appendedText, 0, formattedValue, formattedValue.length - this.appendedText.length, this.appendedText.length);
        }
    }

    public final void prependText(@NotNull char[] formattedValue, int charsNumber) {
        char[] cArray;
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        char[] cArray2 = cArray = this.prependedText;
        if (!(cArray2.length == 0)) {
            System.arraycopy(this.prependedText, 0, formattedValue, formattedValue.length - charsNumber - this.appendedText.length - this.prependedText.length, this.prependedText.length);
        }
    }

    public final int getAppliedDecimalDigitsNumber(int defaultDigitsNumber) {
        int appliedDecimalDigitsNumber = this.decimalDigitsNumber < 0 ? defaultDigitsNumber : this.decimalDigitsNumber;
        return appliedDecimalDigitsNumber;
    }

    public final int getDecimalDigitsNumber() {
        return this.decimalDigitsNumber;
    }

    public final void setDecimalDigitsNumber(int n) {
        this.decimalDigitsNumber = n;
    }

    @NotNull
    public final char[] getAppendedText() {
        return this.appendedText;
    }

    public final void setAppendedText(@NotNull char[] cArray) {
        Intrinsics.checkParameterIsNotNull((Object)cArray, (String)"<set-?>");
        this.appendedText = cArray;
    }

    @NotNull
    public final char[] getPrependedText() {
        return this.prependedText;
    }

    public final void setPrependedText(@NotNull char[] cArray) {
        Intrinsics.checkParameterIsNotNull((Object)cArray, (String)"<set-?>");
        this.prependedText = cArray;
    }

    public final char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public final void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public ValueFormatterHelper(int decimalDigitsNumber, @NotNull char[] appendedText, @NotNull char[] prependedText, char decimalSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)appendedText, (String)"appendedText");
        Intrinsics.checkParameterIsNotNull((Object)prependedText, (String)"prependedText");
        this.decimalDigitsNumber = decimalDigitsNumber;
        this.appendedText = appendedText;
        this.prependedText = prependedText;
        this.decimalSeparator = decimalSeparator;
    }

    public /* synthetic */ ValueFormatterHelper(int n, char[] cArray, char[] cArray2, char c, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n2 & 2) != 0) {
            cArray = new char[]{};
        }
        if ((n2 & 4) != 0) {
            cArray2 = new char[]{};
        }
        if ((n2 & 8) != 0) {
            c = (char)46;
        }
        this(n, cArray, cArray2, c);
    }

    public ValueFormatterHelper() {
        this(0, null, null, '\u0000', 15, null);
    }

    static {
        TAG = TAG;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lco/csadev/kellocharts/formatter/ValueFormatterHelper$Companion;", "", "()V", "DEFAULT_DIGITS_NUMBER", "", "getDEFAULT_DIGITS_NUMBER", "()I", "TAG", "", "kellocharts_release"})
    public static final class Companion {
        public final int getDEFAULT_DIGITS_NUMBER() {
            return DEFAULT_DIGITS_NUMBER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

