/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import co.csadev.kellocharts.animation.ChartAnimationListener;
import co.csadev.kellocharts.animation.DummyChartAnimationListener;
import co.csadev.kellocharts.animation.PieChartRotationAnimator;
import co.csadev.kellocharts.view.PieChartView;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\fH\u0016J\u0012\u0010\u001c\u001a\u00020\u00142\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lco/csadev/kellocharts/animation/PieChartRotationAnimatorV14;", "Lco/csadev/kellocharts/animation/PieChartRotationAnimator;", "Landroid/animation/Animator$AnimatorListener;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "chart", "Lco/csadev/kellocharts/view/PieChartView;", "duration", "", "(Lco/csadev/kellocharts/view/PieChartView;J)V", "animationListener", "Lco/csadev/kellocharts/animation/ChartAnimationListener;", "animator", "Landroid/animation/ValueAnimator;", "isAnimationStarted", "", "()Z", "startRotation", "", "targetRotation", "cancelAnimation", "", "onAnimationCancel", "animation", "Landroid/animation/Animator;", "onAnimationEnd", "onAnimationRepeat", "onAnimationStart", "onAnimationUpdate", "setChartAnimationListener", "startAnimation", "startAngle", "angleToRotate", "kellocharts_release"})
@SuppressLint(value={"NewApi"})
public final class PieChartRotationAnimatorV14
implements PieChartRotationAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private final ValueAnimator animator;
    private float startRotation;
    private float targetRotation;
    private ChartAnimationListener animationListener;
    private final PieChartView chart;

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void startAnimation(float startAngle, float angleToRotate) {
        this.startRotation = (startAngle % (float)360 + (float)360) % (float)360;
        this.targetRotation = (angleToRotate % (float)360 + (float)360) % (float)360;
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    public void onAnimationUpdate(@NotNull ValueAnimator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        float scale = animation.getAnimatedFraction();
        float rotation = this.startRotation + (this.targetRotation - this.startRotation) * scale;
        rotation = (rotation % (float)360 + (float)360) % (float)360;
        this.chart.setChartRotation((int)rotation, false);
    }

    public void onAnimationCancel(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
    }

    public void onAnimationEnd(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        this.chart.setChartRotation((int)this.targetRotation, false);
        this.animationListener.onAnimationFinished();
    }

    public void onAnimationRepeat(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
    }

    public void onAnimationStart(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        this.animationListener.onAnimationStarted();
    }

    @Override
    public void setChartAnimationListener(@Nullable ChartAnimationListener animationListener) {
        this.animationListener = animationListener == null ? (ChartAnimationListener)new DummyChartAnimationListener() : animationListener;
    }

    @JvmOverloads
    public PieChartRotationAnimatorV14(@NotNull PieChartView chart, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        this.chart = chart;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0.0f, 1.0f)");
        this.animator = valueAnimator;
        this.animationListener = new DummyChartAnimationListener();
        this.animator.setDuration(duration);
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
    }

    @JvmOverloads
    public /* synthetic */ PieChartRotationAnimatorV14(PieChartView pieChartView, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 200L;
        }
        this(pieChartView, l);
    }

    @JvmOverloads
    public PieChartRotationAnimatorV14(@NotNull PieChartView chart) {
        this(chart, 0L, 2, null);
    }
}

