/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.animation;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import co.csadev.kellocharts.animation.ChartAnimationListener;
import co.csadev.kellocharts.animation.ChartDataAnimator;
import co.csadev.kellocharts.animation.DummyChartAnimationListener;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001b"}, d2={"Lco/csadev/kellocharts/animation/ChartDataAnimatorV14;", "Lco/csadev/kellocharts/animation/ChartDataAnimator;", "Landroid/animation/Animator$AnimatorListener;", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "chart", "Lco/csadev/kellocharts/view/Chart;", "(Lco/csadev/kellocharts/view/Chart;)V", "animationListener", "Lco/csadev/kellocharts/animation/ChartAnimationListener;", "animator", "Landroid/animation/ValueAnimator;", "isAnimationStarted", "", "()Z", "cancelAnimation", "", "onAnimationCancel", "animation", "Landroid/animation/Animator;", "onAnimationEnd", "onAnimationRepeat", "onAnimationStart", "onAnimationUpdate", "setChartAnimationListener", "startAnimation", "duration", "", "kellocharts_release"})
@SuppressLint(value={"NewApi"})
public final class ChartDataAnimatorV14
implements ChartDataAnimator,
Animator.AnimatorListener,
ValueAnimator.AnimatorUpdateListener {
    private final ValueAnimator animator;
    private ChartAnimationListener animationListener;
    private final Chart chart;

    @Override
    public boolean isAnimationStarted() {
        return this.animator.isStarted();
    }

    @Override
    public void startAnimation(long duration) {
        if (duration >= 0L) {
            this.animator.setDuration(duration);
        } else {
            this.animator.setDuration(ChartDataAnimator.Companion.getDEFAULT_ANIMATION_DURATION());
        }
        this.animator.start();
    }

    @Override
    public void cancelAnimation() {
        this.animator.cancel();
    }

    public void onAnimationUpdate(@NotNull ValueAnimator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        this.chart.animationDataUpdate(animation.getAnimatedFraction());
    }

    public void onAnimationCancel(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
    }

    public void onAnimationEnd(@NotNull Animator animation) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            this.chart.animationDataFinished();
            ChartAnimationListener chartAnimationListener = this.animationListener;
            if (chartAnimationListener == null) break block0;
            chartAnimationListener.onAnimationFinished();
        }
    }

    public void onAnimationRepeat(@NotNull Animator animation) {
        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
    }

    public void onAnimationStart(@NotNull Animator animation) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            ChartAnimationListener chartAnimationListener = this.animationListener;
            if (chartAnimationListener == null) break block0;
            chartAnimationListener.onAnimationStarted();
        }
    }

    @Override
    public void setChartAnimationListener(@Nullable ChartAnimationListener animationListener) {
        this.animationListener = animationListener;
    }

    public ChartDataAnimatorV14(@NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        this.chart = chart;
        this.animationListener = new DummyChartAnimationListener();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"ValueAnimator.ofFloat(0.0f, 1.0f)");
        this.animator = valueAnimator;
        this.animator.addListener((Animator.AnimatorListener)this);
        this.animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
    }
}

