/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.util;

import co.csadev.kellocharts.util.AxisAutoValues;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u001fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006'"}, d2={"Lco/csadev/kellocharts/util/FloatUtils;", "", "()V", "POW10", "", "getPOW10", "()[I", "almostEqual", "", "a", "", "b", "absoluteDiff", "relativeDiff", "computeAutoGeneratedAxisValues", "", "start", "stop", "steps", "", "outValues", "Lco/csadev/kellocharts/util/AxisAutoValues;", "formatFloat", "formattedValue", "", "value", "endIndex", "digits", "separator", "", "nextDown", "", "d", "nextDownF", "f", "nextUp", "nextUpF", "roundToOneSignificantFigure", "num", "kellocharts_release"})
public final class FloatUtils {
    @NotNull
    private static final int[] POW10;
    public static final FloatUtils INSTANCE;

    @NotNull
    public final int[] getPOW10() {
        return POW10;
    }

    public final float nextUpF(float f) {
        float f2 = f;
        if (Float.isNaN(f2) || f2 == Float.POSITIVE_INFINITY) {
            return f2;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f2 += 0.0f) + (f2 >= 0.0f ? 1 : -1));
    }

    public final float nextDownF(float f) {
        return Float.isNaN(f) || f == Float.NEGATIVE_INFINITY ? f : (f == 0.0f ? -1.4E-45f : Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1)));
    }

    public final double nextUp(double d) {
        double d2 = d;
        if (Double.isNaN(d2) || d2 == Double.POSITIVE_INFINITY) {
            return d2;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d2 += 0.0) + (long)(d2 >= 0.0 ? 1 : -1));
    }

    public final double nextDown(double d) {
        return Double.isNaN(d) || d == Double.NEGATIVE_INFINITY ? d : (d == 0.0 ? (double)-1.4E-45f : Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (long)(d > (double)0.0f ? -1 : 1)));
    }

    public final boolean almostEqual(float a, float b, float absoluteDiff, float relativeDiff) {
        float a2 = a;
        float b2 = b;
        float diff = Math.abs(a2 - b2);
        if (diff <= absoluteDiff) {
            return true;
        }
        float largest = (a2 = Math.abs(a2)) > (b2 = Math.abs(b2)) ? a2 : b2;
        return diff <= largest * relativeDiff;
    }

    public final float roundToOneSignificantFigure(double num) {
        float d = (float)Math.ceil((float)Math.log10(num < 0.0 ? -num : num));
        int power = 1 - (int)d;
        float magnitude = (float)Math.pow(10.0, power);
        long shifted = Math.round(num * (double)magnitude);
        return (float)shifted / magnitude;
    }

    public final int formatFloat(@NotNull char[] formattedValue, float value, int endIndex, int digits, char separator) {
        Intrinsics.checkParameterIsNotNull((Object)formattedValue, (String)"formattedValue");
        float value2 = value;
        int digits2 = digits;
        if (digits2 >= POW10.length) {
            formattedValue[endIndex - 1] = 46;
            return 1;
        }
        boolean negative = false;
        if (value2 == 0.0f) {
            formattedValue[endIndex - 1] = 48;
            return 1;
        }
        if (value2 < 0.0f) {
            negative = true;
            value2 = -value2;
        }
        if (digits2 > POW10.length) {
            digits2 = POW10.length - 1;
        }
        long lval = Math.round(value2 *= (float)POW10[digits2]);
        int index = endIndex - 1;
        int charsNumber = 0;
        while (lval != 0L || charsNumber < digits2 + 1) {
            int digit = (int)(lval % (long)10);
            lval /= (long)10;
            formattedValue[index--] = (char)(digit + 48);
            if (++charsNumber != digits2) continue;
            formattedValue[index--] = separator;
            ++charsNumber;
        }
        if (formattedValue[index + 1] == separator) {
            formattedValue[index--] = 48;
            ++charsNumber;
        }
        if (negative) {
            formattedValue[index--] = 45;
            ++charsNumber;
        }
        return charsNumber;
    }

    public final void computeAutoGeneratedAxisValues(float start, float stop, int steps, @NotNull AxisAutoValues outValues) {
        double intervalValue;
        double intervalMagnitude;
        Intrinsics.checkParameterIsNotNull((Object)outValues, (String)"outValues");
        double range = stop - start;
        if (steps == 0 || range <= 0.0) {
            outValues.setValues(new float[0]);
            outValues.setValuesNumber(0);
            return;
        }
        double rawInterval = range / (double)steps;
        double interval = this.roundToOneSignificantFigure(rawInterval);
        int intervalSigDigit = (int)(interval / (intervalMagnitude = Math.pow(10.0, (int)Math.log10(interval))));
        if (intervalSigDigit > 5) {
            interval = Math.floor((double)10 * intervalMagnitude);
        }
        double first = Math.ceil((double)start / interval) * interval;
        double last = this.nextUp(Math.floor((double)stop / interval) * interval);
        int valuesNum = 0;
        for (intervalValue = first; intervalValue <= last; intervalValue += interval) {
            ++valuesNum;
        }
        outValues.setValuesNumber(valuesNum);
        if (outValues.getValues().length < valuesNum) {
            outValues.setValues(new float[valuesNum]);
        }
        intervalValue = first;
        for (int valueIndex = 0; valueIndex < valuesNum; ++valueIndex) {
            outValues.getValues()[valueIndex] = (float)intervalValue;
            intervalValue += interval;
        }
        if (interval < 1.0) {
            outValues.setDecimals((int)Math.ceil(-Math.log10(interval)));
        } else {
            outValues.setDecimals(0);
        }
    }

    private FloatUtils() {
    }

    static {
        FloatUtils floatUtils;
        INSTANCE = floatUtils = new FloatUtils();
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
    }
}

