/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.gesture.ChartZoomer$WhenMappings;
import co.csadev.kellocharts.gesture.ZoomType;
import co.csadev.kellocharts.gesture.ZoomerCompat;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0016\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lco/csadev/kellocharts/gesture/ChartZoomer;", "", "context", "Landroid/content/Context;", "zoomType", "Lco/csadev/kellocharts/gesture/ZoomType;", "(Landroid/content/Context;Lco/csadev/kellocharts/gesture/ZoomType;)V", "scrollerStartViewport", "Lco/csadev/kellocharts/model/Viewport;", "viewportFocus", "Landroid/graphics/PointF;", "zoomFocalPoint", "getZoomType", "()Lco/csadev/kellocharts/gesture/ZoomType;", "setZoomType", "(Lco/csadev/kellocharts/gesture/ZoomType;)V", "zoomer", "Lco/csadev/kellocharts/gesture/ZoomerCompat;", "computeZoom", "", "computator", "Lco/csadev/kellocharts/computator/ChartComputator;", "scale", "focusX", "", "focusY", "setCurrentViewport", "", "left", "top", "right", "bottom", "startZoom", "e", "Landroid/view/MotionEvent;", "Companion", "kellocharts_release"})
public final class ChartZoomer {
    private final ZoomerCompat zoomer;
    private final PointF zoomFocalPoint;
    private final PointF viewportFocus;
    private final Viewport scrollerStartViewport;
    @Nullable
    private ZoomType zoomType;
    private static final float ZOOM_AMOUNT = 0.25f;
    public static final Companion Companion = new Companion(null);

    public final boolean startZoom(@NotNull MotionEvent e, @NotNull ChartComputator computator) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        this.zoomer.forceFinished(true);
        ViewportKt.set(this.scrollerStartViewport, computator.getCurrentViewport$kellocharts_release());
        if (!computator.rawPixelsToDataPoint(e.getX(), e.getY(), this.zoomFocalPoint)) {
            return false;
        }
        this.zoomer.startZoom(Companion.getZOOM_AMOUNT());
        return true;
    }

    public final boolean computeZoom(@NotNull ChartComputator computator) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        if (this.zoomer.computeZoom()) {
            float newWidth = (1.0f - this.zoomer.getCurrZoom()) * this.scrollerStartViewport.width();
            float newHeight = (1.0f - this.zoomer.getCurrZoom()) * this.scrollerStartViewport.height();
            float pointWithinViewportX = (this.zoomFocalPoint.x - this.scrollerStartViewport.getLeft()) / this.scrollerStartViewport.width();
            float pointWithinViewportY = (this.zoomFocalPoint.y - this.scrollerStartViewport.getBottom()) / this.scrollerStartViewport.height();
            float left = this.zoomFocalPoint.x - newWidth * pointWithinViewportX;
            float top = this.zoomFocalPoint.y + newHeight * (1.0f - pointWithinViewportY);
            float right = this.zoomFocalPoint.x + newWidth * (1.0f - pointWithinViewportX);
            float bottom = this.zoomFocalPoint.y - newHeight * pointWithinViewportY;
            this.setCurrentViewport(computator, left, top, right, bottom);
            return true;
        }
        return false;
    }

    public final boolean scale(@NotNull ChartComputator computator, float focusX, float focusY, float scale) {
        Intrinsics.checkParameterIsNotNull((Object)computator, (String)"computator");
        float newWidth = scale * computator.getCurrentViewport$kellocharts_release().width();
        float newHeight = scale * computator.getCurrentViewport$kellocharts_release().height();
        if (!computator.rawPixelsToDataPoint(focusX, focusY, this.viewportFocus)) {
            return false;
        }
        float left = this.viewportFocus.x - (focusX - (float)computator.getContentRectMinusAllMargins().left) * (newWidth / (float)computator.getContentRectMinusAllMargins().width());
        float top = this.viewportFocus.y + (focusY - (float)computator.getContentRectMinusAllMargins().top) * (newHeight / (float)computator.getContentRectMinusAllMargins().height());
        float right = left + newWidth;
        float bottom = top - newHeight;
        this.setCurrentViewport(computator, left, top, right, bottom);
        return true;
    }

    private final void setCurrentViewport(ChartComputator computator, float left, float top, float right, float bottom) {
        Viewport currentViewport = computator.getCurrentViewport$kellocharts_release();
        ZoomType zoomType = this.zoomType;
        if (zoomType == null) {
            return;
        }
        switch (ChartZoomer$WhenMappings.$EnumSwitchMapping$0[zoomType.ordinal()]) {
            case 1: {
                computator.setCurrentViewport(left, currentViewport.getTop(), right, currentViewport.getBottom());
                break;
            }
            case 2: {
                computator.setCurrentViewport(currentViewport.getLeft(), top, currentViewport.getRight(), bottom);
                break;
            }
            case 3: {
                computator.setCurrentViewport(left, top, right, bottom);
            }
        }
    }

    @Nullable
    public final ZoomType getZoomType() {
        return this.zoomType;
    }

    public final void setZoomType(@Nullable ZoomType zoomType) {
        this.zoomType = zoomType;
    }

    public ChartZoomer(@NotNull Context context, @Nullable ZoomType zoomType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.zoomType = zoomType;
        this.zoomer = new ZoomerCompat(context);
        this.zoomFocalPoint = new PointF();
        this.viewportFocus = new PointF();
        this.scrollerStartViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    static {
        ZOOM_AMOUNT = 0.25f;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/gesture/ChartZoomer$Companion;", "", "()V", "ZOOM_AMOUNT", "", "getZOOM_AMOUNT", "()F", "kellocharts_release"})
    public static final class Companion {
        public final float getZOOM_AMOUNT() {
            return ZOOM_AMOUNT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

