/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewParent;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.gesture.ChartScroller;
import co.csadev.kellocharts.gesture.ChartZoomer;
import co.csadev.kellocharts.gesture.ContainerScrollType;
import co.csadev.kellocharts.gesture.ZoomType;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.renderer.ChartRenderer;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0002ghB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[H\u0002J\u0018\u0010\\\u001a\u00020*2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^H\u0002J\b\u0010`\u001a\u00020*H\u0016J\u0010\u0010a\u001a\u00020*2\u0006\u0010b\u001a\u00020cH\u0002J\b\u0010d\u001a\u00020YH\u0002J\u0010\u0010e\u001a\u00020*2\u0006\u0010b\u001a\u00020cH\u0016J\u001e\u0010e\u001a\u00020*2\u0006\u0010b\u001a\u00020c2\u0006\u0010L\u001a\u00020M2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010f\u001a\u00020YR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010+\"\u0004\b/\u0010-R\u001a\u00100\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010+\"\u0004\b1\u0010-R\u001a\u00102\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010+\"\u0004\b3\u0010-R\u001a\u00104\u001a\u000205X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020AX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u000205X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u00107\"\u0004\bH\u00109R\u001a\u0010I\u001a\u000205X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u00107\"\u0004\bK\u00109R\u001c\u0010L\u001a\u0004\u0018\u00010MX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR(\u0010R\u001a\u0004\u0018\u00010S2\b\u0010R\u001a\u0004\u0018\u00010S8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010W\u00a8\u0006i"}, d2={"Lco/csadev/kellocharts/gesture/ChartTouchHandler;", "", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;)V", "getChart", "()Lco/csadev/kellocharts/view/Chart;", "setChart", "(Lco/csadev/kellocharts/view/Chart;)V", "chartScroller", "Lco/csadev/kellocharts/gesture/ChartScroller;", "getChartScroller", "()Lco/csadev/kellocharts/gesture/ChartScroller;", "setChartScroller", "(Lco/csadev/kellocharts/gesture/ChartScroller;)V", "chartZoomer", "Lco/csadev/kellocharts/gesture/ChartZoomer;", "getChartZoomer", "()Lco/csadev/kellocharts/gesture/ChartZoomer;", "setChartZoomer", "(Lco/csadev/kellocharts/gesture/ChartZoomer;)V", "computator", "Lco/csadev/kellocharts/computator/ChartComputator;", "getComputator", "()Lco/csadev/kellocharts/computator/ChartComputator;", "setComputator", "(Lco/csadev/kellocharts/computator/ChartComputator;)V", "containerScrollType", "Lco/csadev/kellocharts/gesture/ContainerScrollType;", "getContainerScrollType", "()Lco/csadev/kellocharts/gesture/ContainerScrollType;", "setContainerScrollType", "(Lco/csadev/kellocharts/gesture/ContainerScrollType;)V", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "setGestureDetector", "(Landroid/view/GestureDetector;)V", "isScrollEnabled", "", "()Z", "setScrollEnabled", "(Z)V", "isValueSelectionEnabled", "setValueSelectionEnabled", "isValueTouchEnabled", "setValueTouchEnabled", "isZoomEnabled", "setZoomEnabled", "oldSelectedValue", "Lco/csadev/kellocharts/model/SelectedValue;", "getOldSelectedValue", "()Lco/csadev/kellocharts/model/SelectedValue;", "setOldSelectedValue", "(Lco/csadev/kellocharts/model/SelectedValue;)V", "renderer", "Lco/csadev/kellocharts/renderer/ChartRenderer;", "getRenderer", "()Lco/csadev/kellocharts/renderer/ChartRenderer;", "setRenderer", "(Lco/csadev/kellocharts/renderer/ChartRenderer;)V", "scaleGestureDetector", "Landroid/view/ScaleGestureDetector;", "getScaleGestureDetector", "()Landroid/view/ScaleGestureDetector;", "setScaleGestureDetector", "(Landroid/view/ScaleGestureDetector;)V", "selectedValue", "getSelectedValue", "setSelectedValue", "selectionModeOldValue", "getSelectionModeOldValue", "setSelectionModeOldValue", "viewParent", "Landroid/view/ViewParent;", "getViewParent", "()Landroid/view/ViewParent;", "setViewParent", "(Landroid/view/ViewParent;)V", "zoomType", "Lco/csadev/kellocharts/gesture/ZoomType;", "getZoomType", "()Lco/csadev/kellocharts/gesture/ZoomType;", "setZoomType", "(Lco/csadev/kellocharts/gesture/ZoomType;)V", "allowParentInterceptTouchEvent", "", "scrollResult", "Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;", "checkTouch", "touchX", "", "touchY", "computeScroll", "computeTouch", "event", "Landroid/view/MotionEvent;", "disallowParentInterceptTouchEvent", "handleTouchEvent", "resetTouchHandler", "ChartGestureListener", "ChartScaleGestureListener", "kellocharts_release"})
public class ChartTouchHandler {
    @NotNull
    private GestureDetector gestureDetector;
    @NotNull
    private ScaleGestureDetector scaleGestureDetector;
    @NotNull
    private ChartScroller chartScroller;
    @NotNull
    private ChartZoomer chartZoomer;
    @NotNull
    private ChartComputator computator;
    @NotNull
    private ChartRenderer renderer;
    private boolean isZoomEnabled;
    private boolean isScrollEnabled;
    private boolean isValueTouchEnabled;
    private boolean isValueSelectionEnabled;
    @NotNull
    private SelectedValue selectionModeOldValue;
    @NotNull
    private SelectedValue selectedValue;
    @NotNull
    private SelectedValue oldSelectedValue;
    @Nullable
    private ViewParent viewParent;
    @NotNull
    private ContainerScrollType containerScrollType;
    @NotNull
    private Chart chart;

    @NotNull
    protected final GestureDetector getGestureDetector() {
        return this.gestureDetector;
    }

    protected final void setGestureDetector(@NotNull GestureDetector gestureDetector) {
        Intrinsics.checkParameterIsNotNull((Object)gestureDetector, (String)"<set-?>");
        this.gestureDetector = gestureDetector;
    }

    @NotNull
    protected final ScaleGestureDetector getScaleGestureDetector() {
        return this.scaleGestureDetector;
    }

    protected final void setScaleGestureDetector(@NotNull ScaleGestureDetector scaleGestureDetector) {
        Intrinsics.checkParameterIsNotNull((Object)scaleGestureDetector, (String)"<set-?>");
        this.scaleGestureDetector = scaleGestureDetector;
    }

    @NotNull
    protected final ChartScroller getChartScroller() {
        return this.chartScroller;
    }

    protected final void setChartScroller(@NotNull ChartScroller chartScroller) {
        Intrinsics.checkParameterIsNotNull((Object)chartScroller, (String)"<set-?>");
        this.chartScroller = chartScroller;
    }

    @NotNull
    protected final ChartZoomer getChartZoomer() {
        return this.chartZoomer;
    }

    protected final void setChartZoomer(@NotNull ChartZoomer chartZoomer) {
        Intrinsics.checkParameterIsNotNull((Object)chartZoomer, (String)"<set-?>");
        this.chartZoomer = chartZoomer;
    }

    @NotNull
    protected final ChartComputator getComputator() {
        return this.computator;
    }

    protected final void setComputator(@NotNull ChartComputator chartComputator) {
        Intrinsics.checkParameterIsNotNull((Object)chartComputator, (String)"<set-?>");
        this.computator = chartComputator;
    }

    @NotNull
    protected final ChartRenderer getRenderer() {
        return this.renderer;
    }

    protected final void setRenderer(@NotNull ChartRenderer chartRenderer) {
        Intrinsics.checkParameterIsNotNull((Object)chartRenderer, (String)"<set-?>");
        this.renderer = chartRenderer;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    public final boolean isScrollEnabled() {
        return this.isScrollEnabled;
    }

    public final void setScrollEnabled(boolean bl) {
        this.isScrollEnabled = bl;
    }

    public final boolean isValueTouchEnabled() {
        return this.isValueTouchEnabled;
    }

    public final void setValueTouchEnabled(boolean bl) {
        this.isValueTouchEnabled = bl;
    }

    public final boolean isValueSelectionEnabled() {
        return this.isValueSelectionEnabled;
    }

    public final void setValueSelectionEnabled(boolean bl) {
        this.isValueSelectionEnabled = bl;
    }

    @NotNull
    protected final SelectedValue getSelectionModeOldValue() {
        return this.selectionModeOldValue;
    }

    protected final void setSelectionModeOldValue(@NotNull SelectedValue selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"<set-?>");
        this.selectionModeOldValue = selectedValue;
    }

    @NotNull
    protected final SelectedValue getSelectedValue() {
        return this.selectedValue;
    }

    protected final void setSelectedValue(@NotNull SelectedValue selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"<set-?>");
        this.selectedValue = selectedValue;
    }

    @NotNull
    protected final SelectedValue getOldSelectedValue() {
        return this.oldSelectedValue;
    }

    protected final void setOldSelectedValue(@NotNull SelectedValue selectedValue) {
        Intrinsics.checkParameterIsNotNull((Object)selectedValue, (String)"<set-?>");
        this.oldSelectedValue = selectedValue;
    }

    @Nullable
    protected final ViewParent getViewParent() {
        return this.viewParent;
    }

    protected final void setViewParent(@Nullable ViewParent viewParent) {
        this.viewParent = viewParent;
    }

    @NotNull
    protected final ContainerScrollType getContainerScrollType() {
        return this.containerScrollType;
    }

    protected final void setContainerScrollType(@NotNull ContainerScrollType containerScrollType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)containerScrollType), (String)"<set-?>");
        this.containerScrollType = containerScrollType;
    }

    @Nullable
    public final ZoomType getZoomType() {
        return this.chartZoomer.getZoomType();
    }

    public final void setZoomType(@Nullable ZoomType zoomType) {
        this.chartZoomer.setZoomType(zoomType);
    }

    public final void resetTouchHandler() {
        this.computator = this.chart.getChartComputator();
        this.renderer = this.chart.getChartRenderer();
    }

    public boolean computeScroll() {
        boolean needInvalidate = false;
        if (this.isScrollEnabled && this.chartScroller.computeScrollOffset(this.computator)) {
            needInvalidate = true;
        }
        if (this.isZoomEnabled && this.chartZoomer.computeZoom(this.computator)) {
            needInvalidate = true;
        }
        return needInvalidate;
    }

    public boolean handleTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        boolean needInvalidate = false;
        needInvalidate = this.gestureDetector.onTouchEvent(event);
        boolean bl = needInvalidate = this.scaleGestureDetector.onTouchEvent(event) || needInvalidate;
        if (this.isZoomEnabled && this.scaleGestureDetector.isInProgress()) {
            this.disallowParentInterceptTouchEvent();
        }
        if (this.isValueTouchEnabled) {
            needInvalidate = this.computeTouch(event) || needInvalidate;
        }
        return needInvalidate;
    }

    public final boolean handleTouchEvent(@NotNull MotionEvent event, @NotNull ViewParent viewParent, @NotNull ContainerScrollType containerScrollType) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Intrinsics.checkParameterIsNotNull((Object)viewParent, (String)"viewParent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)containerScrollType), (String)"containerScrollType");
        this.viewParent = viewParent;
        this.containerScrollType = containerScrollType;
        return this.handleTouchEvent(event);
    }

    private final void disallowParentInterceptTouchEvent() {
        if (this.viewParent != null) {
            ViewParent viewParent = this.viewParent;
            if (viewParent == null) {
                Intrinsics.throwNpe();
            }
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private final void allowParentInterceptTouchEvent(ChartScroller.ScrollResult scrollResult) {
        if (this.viewParent != null) {
            if (Intrinsics.areEqual((Object)((Object)ContainerScrollType.HORIZONTAL), (Object)((Object)this.containerScrollType)) && !scrollResult.getCanScrollX() && !this.scaleGestureDetector.isInProgress()) {
                ViewParent viewParent = this.viewParent;
                if (viewParent == null) {
                    Intrinsics.throwNpe();
                }
                viewParent.requestDisallowInterceptTouchEvent(false);
            } else if (Intrinsics.areEqual((Object)((Object)ContainerScrollType.VERTICAL), (Object)((Object)this.containerScrollType)) && !scrollResult.getCanScrollY() && !this.scaleGestureDetector.isInProgress()) {
                ViewParent viewParent = this.viewParent;
                if (viewParent == null) {
                    Intrinsics.throwNpe();
                }
                viewParent.requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    private final boolean computeTouch(MotionEvent event) {
        boolean needInvalidate = false;
        switch (event.getAction()) {
            case 0: {
                boolean wasTouched = this.renderer.isTouched();
                boolean isTouched = this.checkTouch(event.getX(), event.getY());
                if (wasTouched == isTouched) break;
                needInvalidate = true;
                if (!this.isValueSelectionEnabled) break;
                this.selectionModeOldValue.clear();
                if (!wasTouched || this.renderer.isTouched()) break;
                this.chart.callTouchListener();
                break;
            }
            case 1: {
                if (!this.renderer.isTouched()) break;
                if (this.checkTouch(event.getX(), event.getY())) {
                    if (this.isValueSelectionEnabled) {
                        if (Intrinsics.areEqual((Object)this.selectionModeOldValue, (Object)this.selectedValue) ^ true) {
                            this.selectionModeOldValue.set(this.selectedValue);
                            this.chart.callTouchListener();
                        }
                    } else {
                        this.chart.callTouchListener();
                        this.renderer.clearTouch();
                    }
                } else {
                    this.renderer.clearTouch();
                }
                needInvalidate = true;
                break;
            }
            case 2: {
                if (!this.renderer.isTouched() || this.checkTouch(event.getX(), event.getY())) break;
                this.renderer.clearTouch();
                needInvalidate = true;
                break;
            }
            case 3: {
                if (!this.renderer.isTouched()) break;
                this.renderer.clearTouch();
                needInvalidate = true;
            }
        }
        return needInvalidate;
    }

    private final boolean checkTouch(float touchX, float touchY) {
        this.oldSelectedValue.set(this.selectedValue);
        this.selectedValue.clear();
        if (this.renderer.checkTouch(touchX, touchY)) {
            this.selectedValue.set(this.renderer.getSelectedValue());
        }
        return this.oldSelectedValue.isSet() && this.selectedValue.isSet() && Intrinsics.areEqual((Object)this.oldSelectedValue, (Object)this.selectedValue) ^ true ? false : this.renderer.isTouched();
    }

    @NotNull
    protected final Chart getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"<set-?>");
        this.chart = chart;
    }

    public ChartTouchHandler(@NotNull Context context, @NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        this.chart = chart;
        this.isZoomEnabled = true;
        this.isScrollEnabled = true;
        this.isValueTouchEnabled = true;
        this.selectionModeOldValue = new SelectedValue(0, 0, null, 7, null);
        this.selectedValue = new SelectedValue(0, 0, null, 7, null);
        this.oldSelectedValue = new SelectedValue(0, 0, null, 7, null);
        this.containerScrollType = ContainerScrollType.HORIZONTAL;
        this.computator = this.chart.getChartComputator();
        this.renderer = this.chart.getChartRenderer();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new ChartGestureListener());
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ChartScaleGestureListener());
        this.chartScroller = new ChartScroller(context);
        this.chartZoomer = new ChartZoomer(context, ZoomType.HORIZONTAL_AND_VERTICAL);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/gesture/ChartTouchHandler$ChartScaleGestureListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lco/csadev/kellocharts/gesture/ChartTouchHandler;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "kellocharts_release"})
    protected final class ChartScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            if (ChartTouchHandler.this.isZoomEnabled()) {
                float scale = 2.0f - detector.getScaleFactor();
                if (Float.isInfinite(scale)) {
                    scale = 1.0f;
                }
                return ChartTouchHandler.this.getChartZoomer().scale(ChartTouchHandler.this.getComputator(), detector.getFocusX(), detector.getFocusY(), scale);
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lco/csadev/kellocharts/gesture/ChartTouchHandler$ChartGestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lco/csadev/kellocharts/gesture/ChartTouchHandler;)V", "scrollResult", "Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;", "getScrollResult", "()Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;", "setScrollResult", "(Lco/csadev/kellocharts/gesture/ChartScroller$ScrollResult;)V", "onDoubleTap", "", "e", "Landroid/view/MotionEvent;", "onDown", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onScroll", "distanceX", "distanceY", "kellocharts_release"})
    protected class ChartGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        @NotNull
        private ChartScroller.ScrollResult scrollResult = new ChartScroller.ScrollResult();

        @NotNull
        protected final ChartScroller.ScrollResult getScrollResult() {
            return this.scrollResult;
        }

        protected final void setScrollResult(@NotNull ChartScroller.ScrollResult scrollResult) {
            Intrinsics.checkParameterIsNotNull((Object)scrollResult, (String)"<set-?>");
            this.scrollResult = scrollResult;
        }

        public boolean onDown(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            if (ChartTouchHandler.this.isScrollEnabled()) {
                ChartTouchHandler.this.disallowParentInterceptTouchEvent();
                return ChartTouchHandler.this.getChartScroller().startScroll(ChartTouchHandler.this.getComputator());
            }
            return false;
        }

        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return ChartTouchHandler.this.isZoomEnabled() ? ChartTouchHandler.this.getChartZoomer().startZoom(e, ChartTouchHandler.this.getComputator()) : false;
        }

        public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            if (ChartTouchHandler.this.isScrollEnabled()) {
                boolean canScroll = ChartTouchHandler.this.getChartScroller().scroll(ChartTouchHandler.this.getComputator(), distanceX, distanceY, this.scrollResult);
                ChartTouchHandler.this.allowParentInterceptTouchEvent(this.scrollResult);
                return canScroll;
            }
            return false;
        }

        public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
            Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
            return ChartTouchHandler.this.isScrollEnabled() ? ChartTouchHandler.this.getChartScroller().fling((int)(-velocityX), (int)(-velocityY), ChartTouchHandler.this.getComputator()) : false;
        }
    }
}

