/*
 * Decompiled with CFR 0.152.
 */
package co.chiragm.sbn;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import co.chiragm.sbn.R;

public class StatusBarNotifier {
    private long autoHideDelayMillis = 3000L;
    private boolean autoHide = true;
    private boolean isVisible = false;
    private Activity activity;
    private View sbn;
    private Runnable autoHideRunnable;

    private StatusBarNotifier(Activity activity) {
        this.activity = activity;
    }

    private void init() {
        this.setFullScreen();
        this.addSBNView();
        this.autoHideRunnable = new Runnable(){

            @Override
            public void run() {
                StatusBarNotifier.this.hide();
            }
        };
    }

    private void setFullScreen() {
        this.getDecorView().setSystemUiVisibility(1024);
    }

    private void addSBNView() {
        ViewGroup root = (ViewGroup)((ViewGroup)this.activity.findViewById(0x1020002)).getChildAt(0);
        this.sbn = View.inflate((Context)this.activity, (int)R.layout.status_bar_notifier, (ViewGroup)root);
    }

    private View getDecorView() {
        return this.activity.getWindow().getDecorView();
    }

    public void show() {
        this.getDecorView().setSystemUiVisibility(5380);
        this.isVisible = true;
        if (this.autoHide) {
            new Handler().postDelayed(this.autoHideRunnable, this.autoHideDelayMillis);
        }
    }

    public void hide() {
        this.setFullScreen();
        this.isVisible = false;
    }

    public void setBackgroundColor(int color) {
        this.sbn.findViewById(R.id.proxy_status_bar).setBackgroundColor(color);
    }

    public void setText(String text) {
        this.getTextView().setText((CharSequence)text);
    }

    public TextView getTextView() {
        return (TextView)this.sbn.findViewById(R.id.sbn_text);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public static class Builder {
        private StatusBarNotifier sbn;

        public Builder(@NonNull Activity activity) {
            this.sbn = new StatusBarNotifier(activity);
        }

        public Builder setAutoHide(boolean autoHide) {
            this.sbn.autoHide = autoHide;
            return this;
        }

        public Builder setAutoHideDelayMillis(long autoHideDelayMillis) {
            this.sbn.autoHideDelayMillis = autoHideDelayMillis;
            return this;
        }

        public StatusBarNotifier build() {
            this.sbn.init();
            return this.sbn;
        }
    }
}

