/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.snapshot;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionVisibilityState;
import co.cask.tephra.snapshot.BinaryDecoder;
import co.cask.tephra.snapshot.BinaryEncoder;
import co.cask.tephra.snapshot.SnapshotCodec;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultSnapshotCodec
implements SnapshotCodec {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSnapshotCodec.class);

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void encode(OutputStream out, TransactionSnapshot snapshot) {
        try {
            BinaryEncoder encoder = new BinaryEncoder(out);
            encoder.writeLong(snapshot.getTimestamp());
            encoder.writeLong(snapshot.getReadPointer());
            encoder.writeLong(snapshot.getWritePointer());
            this.encodeInvalid(encoder, snapshot.getInvalid());
            this.encodeInProgress(encoder, snapshot.getInProgress());
            this.encodeChangeSets(encoder, snapshot.getCommittingChangeSets());
            this.encodeChangeSets(encoder, snapshot.getCommittedChangeSets());
        }
        catch (IOException e) {
            LOG.error("Unable to serialize transaction state: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public TransactionSnapshot decode(InputStream in) {
        BinaryDecoder decoder = new BinaryDecoder(in);
        try {
            TransactionVisibilityState minTxSnapshot = this.decodeTransactionVisibilityState(in);
            NavigableMap<Long, Set<ChangeId>> committing = this.decodeChangeSets(decoder);
            NavigableMap<Long, Set<ChangeId>> committed = this.decodeChangeSets(decoder);
            return new TransactionSnapshot(minTxSnapshot.getTimestamp(), minTxSnapshot.getReadPointer(), minTxSnapshot.getWritePointer(), minTxSnapshot.getInvalid(), minTxSnapshot.getInProgress(), committing, committed);
        }
        catch (IOException e) {
            LOG.error("Unable to deserialize transaction state: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public TransactionVisibilityState decodeTransactionVisibilityState(InputStream in) {
        BinaryDecoder decoder = new BinaryDecoder(in);
        try {
            long timestamp = decoder.readLong();
            long readPointer = decoder.readLong();
            long writePointer = decoder.readLong();
            Collection<Long> invalid = this.decodeInvalid(decoder);
            NavigableMap<Long, TransactionManager.InProgressTx> inProgress = this.decodeInProgress(decoder);
            return new TransactionSnapshot(timestamp, readPointer, writePointer, invalid, inProgress);
        }
        catch (IOException e) {
            LOG.error("Unable to deserialize transaction state: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void encodeInvalid(BinaryEncoder encoder, Collection<Long> invalid) throws IOException {
        if (!invalid.isEmpty()) {
            encoder.writeInt(invalid.size());
            for (long invalidTx : invalid) {
                encoder.writeLong(invalidTx);
            }
        }
        encoder.writeInt(0);
    }

    private Collection<Long> decodeInvalid(BinaryDecoder decoder) throws IOException {
        int size = decoder.readInt();
        ArrayList invalid = Lists.newArrayListWithCapacity((int)size);
        while (size != 0) {
            for (int remaining = size; remaining > 0; --remaining) {
                invalid.add(decoder.readLong());
            }
            size = decoder.readInt();
        }
        return invalid;
    }

    protected void encodeInProgress(BinaryEncoder encoder, Map<Long, TransactionManager.InProgressTx> inProgress) throws IOException {
        if (!inProgress.isEmpty()) {
            encoder.writeInt(inProgress.size());
            for (Map.Entry<Long, TransactionManager.InProgressTx> entry : inProgress.entrySet()) {
                encoder.writeLong(entry.getKey());
                encoder.writeLong(entry.getValue().getExpiration());
                encoder.writeLong(entry.getValue().getVisibilityUpperBound());
            }
        }
        encoder.writeInt(0);
    }

    protected NavigableMap<Long, TransactionManager.InProgressTx> decodeInProgress(BinaryDecoder decoder) throws IOException {
        int size = decoder.readInt();
        TreeMap inProgress = Maps.newTreeMap();
        while (size != 0) {
            for (int remaining = size; remaining > 0; --remaining) {
                long txId = decoder.readLong();
                long expiration = decoder.readLong();
                long visibilityUpperBound = decoder.readLong();
                inProgress.put(txId, new TransactionManager.InProgressTx(visibilityUpperBound, expiration));
            }
            size = decoder.readInt();
        }
        return inProgress;
    }

    private void encodeChangeSets(BinaryEncoder encoder, Map<Long, Set<ChangeId>> changes) throws IOException {
        if (!changes.isEmpty()) {
            encoder.writeInt(changes.size());
            for (Map.Entry<Long, Set<ChangeId>> entry : changes.entrySet()) {
                encoder.writeLong(entry.getKey());
                this.encodeChanges(encoder, entry.getValue());
            }
        }
        encoder.writeInt(0);
    }

    private NavigableMap<Long, Set<ChangeId>> decodeChangeSets(BinaryDecoder decoder) throws IOException {
        int size = decoder.readInt();
        TreeMap<Long, Set<ChangeId>> changeSets = new TreeMap<Long, Set<ChangeId>>();
        while (size != 0) {
            for (int remaining = size; remaining > 0; --remaining) {
                changeSets.put(decoder.readLong(), this.decodeChanges(decoder));
            }
            size = decoder.readInt();
        }
        return changeSets;
    }

    private void encodeChanges(BinaryEncoder encoder, Set<ChangeId> changes) throws IOException {
        if (!changes.isEmpty()) {
            encoder.writeInt(changes.size());
            for (ChangeId change : changes) {
                encoder.writeBytes(change.getKey());
            }
        }
        encoder.writeInt(0);
    }

    private Set<ChangeId> decodeChanges(BinaryDecoder decoder) throws IOException {
        int size = decoder.readInt();
        HashSet changes = Sets.newHashSetWithExpectedSize((int)size);
        while (size != 0) {
            for (int remaining = size; remaining > 0; --remaining) {
                changes.add(new ChangeId(decoder.readBytes()));
            }
            size = decoder.readInt();
        }
        return changes;
    }
}

