/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.inmemory;

import co.cask.tephra.InvalidTruncateTimeException;
import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionCouldNotTakeSnapshotException;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTxSystemClient
implements TransactionSystemClient {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryTxSystemClient.class);
    TransactionManager txManager;

    @Inject
    public InMemoryTxSystemClient(TransactionManager txmgr) {
        this.txManager = txmgr;
    }

    @Override
    public Transaction startLong() {
        return this.txManager.startLong();
    }

    @Override
    public Transaction startShort() {
        return this.txManager.startShort();
    }

    @Override
    public Transaction startShort(int timeout) {
        return this.txManager.startShort(timeout);
    }

    @Override
    public boolean canCommit(Transaction tx, Collection<byte[]> changeIds) throws TransactionNotInProgressException {
        return changeIds.isEmpty() || this.txManager.canCommit(tx, changeIds);
    }

    @Override
    public boolean commit(Transaction tx) throws TransactionNotInProgressException {
        return this.txManager.commit(tx);
    }

    @Override
    public void abort(Transaction tx) {
        this.txManager.abort(tx);
    }

    @Override
    public boolean invalidate(long tx) {
        return this.txManager.invalidate(tx);
    }

    @Override
    public Transaction checkpoint(Transaction tx) throws TransactionNotInProgressException {
        return this.txManager.checkpoint(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getSnapshotInputStream() throws TransactionCouldNotTakeSnapshotException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                boolean snapshotTaken = this.txManager.takeSnapshot(out);
                if (!snapshotTaken) {
                    throw new TransactionCouldNotTakeSnapshotException("Transaction manager did not take a snapshot.");
                }
            }
            return new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            LOG.error("Snapshot could not be taken", (Throwable)e);
            throw new TransactionCouldNotTakeSnapshotException(e.getMessage());
        }
    }

    @Override
    public String status() {
        return this.txManager.isRunning() ? "OK" : "NOTOK";
    }

    @Override
    public void resetState() {
        this.txManager.resetState();
    }

    @Override
    public boolean truncateInvalidTx(Set<Long> invalidTxIds) {
        return this.txManager.truncateInvalidTx(invalidTxIds);
    }

    @Override
    public boolean truncateInvalidTxBefore(long time) throws InvalidTruncateTimeException {
        return this.txManager.truncateInvalidTxBefore(time);
    }

    @Override
    public int getInvalidSize() {
        return this.txManager.getInvalidSize();
    }
}

