/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionType;
import co.cask.tephra.persist.TransactionVisibilityState;
import com.google.common.primitives.Longs;
import java.util.Map;

public class TxUtils {
    private static final long MAX_NON_TX_TIMESTAMP = (long)((double)System.currentTimeMillis() * 1.1);

    public static long getOldestVisibleTimestamp(Map<byte[], Long> ttlByFamily, Transaction tx) {
        long maxTTL = TxUtils.getMaxTTL(ttlByFamily);
        return maxTTL < Long.MAX_VALUE ? tx.getVisibilityUpperBound() - maxTTL * 1000000L : 0L;
    }

    public static long getOldestVisibleTimestamp(Map<byte[], Long> ttlByFamily, Transaction tx, boolean readNonTxnData) {
        if (readNonTxnData) {
            long maxTTL = TxUtils.getMaxTTL(ttlByFamily);
            return maxTTL < Long.MAX_VALUE ? System.currentTimeMillis() - maxTTL : 0L;
        }
        return TxUtils.getOldestVisibleTimestamp(ttlByFamily, tx);
    }

    public static long getMaxVisibleTimestamp(Transaction tx) {
        return tx.getWritePointer() < Long.MAX_VALUE ? tx.getWritePointer() + 1L : tx.getWritePointer();
    }

    public static Transaction createDummyTransaction(TransactionVisibilityState txVisibilityState) {
        return new Transaction(txVisibilityState.getReadPointer(), Long.MAX_VALUE, Longs.toArray(txVisibilityState.getInvalid()), Longs.toArray(txVisibilityState.getInProgress().keySet()), TxUtils.getFirstShortInProgress(txVisibilityState.getInProgress()), TransactionType.SHORT);
    }

    public static long getFirstShortInProgress(Map<Long, TransactionManager.InProgressTx> inProgress) {
        long firstShort = Long.MAX_VALUE;
        for (Map.Entry<Long, TransactionManager.InProgressTx> entry : inProgress.entrySet()) {
            if (entry.getValue().isLongRunning()) continue;
            firstShort = entry.getKey();
            break;
        }
        return firstShort;
    }

    public static long getTimestampForTTL(long cellTs) {
        return TxUtils.isPreExistingVersion(cellTs) ? cellTs * 1000000L : cellTs;
    }

    private static long getMaxTTL(Map<byte[], Long> ttlByFamily) {
        long maxTTL = 0L;
        for (Long familyTTL : ttlByFamily.values()) {
            maxTTL = Math.max(familyTTL <= 0L ? Long.MAX_VALUE : familyTTL, maxTTL);
        }
        return maxTTL == 0L ? Long.MAX_VALUE : maxTTL;
    }

    public static boolean isPreExistingVersion(long version) {
        return version < MAX_NON_TX_TIMESTAMP;
    }
}

