/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.TransactionManager;
import co.cask.tephra.distributed.TransactionServiceThriftHandler;
import co.cask.tephra.distributed.thrift.TTransactionServer;
import co.cask.tephra.inmemory.InMemoryTransactionService;
import co.cask.tephra.rpc.ThriftRPCServer;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.api.ElectionHandler;
import org.apache.twill.common.ServiceListenerAdapter;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.internal.zookeeper.LeaderElection;
import org.apache.twill.zookeeper.ZKClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactionService
extends InMemoryTransactionService {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionService.class);
    private LeaderElection leaderElection;
    private final ZKClient zkClient;
    private ThriftRPCServer<TransactionServiceThriftHandler, TTransactionServer> server;

    @Inject
    public TransactionService(Configuration conf, ZKClient zkClient, DiscoveryService discoveryService, Provider<TransactionManager> txManagerProvider) {
        super(conf, discoveryService, txManagerProvider);
        this.zkClient = zkClient;
    }

    @Override
    protected InetSocketAddress getAddress() {
        if (this.address.equals("0.0.0.0")) {
            try {
                return new InetSocketAddress(InetAddress.getLocalHost().getHostName(), this.server.getBindAddress().getPort());
            }
            catch (UnknownHostException x) {
                LOG.error("Cannot resolve hostname for 0.0.0.0", (Throwable)x);
            }
        }
        return this.server.getBindAddress();
    }

    @Override
    protected void doStart() {
        this.leaderElection = new LeaderElection(this.zkClient, "/tx.service/leader", new ElectionHandler(){

            public void leader() {
                TransactionService.this.txManager = (TransactionManager)((Object)TransactionService.this.txManagerProvider.get());
                TransactionService.this.txManager.addListener((Service.Listener)new ServiceListenerAdapter(){

                    public void failed(Service.State from, Throwable failure) {
                        LOG.error("Transaction manager aborted, stopping transaction service");
                        TransactionService.this.abort(failure);
                    }
                }, (Executor)MoreExecutors.sameThreadExecutor());
                TransactionService.this.server = ThriftRPCServer.builder(TTransactionServer.class).setHost(TransactionService.this.address).setPort(TransactionService.this.port).setWorkerThreads(TransactionService.this.threads).setMaxReadBufferBytes(TransactionService.this.maxReadBufferBytes).setIOThreads(TransactionService.this.ioThreads).build(new TransactionServiceThriftHandler(TransactionService.this.txManager));
                try {
                    TransactionService.this.server.startAndWait();
                    TransactionService.this.doRegister();
                    LOG.info("Transaction Thrift Service started successfully on " + TransactionService.this.getAddress());
                }
                catch (Throwable t) {
                    LOG.info("Transaction Thrift Service didn't start on " + TransactionService.this.server.getBindAddress());
                    TransactionService.this.leaderElection.stop();
                    TransactionService.this.notifyFailed(t);
                }
            }

            public void follower() {
                TransactionService.this.undoRegiser();
                if (TransactionService.this.server != null && TransactionService.this.server.isRunning()) {
                    TransactionService.this.server.stopAndWait();
                }
            }
        });
        this.leaderElection.start();
        this.notifyStarted();
    }

    @Override
    protected void doStop() {
        this.internalStop();
        this.notifyStopped();
    }

    protected void abort(Throwable cause) {
        this.internalStop();
        this.notifyFailed(cause);
    }

    protected void internalStop() {
        if (this.leaderElection != null) {
            try {
                Uninterruptibles.getUninterruptibly((Future)this.leaderElection.stop(), (long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                LOG.warn("Timed out waiting for leader election cancellation to complete");
            }
            catch (ExecutionException e) {
                LOG.error("Exception when cancelling leader election.", (Throwable)e);
            }
        }
    }
}

