/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.AbstractTransactionLog;
import co.cask.tephra.persist.CommitMarkerCodec;
import co.cask.tephra.persist.HDFSTransactionLogReaderSupplier;
import co.cask.tephra.persist.HDFSUtil;
import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLogReader;
import co.cask.tephra.persist.TransactionLogWriter;
import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSTransactionLog
extends AbstractTransactionLog {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSTransactionLog.class);
    private final FileSystem fs;
    private final Configuration hConf;
    private final Path logPath;

    public HDFSTransactionLog(FileSystem fs, Configuration hConf, Path logPath, long timestamp) {
        super(timestamp);
        this.fs = fs;
        this.hConf = hConf;
        this.logPath = logPath;
    }

    @Override
    protected TransactionLogWriter createWriter() throws IOException {
        return new LogWriter(this.fs, this.hConf, this.logPath);
    }

    @Override
    public String getName() {
        return this.logPath.getName();
    }

    @Override
    public TransactionLogReader getReader() throws IOException {
        FileStatus status2 = this.fs.getFileStatus(this.logPath);
        long length = status2.getLen();
        TransactionLogReader reader = null;
        if (length <= 0L) {
            LOG.warn("File " + this.logPath + " might be still open, length is 0");
        }
        HDFSUtil hdfsUtil = new HDFSUtil();
        hdfsUtil.recoverFileLease(this.fs, this.logPath, this.hConf);
        try {
            FileStatus newStatus = this.fs.getFileStatus(this.logPath);
            LOG.info("New file size for " + this.logPath + " is " + newStatus.getLen());
            SequenceFile.Reader fileReader = new SequenceFile.Reader(this.fs, this.logPath, this.hConf);
            reader = new HDFSTransactionLogReaderSupplier(fileReader).get();
        }
        catch (EOFException e) {
            if (length <= 0L) {
                LOG.warn("Could not open " + this.logPath + " for reading. File is empty", (Throwable)e);
                return null;
            }
            return null;
        }
        return reader;
    }

    @VisibleForTesting
    static final class LogWriter
    implements TransactionLogWriter {
        private final SequenceFile.Writer internalWriter;

        public LogWriter(FileSystem fs, Configuration hConf, Path logPath) throws IOException {
            SequenceFile.Metadata metadata = new SequenceFile.Metadata();
            metadata.set(new Text("version"), new Text(Byte.toString((byte)2)));
            this.internalWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)hConf, (Path)logPath, LongWritable.class, TransactionEdit.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null, null, (SequenceFile.Metadata)metadata);
            LOG.debug("Created a new TransactionLog writer for " + logPath);
        }

        @Override
        public void append(AbstractTransactionLog.Entry entry) throws IOException {
            this.internalWriter.append((Writable)entry.getKey(), (Writable)entry.getEdit());
        }

        @Override
        public void commitMarker(int count) throws IOException {
            CommitMarkerCodec.writeMarker(this.internalWriter, count);
        }

        @Override
        public void sync() throws IOException {
            this.internalWriter.syncFs();
        }

        @Override
        public void close() throws IOException {
            this.internalWriter.close();
        }
    }
}

