/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLog;
import co.cask.tephra.persist.TransactionLogReader;
import co.cask.tephra.persist.TransactionLogWriter;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionLog
implements TransactionLog {
    private static final long SLOW_APPEND_THRESHOLD = 1000L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTransactionLog.class);
    private final AtomicLong logSequence = new AtomicLong();
    protected long timestamp;
    private volatile boolean initialized;
    private volatile boolean closed;
    private AtomicLong syncedUpTo = new AtomicLong();
    private List<Entry> pendingWrites = Lists.newLinkedList();
    private TransactionLogWriter writer;

    public AbstractTransactionLog(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized void init() throws IOException {
        if (this.initialized) {
            return;
        }
        this.writer = this.createWriter();
        this.initialized = true;
    }

    protected abstract TransactionLogWriter createWriter() throws IOException;

    @Override
    public abstract String getName();

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(TransactionEdit edit) throws IOException {
        long startTime = System.nanoTime();
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            this.ensureAvailable();
            Entry entry = new Entry(new LongWritable(this.logSequence.getAndIncrement()), edit);
            this.append(entry);
        }
        this.sync();
        long durationMillis = (System.nanoTime() - startTime) / 1000000L;
        if (durationMillis > 1000L) {
            LOG.info("Slow append to log " + this.getName() + ", took " + durationMillis + " msec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(List<TransactionEdit> edits) throws IOException {
        long startTime = System.nanoTime();
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            this.ensureAvailable();
            for (TransactionEdit edit : edits) {
                Entry entry = new Entry(new LongWritable(this.logSequence.getAndIncrement()), edit);
                this.append(entry);
            }
        }
        this.sync();
        long durationMillis = (System.nanoTime() - startTime) / 1000000L;
        if (durationMillis > 1000L) {
            LOG.info("Slow append to log " + this.getName() + ", took " + durationMillis + " msec.");
        }
    }

    private void ensureAvailable() throws IOException {
        if (this.closed) {
            throw new IOException("Log " + this.getName() + " is already closed, cannot append!");
        }
        if (!this.initialized) {
            this.init();
        }
    }

    private void append(Entry e) throws IOException {
        this.pendingWrites.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> getPendingWrites() {
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            List<Entry> save = this.pendingWrites;
            this.pendingWrites = new LinkedList<Entry>();
            return save;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() throws IOException {
        TransactionLogWriter tmpWriter = null;
        long latestSeq = 0L;
        AbstractTransactionLog abstractTransactionLog = this;
        synchronized (abstractTransactionLog) {
            if (this.closed) {
                return;
            }
            tmpWriter = this.writer;
            List<Entry> currentPending = this.getPendingWrites();
            if (!currentPending.isEmpty()) {
                tmpWriter.commitMarker(currentPending.size());
            }
            for (Entry e : currentPending) {
                tmpWriter.append(e);
                latestSeq = Math.max(latestSeq, e.getKey().get());
            }
        }
        long lastSynced = this.syncedUpTo.get();
        if (lastSynced < latestSeq) {
            tmpWriter.sync();
            this.syncedUpTo.compareAndSet(lastSynced, latestSeq);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.pendingWrites.isEmpty()) {
            this.sync();
        }
        if (this.writer != null) {
            this.writer.close();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public abstract TransactionLogReader getReader() throws IOException;

    public static class Entry
    implements Writable {
        private LongWritable key;
        private TransactionEdit edit;

        public Entry() {
            this.key = new LongWritable();
            this.edit = new TransactionEdit();
        }

        public Entry(LongWritable key, TransactionEdit edit) {
            this.key = key;
            this.edit = edit;
        }

        public LongWritable getKey() {
            return this.key;
        }

        public TransactionEdit getEdit() {
            return this.edit;
        }

        public void write(DataOutput out) throws IOException {
            this.key.write(out);
            this.edit.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.key.readFields(in);
            this.edit.readFields(in);
        }
    }
}

