/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.InvalidTruncateTimeException;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.distributed.TransactionConverterUtils;
import co.cask.tephra.distributed.thrift.TBoolean;
import co.cask.tephra.distributed.thrift.TInvalidTruncateTimeException;
import co.cask.tephra.distributed.thrift.TTransaction;
import co.cask.tephra.distributed.thrift.TTransactionCouldNotTakeSnapshotException;
import co.cask.tephra.distributed.thrift.TTransactionNotInProgressException;
import co.cask.tephra.distributed.thrift.TTransactionServer;
import co.cask.tephra.rpc.RPCServiceHandler;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.thrift.TException;

public class TransactionServiceThriftHandler
implements TTransactionServer.Iface,
RPCServiceHandler {
    private final TransactionManager txManager;

    public TransactionServiceThriftHandler(TransactionManager txManager) {
        this.txManager = txManager;
    }

    @Override
    public TTransaction startLong() throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startLong());
    }

    @Override
    public TTransaction startShort() throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startShort());
    }

    @Override
    public TTransaction startShortTimeout(int timeout) throws TException {
        return TransactionConverterUtils.wrap(this.txManager.startShort(timeout));
    }

    @Override
    public TBoolean canCommitTx(TTransaction tx, Set<ByteBuffer> changes) throws TException {
        HashSet changeIds = Sets.newHashSet();
        for (ByteBuffer bb : changes) {
            byte[] changeId = new byte[bb.remaining()];
            bb.get(changeId);
            changeIds.add(changeId);
        }
        try {
            return new TBoolean(this.txManager.canCommit(TransactionConverterUtils.unwrap(tx), changeIds));
        }
        catch (TransactionNotInProgressException e) {
            throw new TTransactionNotInProgressException(e.getMessage());
        }
    }

    @Override
    public TBoolean commitTx(TTransaction tx) throws TException {
        try {
            return new TBoolean(this.txManager.commit(TransactionConverterUtils.unwrap(tx)));
        }
        catch (TransactionNotInProgressException e) {
            throw new TTransactionNotInProgressException(e.getMessage());
        }
    }

    @Override
    public void abortTx(TTransaction tx) throws TException {
        this.txManager.abort(TransactionConverterUtils.unwrap(tx));
    }

    @Override
    public boolean invalidateTx(long tx) throws TException {
        return this.txManager.invalidate(tx);
    }

    @Override
    public void init() throws Exception {
        this.txManager.startAndWait();
    }

    @Override
    public void destroy() throws Exception {
        this.txManager.stopAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getSnapshot() throws TException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                boolean snapshotTaken = this.txManager.takeSnapshot(out);
                if (!snapshotTaken) {
                    throw new TTransactionCouldNotTakeSnapshotException("Transaction manager could not get a snapshot.");
                }
            }
            finally {
                out.close();
            }
            return ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException e) {
            throw new TTransactionCouldNotTakeSnapshotException(e.getMessage());
        }
    }

    @Override
    public void resetState() throws TException {
        this.txManager.resetState();
    }

    @Override
    public String status() throws TException {
        return this.txManager.isRunning() ? "OK" : "NOTOK";
    }

    @Override
    public TBoolean truncateInvalidTx(Set<Long> txns) throws TException {
        return new TBoolean(this.txManager.truncateInvalidTx(txns));
    }

    @Override
    public TBoolean truncateInvalidTxBefore(long time) throws TException {
        try {
            return new TBoolean(this.txManager.truncateInvalidTxBefore(time));
        }
        catch (InvalidTruncateTimeException e) {
            throw new TInvalidTruncateTimeException(e.getMessage());
        }
    }

    @Override
    public int invalidTxSize() throws TException {
        return this.txManager.getInvalidSize();
    }
}

