/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionType;
import co.cask.tephra.distributed.thrift.TTransaction;
import co.cask.tephra.distributed.thrift.TTransactionType;
import com.google.common.primitives.Longs;

public final class TransactionConverterUtils {
    public static TTransaction wrap(Transaction tx) {
        return new TTransaction(tx.getWritePointer(), tx.getReadPointer(), Longs.asList((long[])tx.getInvalids()), Longs.asList((long[])tx.getInProgress()), tx.getFirstShortInProgress(), TransactionConverterUtils.getTTransactionType(tx.getType()));
    }

    public static Transaction unwrap(TTransaction thriftTx) {
        return new Transaction(thriftTx.getReadPointer(), thriftTx.getWritePointer(), Longs.toArray(thriftTx.getInvalids()), Longs.toArray(thriftTx.getInProgress()), thriftTx.getFirstShort(), TransactionConverterUtils.getTransactionType(thriftTx.getType()));
    }

    private static TransactionType getTransactionType(TTransactionType tType) {
        return tType == TTransactionType.SHORT ? TransactionType.SHORT : TransactionType.LONG;
    }

    private static TTransactionType getTTransactionType(TransactionType type) {
        return type == TransactionType.SHORT ? TTransactionType.SHORT : TTransactionType.LONG;
    }
}

