/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodecV2;
import java.util.concurrent.TimeUnit;

public class TxConstants {
    public static final String PROPERTY_TTL = "dataset.table.ttl";
    public static final long MAX_TX_PER_MS = 1000000L;
    public static final String ALLOW_EMPTY_VALUES_KEY = "data.tx.allow.empty.values";
    public static final boolean ALLOW_EMPTY_VALUES_DEFAULT = false;
    public static final String TX_OPERATION_ATTRIBUTE_KEY = "cask.tx";
    public static final String STATUS_OK = "OK";
    public static final String STATUS_NOTOK = "NOTOK";

    public static final class Persist {
        public static final String CFG_TX_SNAPHOT_CODEC_CLASSES = "data.tx.snapshot.codecs";
        public static final Class[] DEFAULT_TX_SNAPHOT_CODEC_CLASSES = new Class[]{DefaultSnapshotCodec.class, SnapshotCodecV2.class};
    }

    public static final class DataJanitor {
        public static final String CFG_TX_JANITOR_ENABLE = "data.tx.janitor.enable";
        public static final boolean DEFAULT_TX_JANITOR_ENABLE = true;
    }

    public static final class HBase {
        public static final String ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
        public static final String ZK_SESSION_TIMEOUT = "zookeeper.session.timeout";
        public static final int DEFAULT_ZK_SESSION_TIMEOUT = 180000;
    }

    public static final class Service {
        public static final String CFG_DATA_TX_ZOOKEEPER_QUORUM = "data.tx.zookeeper.quorum";
        public static final String CFG_DATA_TX_DISCOVERY_SERVICE_NAME = "data.tx.discovery.service.name";
        public static final String CFG_DATA_TX_BIND_PORT = "data.tx.bind.port";
        public static final String CFG_DATA_TX_BIND_ADDRESS = "data.tx.bind.address";
        public static final String CFG_DATA_TX_SERVER_IO_THREADS = "data.tx.server.io.threads";
        public static final String CFG_DATA_TX_SERVER_THREADS = "data.tx.server.threads";
        public static final String CFG_DATA_TX_THRIFT_MAX_READ_BUFFER = "data.tx.thrift.max.read.buffer";
        public static final String DEFAULT_DATA_TX_DISCOVERY_SERVICE_NAME = "transaction";
        public static final int DEFAULT_DATA_TX_BIND_PORT = 15165;
        public static final String DEFAULT_DATA_TX_BIND_ADDRESS = "0.0.0.0";
        public static final int DEFAULT_DATA_TX_SERVER_IO_THREADS = 2;
        public static final int DEFAULT_DATA_TX_SERVER_THREADS = 20;
        public static final int DEFAULT_DATA_TX_THRIFT_MAX_READ_BUFFER = 0x1000000;
        public static final String CFG_DATA_TX_CLIENT_TIMEOUT = "data.tx.client.timeout";
        public static final String CFG_DATA_TX_CLIENT_PROVIDER = "data.tx.client.provider";
        public static final String CFG_DATA_TX_CLIENT_COUNT = "data.tx.client.count";
        public static final String CFG_DATA_TX_CLIENT_RETRY_STRATEGY = "data.tx.client.retry.strategy";
        public static final String CFG_DATA_TX_CLIENT_ATTEMPTS = "data.tx.client.retry.attempts";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_INIITIAL = "data.tx.client.retry.backoff.initial";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_FACTOR = "data.tx.client.retry.backoff.factor";
        public static final String CFG_DATA_TX_CLIENT_BACKOFF_LIMIT = "data.tx.client.retry.backoff.limit";
        public static final int DEFAULT_DATA_TX_CLIENT_TIMEOUT = 30000;
        public static final int DEFAULT_DATA_TX_CLIENT_COUNT = 5;
        public static final String DEFAULT_DATA_TX_CLIENT_PROVIDER = "pool";
        public static final String DEFAULT_DATA_TX_CLIENT_RETRY_STRATEGY = "backoff";
        public static final int DEFAULT_DATA_TX_CLIENT_ATTEMPTS = 2;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_INIITIAL = 100;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_FACTOR = 4;
        public static final int DEFAULT_DATA_TX_CLIENT_BACKOFF_LIMIT = 30000;
    }

    public static final class Manager {
        public static final String CFG_DO_PERSIST = "tx.persist";
        public static final String CFG_TX_SNAPSHOT_DIR = "data.tx.snapshot.dir";
        public static final String CFG_TX_SNAPSHOT_LOCAL_DIR = "data.tx.snapshot.local.dir";
        public static final String CFG_TX_CLEANUP_INTERVAL = "data.tx.cleanup.interval";
        public static final String CFG_TX_HDFS_USER = "data.tx.hdfs.user";
        public static final int DEFAULT_TX_CLEANUP_INTERVAL = 10;
        public static final String CFG_TX_TIMEOUT = "data.tx.timeout";
        public static final int DEFAULT_TX_TIMEOUT = 30;
        public static final String CFG_TX_LONG_TIMEOUT = "data.tx.long.timeout";
        public static final int DEFAULT_TX_LONG_TIMEOUT = (int)TimeUnit.DAYS.toSeconds(1L);
        public static final String CFG_TX_SNAPSHOT_INTERVAL = "data.tx.snapshot.interval";
        public static final long DEFAULT_TX_SNAPSHOT_INTERVAL = 300L;
        public static final String CFG_TX_SNAPSHOT_RETAIN = "data.tx.snapshot.retain";
        public static final int DEFAULT_TX_SNAPSHOT_RETAIN = 10;
    }
}

