/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.Transaction;
import co.cask.tephra.distributed.thrift.TTransaction;
import com.google.common.collect.Lists;
import java.util.ArrayList;

final class ConverterUtils {
    ConverterUtils() {
    }

    public static TTransaction wrap(Transaction tx) {
        ArrayList invalids = Lists.newArrayListWithCapacity((int)tx.getInvalids().length);
        for (long txid : tx.getInvalids()) {
            invalids.add(txid);
        }
        ArrayList inProgress = Lists.newArrayListWithCapacity((int)tx.getInProgress().length);
        for (long txid : tx.getInProgress()) {
            inProgress.add(txid);
        }
        return new TTransaction(tx.getWritePointer(), tx.getReadPointer(), invalids, inProgress, tx.getFirstShortInProgress());
    }

    public static Transaction unwrap(TTransaction tx) {
        long[] invalids = new long[tx.invalids.size()];
        int i = 0;
        for (Long txid : tx.invalids) {
            invalids[i++] = txid;
        }
        long[] inProgress = new long[tx.inProgress.size()];
        i = 0;
        for (Long txid : tx.inProgress) {
            inProgress[i++] = txid;
        }
        return new Transaction(tx.readPointer, tx.writePointer, invalids, inProgress, tx.getFirstShort());
    }
}

