/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.snapshot;

import co.cask.tephra.TxConstants;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.snapshot.BinaryDecoder;
import co.cask.tephra.snapshot.BinaryEncoder;
import co.cask.tephra.snapshot.SnapshotCodec;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCodecProvider
implements SnapshotCodec {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotCodecProvider.class);
    private final SortedMap<Integer, SnapshotCodec> codecs = Maps.newTreeMap();

    @Inject
    public SnapshotCodecProvider(Configuration configuration) {
        this.initialize(configuration);
    }

    private void initialize(Configuration configuration) {
        Class[] codecClasses = configuration.getClasses("data.tx.snapshot.codecs", new Class[0]);
        if (codecClasses == null || codecClasses.length == 0) {
            codecClasses = TxConstants.Persist.DEFAULT_TX_SNAPHOT_CODEC_CLASSES;
        }
        for (Class codecClass : codecClasses) {
            try {
                SnapshotCodec codec = (SnapshotCodec)codecClass.newInstance();
                this.codecs.put(codec.getVersion(), codec);
                LOG.debug("Using snapshot codec {} for snapshots of version {}", (Object)codecClass.getName(), (Object)codec.getVersion());
            }
            catch (Exception e) {
                LOG.warn("Error instantiating snapshot codec {}. Skipping.", (Object)codecClass.getName(), (Object)e);
            }
        }
    }

    @Nonnull
    private SnapshotCodec getCodecForVersion(int version) {
        SnapshotCodec codec = (SnapshotCodec)this.codecs.get(version);
        if (codec == null) {
            throw new IllegalArgumentException(String.format("Version %d of snapshot encoding is not supported", version));
        }
        return codec;
    }

    private SnapshotCodec getCurrentCodec() {
        if (this.codecs.isEmpty()) {
            throw new IllegalStateException(String.format("No codecs are registered.", new Object[0]));
        }
        return (SnapshotCodec)this.codecs.get(this.codecs.lastKey());
    }

    @Override
    public int getVersion() {
        return this.getCurrentCodec().getVersion();
    }

    @Override
    public TransactionSnapshot decode(InputStream in) {
        int persistedVersion;
        BinaryDecoder decoder = new BinaryDecoder(in);
        try {
            persistedVersion = decoder.readInt();
        }
        catch (IOException e) {
            LOG.error("Unable to read transaction state version: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        SnapshotCodec codec = this.getCodecForVersion(persistedVersion);
        return codec.decode(in);
    }

    @Override
    public void encode(OutputStream out, TransactionSnapshot snapshot) {
        SnapshotCodec codec = this.getCurrentCodec();
        try {
            new BinaryEncoder(out).writeInt(codec.getVersion());
        }
        catch (IOException e) {
            LOG.error("Unable to write transaction state version: ", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        codec.encode(out, snapshot);
    }
}

