/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.distributed.thrift.TTransaction;
import com.google.common.primitives.Longs;
import java.io.IOException;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class TransactionCodec {
    public static final String TX_OPERATION_ATTRIBUTE_KEY = "cask.tx";

    public byte[] encode(Transaction tx) throws IOException {
        TTransaction thriftTx = new TTransaction(tx.getWritePointer(), tx.getReadPointer(), Longs.asList((long[])tx.getInvalids()), Longs.asList((long[])tx.getInProgress()), tx.getFirstShortInProgress());
        TSerializer serializer = new TSerializer();
        try {
            return serializer.serialize((TBase)thriftTx);
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    public Transaction decode(byte[] encoded) throws IOException {
        TTransaction thriftTx = new TTransaction();
        TDeserializer deserializer = new TDeserializer();
        try {
            deserializer.deserialize((TBase)thriftTx, encoded);
            return new Transaction(thriftTx.getReadPointer(), thriftTx.getWritePointer(), Longs.toArray(thriftTx.getInvalids()), Longs.toArray(thriftTx.getInProgress()), thriftTx.getFirstShort());
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    public void addToOperation(OperationWithAttributes op, Transaction tx) throws IOException {
        op.setAttribute(TX_OPERATION_ATTRIBUTE_KEY, this.encode(tx));
    }

    public Transaction getFromOperation(OperationWithAttributes op) throws IOException {
        byte[] encoded = op.getAttribute(TX_OPERATION_ATTRIBUTE_KEY);
        if (encoded != null) {
            return this.decode(encoded);
        }
        return null;
    }
}

