/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import java.util.Arrays;

public class Transaction {
    private final long readPointer;
    private final long writePointer;
    private final long[] invalids;
    private final long[] inProgress;
    private final long firstShortInProgress;
    private static final long[] NO_EXCLUDES = new long[0];
    public static final long NO_TX_IN_PROGRESS = Long.MAX_VALUE;
    public static final Transaction ALL_VISIBLE_LATEST = new Transaction(Long.MAX_VALUE, Long.MAX_VALUE, NO_EXCLUDES, NO_EXCLUDES, Long.MAX_VALUE);

    public Transaction(long readPointer, long writePointer, long[] invalids, long[] inProgress, long firstShortInProgress) {
        this.readPointer = readPointer;
        this.writePointer = writePointer;
        this.invalids = invalids;
        this.inProgress = inProgress;
        this.firstShortInProgress = firstShortInProgress;
    }

    public long getReadPointer() {
        return this.readPointer;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    public long[] getInvalids() {
        return this.invalids;
    }

    public long[] getInProgress() {
        return this.inProgress;
    }

    public long getFirstInProgress() {
        return this.inProgress.length == 0 ? Long.MAX_VALUE : this.inProgress[0];
    }

    public long getVisibilityUpperBound() {
        return this.inProgress.length == 0 ? Math.min(this.writePointer - 1L, this.readPointer) : this.inProgress[0] - 1L;
    }

    public long getFirstShortInProgress() {
        return this.firstShortInProgress;
    }

    public boolean isInProgress(long version) {
        return Arrays.binarySearch(this.inProgress, version) >= 0;
    }

    public boolean isExcluded(long version) {
        return Arrays.binarySearch(this.inProgress, version) >= 0 || Arrays.binarySearch(this.invalids, version) >= 0;
    }

    public boolean isVisible(long version) {
        return version <= this.getReadPointer() && !this.isExcluded(version) || this.writePointer == version;
    }

    public boolean hasExcludes() {
        return this.invalids.length > 0 || this.inProgress.length > 0;
    }

    public int excludesSize() {
        return this.invalids.length + this.inProgress.length;
    }

    public String toString() {
        return new StringBuilder(100).append(Transaction.class.getSimpleName()).append('{').append("readPointer: ").append(this.readPointer).append(", writePointer: ").append(this.writePointer).append(", invalids: ").append(Arrays.toString(this.invalids)).append(", inProgress: ").append(Arrays.toString(this.inProgress)).append('}').toString();
    }
}

