/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.ApplicationDefaultPreferences;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.PreloadCallback;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebViewFactory;
import java.util.HashSet;
import java.util.Set;

class ViewManager {
    private static final String LOGTAG = ViewManager.class.getSimpleName();
    private static final String CONTENT_DESCRIPTION_ORIGINAL_WEBVIEW = "originalWebView";
    private static final String CONTENT_DESCRIPTION_NEW_WEBVIEW = "newWebView";
    private static final String CONTENT_DESCRIPTION_PRELOADED_WEBVIEW = "preloadedWebView";
    private final ViewGroup parent;
    private final WebViewFactory webViewFactory;
    private final AndroidTargetUtils.AndroidClassAdapter androidClassAdapter;
    private WebViewClient webViewClient;
    private WebView currentWebView;
    private WebView stashedWebView;
    private WebView preloadedWebView;
    private int webViewHeight = -1;
    private int webViewWidth = -1;
    private int gravity = 17;
    private View.OnKeyListener keyListener;
    private boolean disableHardwareAcceleration = false;
    private final Set<String> javascriptInterfaceNames = new HashSet<String>();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    public ViewManager(ViewGroup parent) {
        this(parent, WebViewFactory.getInstance(), AndroidTargetUtils.getDefaultAndroidClassAdapter());
    }

    ViewManager(ViewGroup parent, WebViewFactory webViewFactory, AndroidTargetUtils.AndroidClassAdapter androidClassAdapter) {
        this.parent = parent;
        this.webViewFactory = webViewFactory;
        this.androidClassAdapter = androidClassAdapter;
        Context context = parent.getContext();
        if (ApplicationDefaultPreferences.getDefaultPreferences() == null) {
            ApplicationDefaultPreferences.initialize(context);
        }
    }

    public boolean canShowViews() {
        Context context = this.getContext((View)this.parent);
        return this.webViewFactory.isWebViewOk(context);
    }

    public void initialize() throws IllegalStateException {
        this.getCurrentWebView();
    }

    private boolean isInitialized() {
        return this.currentWebView != null;
    }

    private WebView getCurrentWebView() {
        if (this.currentWebView == null) {
            WebView webView = this.createWebView(this.getContext((View)this.parent));
            if (!this.validateWebView(webView)) {
                throw new IllegalStateException("Could not create WebView");
            }
            webView.setContentDescription((CharSequence)CONTENT_DESCRIPTION_ORIGINAL_WEBVIEW);
            this.setWebView(webView, false);
        }
        return this.currentWebView;
    }

    void addViewToParent(WebView webView) {
        this.parent.addView((View)webView);
    }

    public void disableHardwareAcceleration(boolean shouldDisable) {
        this.disableHardwareAcceleration = shouldDisable;
    }

    boolean validateWebView(WebView webView) {
        return webView != null;
    }

    Context getContext(View view) {
        return view.getContext();
    }

    public void listenForKey(View.OnKeyListener keyListener) {
        this.keyListener = keyListener;
        this.getCurrentWebView().requestFocus();
        this.getCurrentWebView().setOnKeyListener(this.keyListener);
    }

    protected void setWebViewLayoutParams(WebView webView, int width, int height, int gravity) {
        if (webView.getLayoutParams() == null) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(width, height);
            layoutParams.gravity = gravity;
            webView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        } else {
            webView.getLayoutParams().width = width;
            webView.getLayoutParams().height = height;
            if (webView.getLayoutParams() instanceof FrameLayout.LayoutParams) {
                ((FrameLayout.LayoutParams)webView.getLayoutParams()).gravity = gravity;
            }
        }
    }

    public void destroy() {
        this.destroyWebViews(this.currentWebView, this.stashedWebView, this.preloadedWebView);
        this.currentWebView = null;
        this.stashedWebView = null;
        this.preloadedWebView = null;
    }

    public void setWebViewClient(WebViewClient client) {
        this.webViewClient = client;
        if (this.isInitialized()) {
            this.getCurrentWebView().setWebViewClient(this.webViewClient);
        }
    }

    public void setHeight(int height) {
        this.webViewHeight = height;
        this.updateLayoutParamsIfNeeded();
    }

    public void setLayoutParams(int width, int height, int gravity) {
        this.webViewWidth = width;
        this.webViewHeight = height;
        this.gravity = gravity;
        this.updateLayoutParamsIfNeeded();
    }

    private void updateLayoutParamsIfNeeded() {
        if (this.isInitialized()) {
            this.setWebViewLayoutParams(this.getCurrentWebView(), this.webViewWidth, this.webViewHeight, this.gravity);
        }
    }

    public WebView getCurrentAdView() {
        return this.currentWebView;
    }

    public int getWidth() {
        if (this.isInitialized()) {
            return this.getCurrentWebView().getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.isInitialized()) {
            return this.getCurrentWebView().getHeight();
        }
        return 0;
    }

    public void getLocationOnScreen(int[] location) {
        if (this.isInitialized()) {
            this.getCurrentWebView().getLocationOnScreen(location);
        }
    }

    WebView createWebView(Context context) {
        WebView webView = this.webViewFactory.createWebView(context);
        if (!this.webViewFactory.setJavaScriptEnabledForWebView(true, webView, LOGTAG)) {
            return null;
        }
        WebSettings webSettings = webView.getSettings();
        this.androidClassAdapter.withWebSettings(webSettings).setMediaPlaybackRequiresUserGesture(false);
        webView.setScrollContainer(false);
        webView.setBackgroundColor(0);
        webView.setVerticalScrollBarEnabled(false);
        webView.setHorizontalScrollBarEnabled(false);
        webView.setWebChromeClient((WebChromeClient)new AdWebChromeClient());
        webSettings.setDomStorageEnabled(true);
        if (this.disableHardwareAcceleration) {
            AndroidTargetUtils.disableHardwareAcceleration((View)webView);
        }
        return webView;
    }

    void setWebView(WebView webView, boolean shouldDestroyPrevious) {
        WebView oldView = this.currentWebView;
        if (oldView != null) {
            oldView.setOnKeyListener(null);
            oldView.setWebViewClient(new WebViewClient());
            this.parent.removeView((View)oldView);
            if (shouldDestroyPrevious) {
                this.destroyWebViews(oldView);
            }
        }
        webView.setWebViewClient(this.webViewClient);
        this.currentWebView = webView;
        this.updateLayoutParamsIfNeeded();
        this.addViewToParent(this.currentWebView);
        if (this.keyListener != null) {
            this.listenForKey(this.keyListener);
        }
    }

    public void stashView() {
        if (this.stashedWebView != null) {
            this.destroyWebViews(this.stashedWebView);
        }
        this.stashedWebView = this.currentWebView;
        WebView webView = null;
        if (this.preloadedWebView == null) {
            webView = this.createWebView(this.parent.getContext());
            webView.setContentDescription((CharSequence)CONTENT_DESCRIPTION_NEW_WEBVIEW);
        } else {
            webView = this.preloadedWebView;
            this.preloadedWebView = this.createWebView(this.parent.getContext());
        }
        this.setWebView(webView, false);
    }

    public boolean popView() {
        if (this.stashedWebView != null) {
            WebView webView = this.stashedWebView;
            this.stashedWebView = null;
            this.setWebView(webView, true);
            return true;
        }
        return false;
    }

    public void loadUrl(String url) {
        this.loadUrl(url, false, null);
    }

    public void loadUrl(String url, boolean shouldPreload, PreloadCallback callback) {
        if (shouldPreload) {
            if (callback != null) {
                this.getPreloadedWebView().setWebViewClient((WebViewClient)new PreloadWebViewClient(callback));
            }
            this.getPreloadedWebView().loadUrl(url);
        } else {
            this.logger.d("Loading URL: " + url);
            this.getCurrentWebView().loadUrl(url);
        }
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        this.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl, false, null);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl, boolean shouldPreload, PreloadCallback callback) {
        if (shouldPreload) {
            if (callback != null) {
                this.getPreloadedWebView().setWebViewClient((WebViewClient)new PreloadWebViewClient(callback));
            }
            this.getPreloadedWebView().loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
        } else {
            this.getCurrentWebView().loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
        }
    }

    public boolean isCurrentView(View view) {
        return view.equals(this.currentWebView);
    }

    private WebView getPreloadedWebView() {
        if (this.preloadedWebView == null) {
            this.preloadedWebView = this.createWebView(this.parent.getContext());
            this.preloadedWebView.setContentDescription((CharSequence)CONTENT_DESCRIPTION_PRELOADED_WEBVIEW);
        }
        return this.preloadedWebView;
    }

    public void removePreviousInterfaces() {
        if (this.currentWebView != null) {
            if (AndroidTargetUtils.isAtLeastAndroidAPI(11)) {
                for (String interfaceName : this.javascriptInterfaceNames) {
                    AndroidTargetUtils.removeJavascriptInterface(this.currentWebView, interfaceName);
                }
            } else {
                this.setWebView(this.createWebView(this.parent.getContext()), true);
                this.currentWebView.setContentDescription((CharSequence)CONTENT_DESCRIPTION_ORIGINAL_WEBVIEW);
            }
        }
        this.javascriptInterfaceNames.clear();
    }

    public void addJavascriptInterface(Object javascriptInterface, boolean preload, String interfaceName) {
        this.logger.d("Add JavaScript Interface %s", interfaceName);
        this.javascriptInterfaceNames.add(interfaceName);
        if (preload) {
            this.getPreloadedWebView().addJavascriptInterface(javascriptInterface, interfaceName);
        } else {
            this.getCurrentWebView().addJavascriptInterface(javascriptInterface, interfaceName);
        }
    }

    private void destroyWebViews(final WebView ... webViews) {
        ThreadUtils.executeOnMainThread(new Runnable(){

            @Override
            public void run() {
                for (WebView webView : webViews) {
                    if (webView == null) continue;
                    if (webView.getParent() != null) {
                        ((ViewGroup)webView.getParent()).removeView((View)webView);
                    }
                    try {
                        webView.destroy();
                    }
                    catch (IllegalArgumentException e) {
                        ViewManager.this.logger.w("Caught an IllegalArgumentException while destroying a WebView: %s", e.getMessage());
                    }
                }
            }
        });
    }

    private class PreloadWebViewClient
    extends WebViewClient {
        private final PreloadCallback callback;

        public PreloadWebViewClient(PreloadCallback callback) {
            this.callback = callback;
        }

        public void onPageFinished(WebView webView, String url) {
            if (this.callback != null) {
                this.callback.onPreloadComplete(url);
            }
        }
    }

    private class AdWebChromeClient
    extends WebChromeClient {
        private AdWebChromeClient() {
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            ViewManager.this.logger.d("JS Console Message Line number %d : %s", consoleMessage.lineNumber(), consoleMessage.message());
            return false;
        }
    }
}

