/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdVideoPlayer;

class VideoActionHandler
implements AdActivity.AdActivityAdapter {
    private RelativeLayout layout;
    private AdVideoPlayer player;
    private Activity activity;

    VideoActionHandler() {
    }

    VideoActionHandler(AdVideoPlayer player, Activity activity) {
        this.player = player;
        this.activity = activity;
    }

    @Override
    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    @Override
    public void onCreate() {
        Bundle data = this.activity.getIntent().getExtras();
        this.layout = new RelativeLayout((Context)this.activity);
        this.layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.activity.setContentView((View)this.layout);
        this.initPlayer(data);
        this.player.playVideo();
    }

    private void setPlayerListener(AdVideoPlayer player) {
        player.setListener(new AdVideoPlayer.AdVideoPlayerListener(){

            @Override
            public void onError() {
                VideoActionHandler.this.activity.finish();
            }

            @Override
            public void onComplete() {
                VideoActionHandler.this.activity.finish();
            }
        });
    }

    private void initPlayer(Bundle data) {
        this.player = new AdVideoPlayer((Context)this.activity);
        this.player.setPlayData(data.getString("url"));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(13);
        this.player.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.player.setViewGroup((ViewGroup)this.layout);
        this.setPlayerListener(this.player);
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onStop() {
        if (this.player != null) {
            this.player.releasePlayer();
            this.player = null;
        }
        this.activity.finish();
    }

    @Override
    public void onDestroy() {
        if (this.player != null) {
            this.player.releasePlayer();
            this.player = null;
        }
        this.activity.finish();
    }

    @Override
    public void preOnCreate() {
        this.activity.requestWindowFeature(1);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    @Override
    public void onWindowFocusChanged() {
    }
}

