/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.MediaController;
import android.widget.VideoView;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;

class AdVideoPlayer
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener {
    private static String LOGTAG = AdVideoPlayer.class.getSimpleName();
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private AdVideoPlayerListener listener_;
    private String contentUrl_;
    private boolean released_ = false;
    private Context context_;
    private VideoView videoView_ = null;
    private ViewGroup.LayoutParams layoutParams_ = null;
    private ViewGroup viewGroup_ = null;

    public AdVideoPlayer(Context context) {
        this.context_ = context;
    }

    public void setPlayData(String url) {
        this.released_ = false;
        this.contentUrl_ = url;
    }

    public void setListener(AdVideoPlayerListener listener) {
        this.listener_ = listener;
    }

    public void playVideo() {
        this.logger.d("in playVideo");
        this.initializeVideoView();
        this.loadPlayerContent();
        this.startPlaying();
    }

    private void initializeVideoView() {
        VideoView videoView = new VideoView(this.context_);
        videoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        videoView.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        videoView.setLayoutParams(this.layoutParams_);
        this.videoView_ = videoView;
        this.viewGroup_.addView((View)this.videoView_);
    }

    private void loadPlayerContent() {
        Uri uri = Uri.parse((String)this.contentUrl_);
        this.videoView_.setVideoURI(uri);
    }

    public void startPlaying() {
        this.logger.d("in startPlaying");
        this.displayPlayerControls();
        this.videoView_.start();
    }

    private void displayPlayerControls() {
        this.logger.d("in displayPlayerControls");
        MediaController controller = new MediaController(this.context_);
        this.videoView_.setMediaController(controller);
        controller.setAnchorView((View)this.videoView_);
        controller.requestFocus();
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        this.removePlayerFromParent();
        if (this.listener_ != null) {
            this.listener_.onError();
        }
        return false;
    }

    public void onCompletion(MediaPlayer mp) {
        this.releasePlayer();
        if (this.listener_ != null) {
            this.listener_.onComplete();
        }
    }

    private void removePlayerFromParent() {
        this.logger.d("in removePlayerFromParent");
        this.viewGroup_.removeView((View)this.videoView_);
    }

    public void releasePlayer() {
        this.logger.d("in releasePlayer");
        if (this.released_) {
            return;
        }
        this.released_ = true;
        this.videoView_.stopPlayback();
        this.removePlayerFromParent();
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.layoutParams_ = layoutParams;
    }

    public void setViewGroup(ViewGroup viewGroup) {
        this.viewGroup_ = viewGroup;
    }

    public static interface AdVideoPlayerListener {
        public void onComplete();

        public void onError();
    }
}

