/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdRegistrationExecutor;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AdActivity
extends Activity {
    static final String ADAPTER_KEY = "adapter";
    private static final String LOGTAG = AdActivity.class.getSimpleName();
    private AdActivityAdapter adapter;
    private MobileAdsLogger logger;
    private AdRegistrationExecutor amazonAdRegistration;
    private ActivityAdapterFactory activityAdapterFactory;

    public AdActivity() {
        this(new MobileAdsLoggerFactory(), AdRegistration.getAmazonAdRegistrationExecutor(), new ActivityAdapterFactory(new MobileAdsLoggerFactory()));
    }

    AdActivity(MobileAdsLoggerFactory loggerFactory, AdRegistrationExecutor amazonAdRegistration, ActivityAdapterFactory activityAdapterFactory) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.amazonAdRegistration = amazonAdRegistration;
        this.activityAdapterFactory = activityAdapterFactory;
    }

    public void onCreate(Bundle savedInstanceState) {
        this.initializeSdk();
        this.adapter = this.activityAdapterFactory.createAdapter(this.getIntent());
        if (this.adapter == null) {
            super.onCreate(savedInstanceState);
            this.finish();
            return;
        }
        this.adapter.setActivity(this);
        this.adapter.preOnCreate();
        super.onCreate(savedInstanceState);
        this.adapter.onCreate();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.adapter.onWindowFocusChanged();
        }
    }

    private void initializeSdk() {
        if (this.logger == null) {
            this.setLoggerFactory(new MobileAdsLoggerFactory());
        }
        if (this.amazonAdRegistration == null) {
            this.setAmazonAdRegistrationExecutor(AdRegistration.getAmazonAdRegistrationExecutor());
        }
        if (this.activityAdapterFactory == null) {
            this.setActivityAdapterFactory(new ActivityAdapterFactory(new MobileAdsLoggerFactory()));
        }
        this.amazonAdRegistration.initializeAds(this.getApplicationContext());
    }

    void setLoggerFactory(MobileAdsLoggerFactory loggerFactory) {
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
    }

    void setAmazonAdRegistrationExecutor(AdRegistrationExecutor amazonAdRegistrationExecutor) {
        this.amazonAdRegistration = amazonAdRegistrationExecutor;
    }

    void setActivityAdapterFactory(ActivityAdapterFactory activityAdapterFactory) {
        this.activityAdapterFactory = activityAdapterFactory;
    }

    public void onPause() {
        super.onPause();
        this.adapter.onPause();
    }

    public void onResume() {
        super.onResume();
        this.adapter.onResume();
    }

    public void onStop() {
        this.adapter.onStop();
        super.onStop();
    }

    public void onDestroy() {
        this.adapter.onDestroy();
        super.onDestroy();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.adapter.onConfigurationChanged(newConfig);
    }

    public void onBackPressed() {
        if (!this.adapter.onBackPressed()) {
            super.onBackPressed();
        }
    }

    static class ActivityAdapterFactory {
        private final MobileAdsLogger logger;

        public ActivityAdapterFactory(MobileAdsLoggerFactory loggerFactory) {
            this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        }

        AdActivityAdapter createAdapter(Intent intent) {
            String adapterClassName = intent.getStringExtra(AdActivity.ADAPTER_KEY);
            if (adapterClassName == null) {
                this.logger.e("Unable to launch the AdActivity due to an internal error.");
                return null;
            }
            Class<?> adapterClass = null;
            try {
                adapterClass = Class.forName(adapterClassName);
            }
            catch (ClassNotFoundException e) {
                this.logger.e("Unable to get the adapter class.");
                return null;
            }
            Constructor<?> adapterConstructor = null;
            try {
                adapterConstructor = adapterClass.getDeclaredConstructor(new Class[0]);
            }
            catch (SecurityException e) {
                this.logger.e("Security exception when trying to get the default constructor.");
                return null;
            }
            catch (NoSuchMethodException e) {
                this.logger.e("No default constructor exists for the adapter.");
                return null;
            }
            AdActivityAdapter adapter = null;
            try {
                adapter = (AdActivityAdapter)adapterConstructor.newInstance(new Object[0]);
            }
            catch (IllegalArgumentException e) {
                this.logger.e("Illegal arguments given to the default constructor.");
                return null;
            }
            catch (InstantiationException e) {
                this.logger.e("Instantiation exception when instantiating the adapter.");
                return null;
            }
            catch (IllegalAccessException e) {
                this.logger.e("Illegal access exception when instantiating the adapter.");
                return null;
            }
            catch (InvocationTargetException e) {
                this.logger.e("Invocation target exception when instantiating the adapter.");
                return null;
            }
            return adapter;
        }
    }

    public static interface AdActivityAdapter {
        public void setActivity(Activity var1);

        public void preOnCreate();

        public void onCreate();

        public void onPause();

        public void onResume();

        public void onWindowFocusChanged();

        public void onStop();

        public void onDestroy();

        public void onConfigurationChanged(Configuration var1);

        public boolean onBackPressed();
    }
}

