/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.GooglePlayServices;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ThreadUtils;

class AdvertisingIdentifier {
    private static final String LOGTAG = AdvertisingIdentifier.class.getSimpleName();
    private static final String GPS_ADVERTISING_IDENTIFIER_SETTING = "gpsAdId";
    private static final String TRANSITION_SETTING = "adIdTransistion";
    private static final String TRANSITION_MIGRATE = "migrate";
    private static final String TRANSITION_RESET = "reset";
    private static final String TRANSITION_REVERT = "revert";
    private GooglePlayServices.AdvertisingInfo gpsAdvertisingInfo;
    private boolean shouldSetCurrentAdvertisingIdentifier = true;
    private final MobileAdsLogger logger;
    private final Settings settings;
    private final MobileAdsInfoStore infoStore;
    private final DebugProperties debugProperties;

    public AdvertisingIdentifier() {
        this(Settings.getInstance(), MobileAdsInfoStore.getInstance(), new MobileAdsLoggerFactory(), DebugProperties.getInstance());
    }

    AdvertisingIdentifier(Settings settings, MobileAdsInfoStore infoStore, MobileAdsLoggerFactory loggerFactory, DebugProperties debugProperties) {
        this.settings = settings;
        this.infoStore = infoStore;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.debugProperties = debugProperties;
    }

    String getAndClearTransition() {
        String transition = this.settings.getString(TRANSITION_SETTING, null);
        this.settings.remove(TRANSITION_SETTING);
        return transition;
    }

    AdvertisingIdentifier setShouldSetCurrentAdvertisingIdentifier(boolean shouldSetCurrentAdvertisingIdentifier) {
        this.shouldSetCurrentAdvertisingIdentifier = shouldSetCurrentAdvertisingIdentifier;
        return this;
    }

    Info getAdvertisingIdentifierInfo() {
        RegistrationInfo registrationInfo;
        if (ThreadUtils.isOnMainThread()) {
            this.logger.e("You must obtain the advertising indentifier information on a background thread.");
            return new Info(this.debugProperties).setCanDo(false);
        }
        this.fetchGooglePlayServicesAdvertisingIdentifierInfo();
        if (this.shouldSetCurrentAdvertisingIdentifier) {
            this.determineTransition();
        }
        Info info = new Info(this.debugProperties);
        if (this.getGPSAdvertisingInfo().hasAdvertisingIdentifier()) {
            info.setAdvertisingIdentifier(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
            info.setLimitAdTrackingEnabled(this.getGPSAdvertisingInfo().isLimitAdTrackingEnabled());
            if (this.shouldSetCurrentAdvertisingIdentifier) {
                this.setCurrentGPSAID(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
            }
        }
        if ((registrationInfo = this.infoStore.getRegistrationInfo()).isAdIdCurrent(info)) {
            info.setSISDeviceIdentifier(registrationInfo.getAdId());
        } else {
            registrationInfo.requestNewSISDeviceIdentifier();
        }
        return info;
    }

    private void determineTransition() {
        String transition = null;
        if (this.isTransitionMigrated()) {
            transition = TRANSITION_MIGRATE;
        } else if (this.isTransitionReset()) {
            transition = TRANSITION_RESET;
        } else if (this.isTransitionReverted()) {
            transition = TRANSITION_REVERT;
        }
        if (transition != null) {
            this.setTransition(transition);
        } else {
            this.logger.d("No transition detected.");
        }
    }

    private void setTransition(String transition) {
        this.logger.d("Transition: %s", transition);
        this.settings.putString(TRANSITION_SETTING, transition);
    }

    protected void fetchGooglePlayServicesAdvertisingIdentifierInfo() {
        GooglePlayServices gps = new GooglePlayServices();
        this.gpsAdvertisingInfo = gps.getAdvertisingIdentifierInfo();
    }

    protected GooglePlayServices.AdvertisingInfo getGPSAdvertisingInfo() {
        return this.gpsAdvertisingInfo;
    }

    private boolean isTransitionMigrated() {
        RegistrationInfo registrationInfo = this.infoStore.getRegistrationInfo();
        return registrationInfo.hasAdId() && RegistrationInfo.isAdIdOriginatedFromNonAdvertisingIdentifier() && !this.hasCurrentGPSAID() && this.getGPSAdvertisingInfo().hasAdvertisingIdentifier();
    }

    private boolean isTransitionReset() {
        return this.hasCurrentGPSAID() && this.getGPSAdvertisingInfo().hasAdvertisingIdentifier() && !this.getCurrentGPSAID().equals(this.getGPSAdvertisingInfo().getAdvertisingIdentifier());
    }

    private boolean isTransitionReverted() {
        return this.hasCurrentGPSAID() && !this.getGPSAdvertisingInfo().hasAdvertisingIdentifier();
    }

    private void setCurrentGPSAID(String gpsaid) {
        this.settings.putString(GPS_ADVERTISING_IDENTIFIER_SETTING, gpsaid);
    }

    private String getCurrentGPSAID() {
        return this.settings.getString(GPS_ADVERTISING_IDENTIFIER_SETTING, "");
    }

    private boolean hasCurrentGPSAID() {
        return !StringUtils.isNullOrEmpty(this.getCurrentGPSAID());
    }

    static class Info {
        private boolean canDo;
        private String advertisingIdentifier;
        private boolean limitAdTrackingEnabled;
        private String sisDeviceIdentifier;
        private final DebugProperties debugProperties;

        private Info(DebugProperties debugProperties) {
            this.debugProperties = debugProperties;
            this.canDo = true;
        }

        boolean canDo() {
            return this.canDo;
        }

        private Info setCanDo(boolean canDo) {
            this.canDo = canDo;
            return this;
        }

        String getAdvertisingIdentifier() {
            return this.debugProperties.getDebugPropertyAsString("debug.idfa", this.advertisingIdentifier);
        }

        private Info setAdvertisingIdentifier(String advertisingIdentifier) {
            this.advertisingIdentifier = advertisingIdentifier;
            return this;
        }

        boolean hasAdvertisingIdentifier() {
            return !StringUtils.isNullOrEmpty(this.getAdvertisingIdentifier());
        }

        boolean isLimitAdTrackingEnabled() {
            return this.debugProperties.getDebugPropertyAsBoolean("debug.optOut", this.limitAdTrackingEnabled);
        }

        private Info setLimitAdTrackingEnabled(boolean limitAdTrackingEnabled) {
            this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            return this;
        }

        String getSISDeviceIdentifier() {
            return this.debugProperties.getDebugPropertyAsString("debug.adid", this.sisDeviceIdentifier);
        }

        boolean hasSISDeviceIdentifier() {
            return this.getSISDeviceIdentifier() != null;
        }

        Info setSISDeviceIdentifier(String sisDeviceIdentifier) {
            this.sisDeviceIdentifier = sisDeviceIdentifier;
            return this;
        }
    }
}

