/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;

class ConnectionInfo {
    private static final String LOGTAG = ConnectionInfo.class.getSimpleName();
    private static final String WIFI_NAME = "Wifi";
    private ConnectivityManager connectivityManager;
    private String connectionType;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);

    public ConnectionInfo(MobileAdsInfoStore infoStore) {
        Context context = infoStore.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.initialize(connectivityManager);
    }

    ConnectionInfo(ConnectivityManager connectivityManager) {
        this.initialize(connectivityManager);
    }

    private void initialize(ConnectivityManager connectivityManager) {
        this.connectivityManager = connectivityManager;
        this.refresh();
    }

    public void refresh() {
        this.generateConnectionType();
    }

    private void generateConnectionType() {
        NetworkInfo networkInfo = null;
        try {
            if (this.connectivityManager != null) {
                networkInfo = this.connectivityManager.getActiveNetworkInfo();
            }
        }
        catch (SecurityException e) {
            this.logger.d("Unable to get active network information: %s", e);
        }
        this.connectionType = networkInfo != null ? (networkInfo.getType() == 1 ? WIFI_NAME : Integer.toString(networkInfo.getSubtype())) : Integer.toString(0);
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public boolean isWiFi() {
        return WIFI_NAME.equals(this.getConnectionType());
    }
}

