/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import org.json.JSONObject;

class AppInfo {
    private final String packageName;
    private final JSONObject packageInfoUrlJSON;
    private final PackageManager packageManager;

    public AppInfo(Context context) {
        this(context, Metrics.getInstance().getMetricsCollector(), new JSONObject());
    }

    AppInfo(Context context, MetricsCollector metricsCollector, JSONObject packageInfoUrlJSON) {
        this.packageInfoUrlJSON = packageInfoUrlJSON;
        this.packageName = context.getPackageName();
        JSONUtils.put(packageInfoUrlJSON, "pn", this.packageName);
        this.packageManager = context.getPackageManager();
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        try {
            CharSequence applicationLabel = this.packageManager.getApplicationLabel(applicationInfo);
            JSONUtils.put(packageInfoUrlJSON, "lbl", applicationLabel != null ? applicationLabel.toString() : null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            metricsCollector.incrementMetric(Metrics.MetricType.APP_INFO_LABEL_INDEX_OUT_OF_BOUNDS);
        }
        try {
            PackageInfo packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
            String versionName = packageInfo != null ? packageInfo.versionName : null;
            JSONUtils.put(packageInfoUrlJSON, "vn", versionName);
            String versionCode = packageInfo != null ? Integer.toString(packageInfo.versionCode) : null;
            JSONUtils.put(packageInfoUrlJSON, "v", versionCode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    protected AppInfo() {
        this.packageName = null;
        this.packageInfoUrlJSON = null;
        this.packageManager = null;
    }

    public JSONObject getPackageInfoJSON() {
        return this.packageInfoUrlJSON;
    }

    public String getPackageInfoJSONString() {
        if (this.packageInfoUrlJSON != null) {
            return this.packageInfoUrlJSON.toString();
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }
}

