/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import com.amazon.device.ads.AAXParameter;
import com.amazon.device.ads.AAXParameterGroup;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.ConnectionInfo;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AdRequest {
    private static final String LOGTAG = AdRequest.class.getSimpleName();
    private static final AAXParameter<?>[] PARAMETERS = new AAXParameter[]{AAXParameter.APP_KEY, AAXParameter.CHANNEL, AAXParameter.PUBLISHER_KEYWORDS, AAXParameter.PUBLISHER_ASINS, AAXParameter.USER_AGENT, AAXParameter.SDK_VERSION, AAXParameter.GEOLOCATION, AAXParameter.DEVICE_INFO, AAXParameter.PACKAGE_INFO, AAXParameter.TEST, AAXParameter.OPT_OUT};
    private static final AAXParameterGroup[] PARAMETER_GROUPS = new AAXParameterGroup[]{AAXParameterGroup.USER_ID, AAXParameterGroup.PUBLISHER_EXTRA_PARAMETERS};
    private final JSONObjectBuilder jsonObjectBuilder;
    private final AdTargetingOptions opt;
    private final String orientation;
    private final ConnectionInfo connectionInfo;
    private String instrPixelUrl;
    private AdvertisingIdentifier.Info advertisingIdentifierInfo;
    private final WebRequest.WebRequestFactory webRequestFactory;
    private final Configuration configuration;
    private final DebugProperties debugProperties;
    private final MobileAdsLogger logger;
    protected final Map<Integer, LOISlot> slots;
    private final JSONUtils.JSONUtilities jsonUtilities;

    public AdRequest(AdTargetingOptions opt) {
        this(opt, new WebRequest.WebRequestFactory(), MobileAdsInfoStore.getInstance(), Configuration.getInstance(), DebugProperties.getInstance(), new MobileAdsLoggerFactory(), new JSONUtils.JSONUtilities(), new ConnectionInfo(MobileAdsInfoStore.getInstance()));
    }

    @SuppressLint(value={"UseSparseArrays"})
    AdRequest(AdTargetingOptions opt, WebRequest.WebRequestFactory webRequestFactory, MobileAdsInfoStore infoStore, Configuration configuration, DebugProperties debugProperties, MobileAdsLoggerFactory loggerFactory, JSONUtils.JSONUtilities jsonUtilities, ConnectionInfo connectionInfo) {
        JSONObject json;
        this.opt = opt;
        this.webRequestFactory = webRequestFactory;
        this.jsonUtilities = jsonUtilities;
        this.slots = new HashMap<Integer, LOISlot>();
        DeviceInfo deviceInfo = infoStore.getDeviceInfo();
        this.orientation = deviceInfo.getOrientation();
        this.connectionInfo = connectionInfo;
        this.configuration = configuration;
        this.debugProperties = debugProperties;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        HashMap<String, String> advancedOptions = this.opt.getCopyOfAdvancedOptions();
        if (this.debugProperties.containsDebugProperty("debug.advTargeting") && (json = this.debugProperties.getDebugPropertyAsJSONObject("debug.advTargeting", null)) != null) {
            advancedOptions.putAll(this.jsonUtilities.createMapFromJSON(json));
        }
        AAXParameter.ParameterData parameterData = new AAXParameter.ParameterData().setAdTargetingOptions(this.opt).setAdvancedOptions(advancedOptions).setAdRequest(this);
        this.jsonObjectBuilder = new JSONObjectBuilder(this.logger).setAAXParameters(PARAMETERS).setAAXParameterGroups(PARAMETER_GROUPS).setAdvancedOptions(advancedOptions).setParameterData(parameterData);
    }

    public void setInstrumentationPixelURL(String instrPixelUrl) {
        this.instrPixelUrl = instrPixelUrl;
    }

    public String getInstrumentationPixelURL() {
        return this.instrPixelUrl;
    }

    AdTargetingOptions getAdTargetingOptions() {
        return this.opt;
    }

    String getOrientation() {
        return this.orientation;
    }

    AdvertisingIdentifier.Info getAdvertisingIdentifierInfo() {
        return this.advertisingIdentifierInfo;
    }

    AdRequest setAdvertisingIdentifierInfo(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        return this;
    }

    public void putSlot(AdSlot adSlot) {
        if (this.getAdvertisingIdentifierInfo().hasSISDeviceIdentifier()) {
            adSlot.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_IDENTIFIED_DEVICE);
        }
        adSlot.setConnectionInfo(this.connectionInfo);
        LOISlot slot = new LOISlot(adSlot, this, this.logger);
        this.slots.put(adSlot.getSlotNumber(), slot);
    }

    protected JSONArray getSlots() {
        JSONArray array = new JSONArray();
        for (LOISlot slot : this.slots.values()) {
            array.put((Object)slot.getJSON());
        }
        return array;
    }

    public WebRequest getWebRequest() {
        WebRequest request = this.webRequestFactory.createWebRequest();
        request.setUseSecure(this.isSSLRequired() || request.getUseSecure());
        request.setExternalLogTag(LOGTAG);
        request.setHttpMethod(WebRequest.HttpMethod.POST);
        request.setHost(this.configuration.getString(Configuration.ConfigOption.AAX_HOSTNAME));
        request.setPath(this.configuration.getString(Configuration.ConfigOption.AD_RESOURCE_PATH));
        request.enableLog(true);
        request.setContentType("application/json");
        request.setDisconnectEnabled(false);
        this.setParametersInWebRequest(request);
        return request;
    }

    private boolean isSSLRequired() {
        boolean configSendGeo = Configuration.getInstance().getBoolean(Configuration.ConfigOption.SEND_GEO);
        boolean configTruncateLatLong = Configuration.getInstance().getBoolean(Configuration.ConfigOption.TRUNCATE_LAT_LON);
        return !configTruncateLatLong && configSendGeo && this.getAdTargetingOptions().isGeoLocationEnabled();
    }

    protected void setParametersInWebRequest(WebRequest request) {
        this.jsonObjectBuilder.build();
        JSONArray slots = AAXParameter.SLOTS.getValue(this.jsonObjectBuilder.getParameterData());
        if (slots == null) {
            slots = this.getSlots();
        }
        this.jsonObjectBuilder.putIntoJSON(AAXParameter.SLOTS, (Object)slots);
        JSONObject json = this.jsonObjectBuilder.getJSON();
        String additionalTargetingParams = this.debugProperties.getDebugPropertyAsString("debug.aaxAdParams", null);
        if (!StringUtils.isNullOrEmpty(additionalTargetingParams)) {
            request.setAdditionalQueryParamsString(additionalTargetingParams);
        }
        this.setRequestBodyString(request, json);
    }

    protected void setRequestBodyString(WebRequest request, JSONObject json) {
        request.setRequestBodyString(json.toString());
    }

    static class AdRequestBuilder {
        private AdTargetingOptions adTargetingOptions;
        private AdvertisingIdentifier.Info advertisingIdentifierInfo;

        AdRequestBuilder() {
        }

        public AdRequestBuilder withAdTargetingOptions(AdTargetingOptions adTargetingOptions) {
            this.adTargetingOptions = adTargetingOptions;
            return this;
        }

        public AdRequestBuilder withAdvertisingIdentifierInfo(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
            this.advertisingIdentifierInfo = advertisingIdentifierInfo;
            return this;
        }

        public AdRequest build() {
            return new AdRequest(this.adTargetingOptions).setAdvertisingIdentifierInfo(this.advertisingIdentifierInfo);
        }
    }

    static class JSONObjectBuilder {
        private final MobileAdsLogger logger;
        private final JSONObject json;
        private AAXParameter<?>[] aaxParameters;
        private AAXParameterGroup[] aaxParameterGroups;
        private Map<String, String> advancedOptions;
        private AAXParameter.ParameterData parameterData;

        JSONObjectBuilder(MobileAdsLogger logger) {
            this(logger, new JSONObject());
        }

        JSONObjectBuilder(MobileAdsLogger logger, JSONObject json) {
            this.logger = logger;
            this.json = json;
        }

        JSONObjectBuilder setAAXParameters(AAXParameter<?>[] aaxParameters) {
            this.aaxParameters = aaxParameters;
            return this;
        }

        JSONObjectBuilder setAAXParameterGroups(AAXParameterGroup[] aaxParameterGroups) {
            this.aaxParameterGroups = aaxParameterGroups;
            return this;
        }

        JSONObjectBuilder setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        JSONObjectBuilder setParameterData(AAXParameter.ParameterData parameterData) {
            this.parameterData = parameterData;
            return this;
        }

        AAXParameter.ParameterData getParameterData() {
            return this.parameterData;
        }

        JSONObject getJSON() {
            return this.json;
        }

        void build() {
            if (this.aaxParameterGroups != null) {
                for (AAXParameterGroup aaxParameterGroup : this.aaxParameterGroups) {
                    aaxParameterGroup.evaluate(this.parameterData, this.json);
                }
            }
            for (AAXParameter<?> parameter : this.aaxParameters) {
                Object value = parameter.getValue(this.parameterData);
                this.putIntoJSON(parameter, value);
            }
            if (this.advancedOptions != null) {
                for (Map.Entry<String, String> entry : this.advancedOptions.entrySet()) {
                    if (StringUtils.isNullOrWhiteSpace(entry.getValue())) continue;
                    this.putIntoJSON(entry.getKey(), (Object)entry.getValue());
                }
            }
        }

        void putIntoJSON(AAXParameter<?> parameter, Object value) {
            this.putIntoJSON(parameter.getName(), value);
        }

        void putIntoJSON(String key, Object value) {
            if (value != null) {
                try {
                    this.json.put(key, value);
                }
                catch (JSONException e) {
                    this.logger.d("Could not add parameter to JSON %s: %s", key, value);
                }
            }
        }
    }

    static class LOISlot {
        static final AAXParameter<?>[] PARAMETERS = new AAXParameter[]{AAXParameter.SIZE, AAXParameter.PAGE_TYPE, AAXParameter.SLOT, AAXParameter.SLOT_POSITION, AAXParameter.MAX_SIZE, AAXParameter.SLOT_ID, AAXParameter.FLOOR_PRICE, AAXParameter.SUPPORTED_MEDIA_TYPES, AAXParameter.VIDEO_OPTIONS};
        private final AdTargetingOptions opt;
        private final JSONObjectBuilder jsonObjectBuilder;
        private final AdSlot adSlot;
        private final DebugProperties debugProperties;
        private final JSONUtils.JSONUtilities jsonUtilities;

        LOISlot(AdSlot adSlot, AdRequest adRequest, MobileAdsLogger logger) {
            this(adSlot, adRequest, logger, new JSONObjectBuilder(logger), DebugProperties.getInstance(), new JSONUtils.JSONUtilities());
        }

        LOISlot(AdSlot adSlot, AdRequest adRequest, MobileAdsLogger logger, JSONObjectBuilder jsonObjectBuilder, DebugProperties debugProperties, JSONUtils.JSONUtilities jsonUtilites) {
            JSONObject json;
            this.opt = adSlot.getAdTargetingOptions();
            this.adSlot = adSlot;
            this.debugProperties = debugProperties;
            this.jsonUtilities = jsonUtilites;
            HashMap<String, String> advancedOptions = this.opt.getCopyOfAdvancedOptions();
            if (this.debugProperties.containsDebugProperty("debug.advTargeting") && (json = this.debugProperties.getDebugPropertyAsJSONObject("debug.advTargeting", null)) != null) {
                advancedOptions.putAll(this.jsonUtilities.createMapFromJSON(json));
            }
            AAXParameter.ParameterData parameterData = new AAXParameter.ParameterData().setAdTargetingOptions(this.opt).setAdvancedOptions(advancedOptions).setLOISlot(this).setAdRequest(adRequest);
            this.jsonObjectBuilder = jsonObjectBuilder.setAAXParameters(PARAMETERS).setAdvancedOptions(advancedOptions).setParameterData(parameterData);
        }

        AdTargetingOptions getAdTargetingOptions() {
            return this.opt;
        }

        JSONObject getJSON() {
            this.jsonObjectBuilder.build();
            return this.jsonObjectBuilder.getJSON();
        }

        AdSlot getAdSlot() {
            return this.adSlot;
        }
    }
}

