/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.view.ViewGroup;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdControlCallback;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdListenerExecutor;
import com.amazon.device.ads.AdListenerExecutorFactory;
import com.amazon.device.ads.AdLoadStarter;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRegistration;
import com.amazon.device.ads.AdRegistrationExecutor;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.DefaultAdListener;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Position;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.Size;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModelessInterstitialAd
implements Ad {
    private static final String LOGTAG = ModelessInterstitialAd.class.getSimpleName();
    private static final String PUBLISHER_KEYWORD = "modeless-interstitial";
    private static final int MIN_PIXELS = 380;
    private static final double MIN_SCREEN_COVERAGE_PERCENTAGE = 0.75;
    private final ViewGroup hostedViewGroup;
    private final Context context;
    private final AdRegistrationExecutor amazonAdRegistration;
    private final AdControllerFactory adControllerFactory;
    private AdController adController;
    private MetricsCollector metricsCollector;
    private int timeout;
    private final AdListenerExecutorFactory adListenerExecutorFactory;
    private AdListenerExecutor adListenerExecutor;
    private AdProperties adProperties;
    private final MobileAdsLoggerFactory loggerFactory;
    private final MobileAdsLogger logger;
    private final AdLoadStarter adLoadStarter;
    private final AtomicBoolean previousAdExpired = new AtomicBoolean(false);

    public ModelessInterstitialAd(ViewGroup hostedViewGroup) {
        this(hostedViewGroup, AdRegistration.getAmazonAdRegistrationExecutor(), new AdControllerFactory(), new MobileAdsLoggerFactory(), new AdLoadStarter());
    }

    ModelessInterstitialAd(ViewGroup hostedViewGroup, AdRegistrationExecutor amazonAdRegistration, AdControllerFactory adControllerFactory, MobileAdsLoggerFactory loggerFactory, AdLoadStarter adLoadStarter) {
        this(hostedViewGroup, amazonAdRegistration, adControllerFactory, loggerFactory, new AdListenerExecutorFactory(loggerFactory), adLoadStarter);
    }

    ModelessInterstitialAd(ViewGroup hostedViewGroup, AdRegistrationExecutor amazonAdRegistration, AdControllerFactory adControllerFactory, MobileAdsLoggerFactory loggerFactory, AdListenerExecutorFactory adListenerExecutorFactory, AdLoadStarter adLoadStarter) {
        if (hostedViewGroup == null) {
            throw new IllegalArgumentException("The hostedViewGroup must not be null.");
        }
        this.hostedViewGroup = hostedViewGroup;
        this.context = this.hostedViewGroup.getContext();
        this.amazonAdRegistration = amazonAdRegistration;
        this.adControllerFactory = adControllerFactory;
        this.loggerFactory = loggerFactory;
        this.logger = this.loggerFactory.createMobileAdsLogger(LOGTAG);
        this.adListenerExecutorFactory = adListenerExecutorFactory;
        this.adLoadStarter = adLoadStarter;
        this.initialize();
    }

    @Override
    public void setListener(AdListener adListener) {
        if (adListener == null) {
            adListener = new DefaultAdListener(LOGTAG);
        }
        this.adListenerExecutor = this.adListenerExecutorFactory.createAdListenerExecutor(adListener);
    }

    @Override
    public boolean loadAd(AdTargetingOptions adTargetingOptions) {
        if (!this.isReadyToLoad()) {
            switch (this.adController.getAdState()) {
                case LOADING: 
                case LOADED: 
                case RENDERING: {
                    this.logger.w("The modeless interstitial ad is already loading. Please wait for the loading operation to complete.");
                    break;
                }
                case RENDERED: {
                    this.logger.w("The modeless interstitial ad has already been loaded. Please call adShown once the ad is shown.");
                    break;
                }
                case INVALID: {
                    if (this.adController.isExpired()) {
                        this.adController.resetToReady();
                        return this.loadAd(adTargetingOptions);
                    }
                    this.logger.e("The modeless interstitial ad could not be loaded because of an unknown issue with the web views.");
                    break;
                }
                case DESTROYED: {
                    this.logger.e("The modeless interstitial ad has been destroyed. Please create a new ModelessInterstitialAd.");
                    break;
                }
            }
            this.metricsCollector.incrementMetric(Metrics.MetricType.AD_LOAD_FAILED);
            return false;
        }
        this.previousAdExpired.set(false);
        AdTargetingOptions modifiedTargetingOptions = adTargetingOptions == null ? new AdTargetingOptions() : adTargetingOptions.copy();
        modifiedTargetingOptions.addInternalPublisherKeyword(PUBLISHER_KEYWORD);
        this.submitMetrics();
        this.adLoadStarter.loadAds(this.timeout, modifiedTargetingOptions, new AdSlot(this.adController, modifiedTargetingOptions));
        return this.adController.getAndResetIsPrepared();
    }

    @Override
    public boolean loadAd() {
        return this.loadAd(null);
    }

    @Override
    public boolean isLoading() {
        AdState adState = this.adController.getAdState();
        return adState.equals((Object)AdState.LOADING) || adState.equals((Object)AdState.LOADED) || adState.equals((Object)AdState.RENDERING);
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean adShown() {
        AdState adState = this.adController.getAdState();
        if (this.previousAdExpired.get() || !adState.equals((Object)AdState.HIDDEN) && this.adController.isExpired()) {
            this.logger.e("The ad is unable to be shown because it has expired.");
            this.metricsCollector.stopMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
            this.metricsCollector.incrementMetric(Metrics.MetricType.EXPIRED_AD_CALL);
        } else if (adState.equals((Object)AdState.LOADING)) {
            this.logger.w("The adShown call failed because the ad cannot be shown until it has completed loading.");
        } else if (adState.equals((Object)AdState.SHOWING)) {
            this.logger.w("The adShown call failed because adShown was previously called on this ad.");
        } else if (adState.equals((Object)AdState.RENDERED) || adState.equals((Object)AdState.HIDDEN)) {
            Position adPos;
            if (adState.equals((Object)AdState.RENDERED)) {
                this.metricsCollector.stopMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
            }
            if ((adPos = this.adController.getAdPosition()) != null) {
                Size adSize = adPos.getSize();
                Size screenSize = this.adController.getScreenSize();
                if (this.doesAdSizeHaveOneSideWithAtLeastMinPixels(adSize) && this.isAdOnScreen(adPos, screenSize) && this.doesAdSizeMeetRequiredScreenPercentage(adSize, screenSize)) {
                    this.checkIfAdAspectRatioLessThanScreenAspectRatio(adSize, screenSize);
                    if (this.adController.getAdState().equals((Object)AdState.HIDDEN)) {
                        this.metricsCollector.incrementMetric(Metrics.MetricType.AD_COUNTER_RESHOWN);
                    }
                    this.setRenderedViewClickable(true);
                    this.adController.adShown();
                    this.metricsCollector.startMetric(Metrics.MetricType.AD_SHOW_DURATION);
                    return true;
                }
                this.metricsCollector.incrementMetric(Metrics.MetricType.RENDER_REQUIREMENT_CHECK_FAILURE);
            }
        } else {
            this.logger.w("The adShown call failed because the ad is not in a state to be shown. The ad is currently in the %s state.", new Object[]{adState});
        }
        return false;
    }

    public void adHidden() {
        AdState adState = this.adController.getAdState();
        if (adState.equals((Object)AdState.HIDDEN)) {
            this.logger.d("The ad is already hidden from view.");
        } else if (adState.equals((Object)AdState.SHOWING)) {
            this.adController.getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_DURATION);
            this.setRenderedViewClickable(false);
            this.adController.adHidden();
        } else {
            this.logger.w("The ad must be shown before it can be hidden.");
        }
    }

    public void destroy() {
        this.logger.d("Destroying the Modeless Interstitial Ad");
        if (this.adController.getAdState().equals((Object)AdState.SHOWING)) {
            this.adHidden();
        }
        this.submitMetrics();
        this.adController.destroy();
    }

    public boolean isReady() {
        return this.adController.getAdState().equals((Object)AdState.RENDERED) && !this.adController.isExpired();
    }

    private void initialize() {
        this.amazonAdRegistration.initializeAds(this.context.getApplicationContext());
        this.setListener(null);
        this.buildAdController();
    }

    private void buildAdController() {
        this.adController = this.adControllerFactory.buildAdController(this.context, AdSize.SIZE_MODELESS_INTERSTITIAL);
        this.adController.setCallback(new ModelessInterstitialAdControlCallback());
        this.metricsCollector = this.adController.getMetricsCollector();
        this.metricsCollector.setAdTypeMetricTag(AdProperties.AdType.MODELESS_INTERSTITIAL.getAdTypeMetricTag());
        this.metricsCollector.incrementMetric(Metrics.MetricType.AD_IS_INTERSTITIAL);
    }

    private void onAdFailedToLoadOrRender(AdError adError) {
        if (adError.getCode().equals((Object)AdError.ErrorCode.NETWORK_TIMEOUT)) {
            this.submitMetrics();
            this.buildAdController();
        }
        this.adListenerExecutor.onAdFailedToLoad(this, adError);
    }

    private void onAdFetched(AdProperties adProperties) {
        this.adProperties = adProperties;
        this.adController.render();
    }

    private void onAdRendered() {
        this.hostedViewGroup.addView(this.adController.getView());
        this.setRenderedViewClickable(false);
        this.adListenerExecutor.onAdLoaded(this, this.adProperties);
    }

    private boolean isReadyToLoad() {
        AdState adState = this.adController.getAdState();
        return this.adController.isExpired() || adState.equals((Object)AdState.READY_TO_LOAD) || adState.equals((Object)AdState.HIDDEN);
    }

    private void onAdRenderMetricsRecorded() {
        this.metricsCollector.startMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME);
        this.adController.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.PLACED));
    }

    private void setRenderedViewClickable(boolean clickable) {
        this.adController.setAllowClicks(clickable);
    }

    private void onAdExpired() {
        this.metricsCollector.incrementMetric(Metrics.MetricType.AD_EXPIRED_BEFORE_SHOWING);
        this.previousAdExpired.set(true);
        this.buildAdController();
        this.adListenerExecutor.onAdExpired(this);
    }

    private void submitMetrics() {
        if (!this.adController.getMetricsCollector().isMetricsCollectorEmpty()) {
            this.adController.submitAndResetMetrics();
        }
    }

    private boolean doesAdSizeHaveOneSideWithAtLeastMinPixels(Size adSize) {
        if (adSize.getHeight() >= 380 || adSize.getWidth() >= 380) {
            return true;
        }
        this.logger.e("This ModelessInterstitialAd cannot fire impression pixels or receive clicks because the height %d and width %d does not meet the requirement of one side being at least %d device independent pixels.", adSize.getHeight(), adSize.getWidth(), 380);
        return false;
    }

    private boolean isAdOnScreen(Position adPos, Size screenSize) {
        if (adPos.getX() >= 0 && adPos.getX() + adPos.getSize().getWidth() <= screenSize.getWidth() && adPos.getY() >= 0 && adPos.getY() + adPos.getSize().getHeight() <= screenSize.getHeight()) {
            return true;
        }
        this.logger.e("This ModelessInterstitialAd cannot fire impression pixels or receive clicks because it does not meet the requirement of being fully on screen.");
        return false;
    }

    private boolean doesAdSizeMeetRequiredScreenPercentage(Size adSize, Size screenSize) {
        double screenArea;
        double adArea = (double)adSize.getHeight() * (double)adSize.getWidth();
        double screenPercentage = adArea / (screenArea = (double)screenSize.getHeight() * (double)screenSize.getWidth());
        if (screenPercentage >= 0.75) {
            return true;
        }
        this.logger.e("This ModelessInterstitialAd cannot fire impression pixels or receive clicks because it has a screen coverage percentage of %f which does not meet the requirement of covering at least %d percent.", screenPercentage * 100.0, 75);
        return false;
    }

    private void checkIfAdAspectRatioLessThanScreenAspectRatio(Size adSize, Size screenSize) {
        boolean adAspectRatioLessThanScreenAspectRatio;
        float adSizeWidth = adSize.getWidth();
        float adSizeHeight = adSize.getHeight();
        float screenSizeWidth = screenSize.getWidth();
        float screenSizeHeight = screenSize.getHeight();
        if (adSizeWidth <= adSizeHeight) {
            adAspectRatioLessThanScreenAspectRatio = adSizeWidth / adSizeHeight < screenSizeWidth / screenSizeHeight;
        } else {
            boolean bl = adAspectRatioLessThanScreenAspectRatio = adSizeHeight / adSizeWidth < screenSizeHeight / screenSizeWidth;
        }
        if (adAspectRatioLessThanScreenAspectRatio) {
            this.metricsCollector.incrementMetric(Metrics.MetricType.AD_ASPECT_RATIO_LESS_THAN_SCREEN_ASPECT_RATIO);
            this.logger.w("For an optimal ad experience, the aspect ratio of the ModelessInterstitialAd should be greater than or equal to the aspect ratio of the screen.");
        }
    }

    private class ModelessInterstitialAdControlCallback
    implements AdControlCallback {
        private ModelessInterstitialAdControlCallback() {
        }

        @Override
        public boolean isAdReady(boolean deferredLoad) {
            return ModelessInterstitialAd.this.isReadyToLoad();
        }

        @Override
        public void onAdLoaded(AdProperties adProperties) {
            ModelessInterstitialAd.this.onAdFetched(adProperties);
        }

        @Override
        public void onAdRendered() {
            ModelessInterstitialAd.this.onAdRendered();
        }

        @Override
        public void postAdRendered() {
            ModelessInterstitialAd.this.onAdRenderMetricsRecorded();
        }

        @Override
        public void onAdFailed(AdError adError) {
            ModelessInterstitialAd.this.onAdFailedToLoadOrRender(adError);
        }

        @Override
        public void onAdEvent(AdEvent event) {
        }

        @Override
        public int adClosing() {
            return 2;
        }

        @Override
        public void onAdExpired() {
            ModelessInterstitialAd.this.onAdExpired();
        }
    }
}

