/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SDKEvent;
import com.amazon.device.ads.SDKEventListener;

class AmazonAdSDKViewableEventListener
implements SDKEventListener {
    private static final String LOGTAG = AmazonAdSDKViewableEventListener.class.getSimpleName();
    private final MobileAdsLogger logger;

    public AmazonAdSDKViewableEventListener() {
        this(new MobileAdsLoggerFactory());
    }

    AmazonAdSDKViewableEventListener(MobileAdsLoggerFactory mobileAdsLoggerFactory) {
        this.logger = mobileAdsLoggerFactory.createMobileAdsLogger(LOGTAG);
    }

    @Override
    public void onSDKEvent(SDKEvent sdkEvent, AdControlAccessor adControlAccessor) {
        this.logger.d(sdkEvent.getEventType().toString());
        switch (sdkEvent.getEventType()) {
            case VIEWABLE: {
                this.handleViewableEvent(adControlAccessor, sdkEvent);
                break;
            }
        }
    }

    public void handleViewableEvent(AdControlAccessor adControlAccessor, SDKEvent sdkEvent) {
        String viewableInfo = sdkEvent.getParameter("VIEWABLE_PARAMS");
        adControlAccessor.injectJavascript("viewableBridge.viewabilityChange('" + viewableInfo + "');");
    }
}

