/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class AdMetrics {
    public static final String LOGTAG = AdMetrics.class.getSimpleName();
    private final Metrics.MetricsSubmitter submitter;
    private MetricsCollector globalMetrics;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    private final WebRequest.WebRequestFactory webRequestFactory = new WebRequest.WebRequestFactory();
    private final MobileAdsInfoStore mobileAdsInfoStore;

    public AdMetrics(Metrics.MetricsSubmitter submitter) {
        this(submitter, MobileAdsInfoStore.getInstance());
    }

    AdMetrics(Metrics.MetricsSubmitter submitter, MobileAdsInfoStore mobileAdsInfoStore) {
        this.submitter = submitter;
        this.mobileAdsInfoStore = mobileAdsInfoStore;
    }

    private String getAaxUrlAndResetAdMetrics() {
        String json = this.getAaxJson();
        json = WebUtils.getURLEncodedString(json);
        String url = this.submitter.getInstrumentationPixelUrl() + json;
        this.submitter.resetMetricsCollector();
        return url;
    }

    public WebRequest getAaxWebRequestAndResetAdMetrics() {
        WebRequest webRequest = this.webRequestFactory.createWebRequest();
        webRequest.setUrlString(this.getAaxUrlAndResetAdMetrics());
        return webRequest;
    }

    public boolean canSubmit() {
        String pixelUrl = this.submitter.getInstrumentationPixelUrl();
        if (pixelUrl == null || pixelUrl.equals("")) {
            return false;
        }
        String appKey = this.mobileAdsInfoStore.getRegistrationInfo().getAppKey();
        if (appKey == null) {
            this.logger.d("Not submitting metrics because the AppKey is not set.");
            return false;
        }
        return true;
    }

    public void addGlobalMetrics(MetricsCollector globalMetrics) {
        this.globalMetrics = globalMetrics;
    }

    protected String getAaxJson() {
        JSONObject json = new JSONObject();
        JSONUtils.put(json, "c", "msdk");
        JSONUtils.put(json, "v", Version.getRawSDKVersion());
        AdMetrics.addMetricsToJSON(json, this.submitter.getMetricsCollector());
        AdMetrics.addMetricsToJSON(json, this.globalMetrics);
        String jsonString = json.toString();
        String bracesRemovedJsonString = jsonString.substring(1, jsonString.length() - 1);
        return bracesRemovedJsonString;
    }

    protected static void addMetricsToJSON(JSONObject json, MetricsCollector metricsCollector) {
        if (metricsCollector == null) {
            return;
        }
        HashMap<Metrics.MetricType, Long> startedMetricHits = new HashMap<Metrics.MetricType, Long>();
        HashMap<Metrics.MetricType, Integer> incrementedMetricHits = new HashMap<Metrics.MetricType, Integer>();
        String adTypeMetricTag = metricsCollector.getAdTypeMetricTag();
        if (adTypeMetricTag != null) {
            adTypeMetricTag = adTypeMetricTag + "_";
        }
        MetricsCollector.MetricHit[] tempMetricHits = metricsCollector.getMetricHits().toArray(new MetricsCollector.MetricHit[metricsCollector.getMetricHits().size()]);
        String metricName = null;
        for (MetricsCollector.MetricHit metricHit : tempMetricHits) {
            metricName = metricHit.metric.getAaxName();
            if (adTypeMetricTag != null && metricHit.metric.isAdTypeSpecific()) {
                metricName = adTypeMetricTag + metricName;
            }
            if (metricHit instanceof MetricsCollector.MetricHitStartTime) {
                MetricsCollector.MetricHitStartTime metricHitStartTime = (MetricsCollector.MetricHitStartTime)metricHit;
                startedMetricHits.put(metricHit.metric, metricHitStartTime.startTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitStopTime) {
                MetricsCollector.MetricHitStopTime metricHitStopTime = (MetricsCollector.MetricHitStopTime)metricHit;
                Long startTime = (Long)startedMetricHits.remove((Object)metricHit.metric);
                if (startTime == null) continue;
                long previousTotalTime = JSONUtils.getLongFromJSON(json, metricName, 0L);
                long totalTime = previousTotalTime + metricHitStopTime.stopTime - startTime;
                JSONUtils.put(json, metricName, totalTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitTotalTime) {
                MetricsCollector.MetricHitTotalTime metricHitTotalTime = (MetricsCollector.MetricHitTotalTime)metricHit;
                JSONUtils.put(json, metricName, metricHitTotalTime.totalTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitIncrement) {
                MetricsCollector.MetricHitIncrement metricHitIncrement = (MetricsCollector.MetricHitIncrement)metricHit;
                Integer increment = (Integer)incrementedMetricHits.get((Object)metricHit.metric);
                increment = increment == null ? metricHitIncrement.increment : increment + metricHitIncrement.increment;
                incrementedMetricHits.put(metricHit.metric, increment);
                continue;
            }
            if (!(metricHit instanceof MetricsCollector.MetricHitString)) continue;
            MetricsCollector.MetricHitString metricHitString = (MetricsCollector.MetricHitString)metricHit;
            JSONUtils.put(json, metricName, metricHitString.text);
        }
        for (Map.Entry incrementedMetric : incrementedMetricHits.entrySet()) {
            metricName = ((Metrics.MetricType)((Object)incrementedMetric.getKey())).getAaxName();
            if (adTypeMetricTag != null && ((Metrics.MetricType)((Object)incrementedMetric.getKey())).isAdTypeSpecific()) {
                metricName = adTypeMetricTag + metricName;
            }
            JSONUtils.put(json, metricName, (Integer)incrementedMetric.getValue());
        }
    }
}

