/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.Keyword;
import clojure.lang.RT;
import java.util.stream.Stream;
import tech.v3.datatype.Buffer;
import tech.v3.datatype.NumericConversions;

public interface ObjectBuffer
extends Buffer {
    @Override
    default public Object elemwiseDatatype() {
        return Keyword.intern(null, (String)"object");
    }

    default public boolean readBoolean(long l) {
        Object object = this.readObject(l);
        if (object instanceof Number) {
            return RT.doubleCast((Object)object) != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return object != null;
    }

    @Override
    default public byte readByte(long l) {
        return NumericConversions.byteCast(this.readObject(l));
    }

    default public short readShort(long l) {
        return NumericConversions.shortCast(this.readObject(l));
    }

    default public char readChar(long l) {
        return RT.charCast((Object)this.readObject(l));
    }

    default public int readInt(long l) {
        return NumericConversions.intCast(this.readObject(l));
    }

    @Override
    default public long readLong(long l) {
        return NumericConversions.longCast(this.readObject(l));
    }

    default public float readFloat(long l) {
        return NumericConversions.floatCast(this.readObject(l));
    }

    @Override
    default public double readDouble(long l) {
        return NumericConversions.doubleCast(this.readObject(l));
    }

    default public Stream typedStream() {
        return this.stream();
    }

    default public void writeBoolean(long l, boolean bl) {
        this.writeObject(l, bl);
    }

    @Override
    default public void writeByte(long l, byte by) {
        this.writeObject(l, by);
    }

    default public void writeShort(long l, short s) {
        this.writeObject(l, s);
    }

    default public void writeChar(long l, char c) {
        this.writeObject(l, Character.valueOf(c));
    }

    default public void writeInt(long l, int n) {
        this.writeObject(l, n);
    }

    @Override
    default public void writeLong(long l, long l2) {
        this.writeObject(l, l2);
    }

    default public void writeFloat(long l, float f) {
        this.writeObject(l, Float.valueOf(f));
    }

    @Override
    default public void writeDouble(long l, double d) {
        this.writeObject(l, d);
    }

    @Override
    default public void writeObject(long l, Object object) {
        this.writeObject(l, object);
    }
}

