/*
 * Decompiled with CFR 0.152.
 */
package tech.v3;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import ham_fisted.Casts;
import java.util.List;
import java.util.Map;
import org.roaringbitmap.RoaringBitmap;
import tech.v3.Clj;
import tech.v3.datatype.ArrayBufferData;
import tech.v3.datatype.Buffer;
import tech.v3.datatype.NativeBufferData;

public class DType {
    public static final Keyword bool = Clj.keyword("boolean");
    public static final Keyword int8 = Clj.keyword("int8");
    public static final Keyword uint8 = Clj.keyword("uint8");
    public static final Keyword int16 = Clj.keyword("int16");
    public static final Keyword uint16 = Clj.keyword("uint16");
    public static final Keyword int32 = Clj.keyword("int32");
    public static final Keyword uint32 = Clj.keyword("uint32");
    public static final Keyword int64 = Clj.keyword("int64");
    public static final Keyword uint64 = Clj.keyword("uint64");
    public static final Keyword float32 = Clj.keyword("float32");
    public static final Keyword float64 = Clj.keyword("float64");
    public static final Keyword jvmHeap = Clj.keyword("jvm-heap");
    public static final Keyword nativeHeap = Clj.keyword("native-heap");
    static final IFn makeContainerFn = Clj.requiringResolve("tech.v3.datatype", "make-container");
    static final IFn cloneFn = Clj.requiringResolve("tech.v3.datatype", "clone");
    static final IFn toArrayFn = Clj.requiringResolve("tech.v3.datatype", "->array");
    static final IFn elemwiseDatatypeFn = Clj.requiringResolve("tech.v3.datatype", "elemwise-datatype");
    static final IFn ecountFn = Clj.requiringResolve("tech.v3.datatype", "ecount");
    static final IFn shapeFn = Clj.requiringResolve("tech.v3.datatype", "shape");
    static final IFn makeListFn = Clj.requiringResolve("tech.v3.datatype", "make-list");
    static final IFn emapFn = Clj.requiringResolve("tech.v3.datatype.emap", "emap");
    static final IFn applyFn = Clj.requiringResolve("clojure.core", "apply");
    static final Object stackContextVar = Clj.requiringResolve("tech.v3.resource.stack", "*resource-context*");
    static final Object stackBoundVar = Clj.requiringResolve("tech.v3.resource.stack", "*bound-resource-context?*");
    static final IFn releaseResourcesFn = Clj.requiringResolve("tech.v3.resource.stack", "release-current-resources");
    static final IFn optMap = Clj.requiringResolve("tech.v3.datatype.jvm-map", "opt-map");
    static final IFn setConstantFn = Clj.requiringResolve("tech.v3.datatype", "set-constant!");
    static final IFn copyFn = Clj.requiringResolve("tech.v3.datatype", "copy!");
    static final IFn subBufferFn = Clj.requiringResolve("tech.v3.datatype", "sub-buffer");
    static final IFn toBufferFn = Clj.requiringResolve("tech.v3.datatype", "->buffer");
    static final IFn wrapAddressFn = Clj.requiringResolve("tech.v3.datatype.native-buffer", "wrap-address");
    static final IFn setNativeDtFn = Clj.requiringResolve("tech.v3.datatype.native-buffer", "set-native-datatype");
    static final IFn asNativeBufferFn = Clj.requiringResolve("tech.v3.datatype", "as-native-buffer-data");
    static final IFn asArrayBufferFn = Clj.requiringResolve("tech.v3.datatype", "as-array-buffer-data");
    static final IFn numericByteWidthFn = Clj.requiringResolve("tech.v3.datatype.casting", "numeric-byte-width");
    static final IFn indexedBufferFn = Clj.requiringResolve("tech.v3.datatype.io-indexed-buffer", "indexed-buffer");
    static final IFn reverseFn = Clj.requiringResolve("tech.v3.datatype-api", "reverse");
    static final IFn asNioBufFn = Clj.requiringResolve("tech.v3.datatype.nio-buffer", "as-nio-buffer");
    static final IFn indexedMapReduceFn = Clj.requiringResolve("tech.v3.parallel.for", "indexed-map-reduce");
    static final IFn toBitmapFn = Clj.requiringResolve("tech.v3.datatype.bitmap", "->bitmap");
    static final IFn mapFactoryFn = Clj.requiringResolve("tech.v3.datatype", "map-factory");

    private DType() {
    }

    public static Object indexedMapReduce(long l, IFn iFn, IFn iFn2, Object object) {
        return indexedMapReduceFn.invoke((Object)l, (Object)iFn, (Object)iFn2, object);
    }

    public static Object indexedMapReduce(long l, IFn iFn, IFn iFn2) {
        return DType.indexedMapReduce(l, iFn, iFn2, null);
    }

    public static Object elemwiseDatatype(Object object) {
        return elemwiseDatatypeFn.invoke(object);
    }

    public static long ecount(Object object) {
        return (Long)ecountFn.invoke(object);
    }

    public static List shape(Object object) {
        return (List)shapeFn.invoke(object);
    }

    public static AutoCloseable stackResourceContext() {
        Clj.pushThreadBindings(Clj.hashmap(stackContextVar, Clj.atom(Clj.list(new Object[0])), stackBoundVar, true));
        return new AutoCloseable(){

            @Override
            public void close() {
                try {
                    releaseResourcesFn.invoke();
                }
                finally {
                    Clj.popThreadBindings();
                }
            }
        };
    }

    public static Object makeContainer(Object object, Object object2, Object object3, Object object4) {
        return makeContainerFn.invoke(object, object2, object3, object4);
    }

    public static Object makeContainer(Object object, Object object2, Object object3) {
        return makeContainerFn.invoke(object, object2, object3);
    }

    public static Object makeContainer(Object object, Object object2) {
        return makeContainerFn.invoke(object, object2);
    }

    public static Object makeContainer(Object object) {
        return makeContainerFn.invoke(object);
    }

    public static Object clone(Object object) {
        return cloneFn.invoke(object);
    }

    public static Object toArray(Object object) {
        return toArrayFn.invoke(object);
    }

    public static Object toArray(Object object, Object object2) {
        return toArrayFn.invoke(object, object2);
    }

    public static boolean[] toBooleanArray(Object object) {
        return (boolean[])toArrayFn.invoke((Object)bool, object);
    }

    public static byte[] toByteArray(Object object) {
        return (byte[])toArrayFn.invoke((Object)int8, object);
    }

    public static short[] toShortArray(Object object) {
        return (short[])toArrayFn.invoke((Object)int16, object);
    }

    public static int[] toIntArray(Object object) {
        return (int[])toArrayFn.invoke((Object)int32, object);
    }

    public static long[] toLongArray(Object object) {
        return (long[])toArrayFn.invoke((Object)int64, object);
    }

    public static float[] toFloatArray(Object object) {
        return (float[])toArrayFn.invoke((Object)float32, object);
    }

    public static double[] toDoubleArray(Object object) {
        return (double[])toArrayFn.invoke((Object)float64, object);
    }

    public static Object setConstant(Object object, long l, long l2, Object object2) {
        Clj.call(setConstantFn, object, l, l2, object2);
        return object;
    }

    public static Object setConstant(Object object, long l, Object object2) {
        Clj.call(setConstantFn, object, l, object2);
        return object;
    }

    public static Object setConstant(Object object, Object object2) {
        Clj.call(setConstantFn, object, object2);
        return object;
    }

    public static Object copy(Object object, Object object2) {
        Clj.call(copyFn, object, object2);
        return object2;
    }

    public static Object subBuffer(Object object, long l, long l2) {
        return Clj.call(subBufferFn, object, l, l2);
    }

    public static Object subBuffer(Object object, long l) {
        return Clj.call(subBufferFn, object, l);
    }

    public static Buffer toBuffer(Object object) {
        if (object instanceof Buffer) {
            return (Buffer)object;
        }
        return (Buffer)Clj.call(toBufferFn, object);
    }

    public static Buffer indexedBuffer(Object object, Object object2) {
        return (Buffer)Clj.call(indexedBufferFn, object, object2);
    }

    public static boolean boolCast(Object object) {
        return Casts.booleanCast((Object)object);
    }

    public static Object reverse(Object object) {
        return Clj.call(reverseFn, object);
    }

    public static Buffer makeList(Object object) {
        return (Buffer)makeListFn.invoke(object);
    }

    public static Buffer emap(IFn iFn, Object object, Object ... objectArray) {
        switch (objectArray.length) {
            case 0: {
                throw new RuntimeException("emap requires at least one argument to map over.");
            }
            case 1: {
                return (Buffer)emapFn.invoke((Object)iFn, object, objectArray[0]);
            }
            case 2: {
                return (Buffer)emapFn.invoke((Object)iFn, object, objectArray[0], objectArray[1]);
            }
            case 3: {
                return (Buffer)emapFn.invoke((Object)iFn, object, objectArray[0], objectArray[1], objectArray[2]);
            }
            case 4: {
                return (Buffer)emapFn.invoke((Object)iFn, object, objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
            }
        }
        return (Buffer)applyFn.invoke((Object)emapFn, (Object)iFn, object, (Object)objectArray);
    }

    public static Map opts(Object ... objectArray) {
        return (Map)optMap.invoke((Object)objectArray);
    }

    public static long numericByteWidth(Object object) {
        return (Long)Clj.call(numericByteWidthFn, object);
    }

    public static Object wrapAddress(Object object, long l, long l2) {
        return Clj.call(wrapAddressFn, l, l2, int8, Clj.kw("little-endian"), object);
    }

    public static Object wrapAddress(Object object, long l, long l2, Object object2) {
        Object object3 = DType.wrapAddress(object, l, l2);
        return Clj.call(setNativeDtFn, object3, object2);
    }

    public static NativeBufferData asNativeBuffer(Object object) {
        return (NativeBufferData)Clj.call(asNativeBufferFn, object);
    }

    public static ArrayBufferData asArrayBuffer(Object object) {
        return (ArrayBufferData)Clj.call(asArrayBufferFn, object);
    }

    public static java.nio.Buffer asNioBuffer(Object object) {
        return (java.nio.Buffer)Clj.call(asNioBufFn, object);
    }

    public static RoaringBitmap toBitmap(Object object) {
        return (RoaringBitmap)Clj.call(toBitmapFn, object);
    }

    public static RoaringBitmap emptyBitmap() {
        return (RoaringBitmap)Clj.call(toBitmapFn);
    }

    public static IFn mapFactory(List list) {
        return (IFn)mapFactoryFn.invoke((Object)list);
    }
}

