/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.xjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.xjson.spi.Config;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class YamlKit {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static Mapper toMapper(String yaml) {
        return Config.yaml().toMapper(yaml);
    }

    public static Mapper toMapper(byte[] yamlBytes) {
        return Config.yaml().toMapper((InputStream)new ByteArrayInputStream(yamlBytes), CHARSET);
    }

    public static Array toArray(String yaml) {
        return Config.yaml().toArray(yaml);
    }

    public static Array toArray(byte[] yamlBytes) {
        return Config.yaml().toArray((InputStream)new ByteArrayInputStream(yamlBytes), CHARSET);
    }

    public static <T> T toBean(Type type, String yaml) {
        return (T)Config.yaml().toBean(type, yaml);
    }

    public static <T> T toBean(Type type, byte[] yamlBytes) {
        return (T)Config.yaml().toBean(type, (InputStream)new ByteArrayInputStream(yamlBytes), CHARSET);
    }

    public static <T> T toBean(TypeRef<T> typeRef, String yaml) {
        return YamlKit.toBean(typeRef.getType(), yaml);
    }

    public static <T> T toBean(TypeRef<T> typeRef, byte[] yamlBytes) {
        return YamlKit.toBean(typeRef.getType(), yamlBytes);
    }

    public static <T> List<T> toList(Class<T> type, String yaml) {
        return Config.yaml().toList(type, yaml);
    }

    public static <T> List<T> toList(Class<T> type, byte[] yamlBytes) {
        return Config.yaml().toList(type, (InputStream)new ByteArrayInputStream(yamlBytes), CHARSET);
    }

    public static String toYaml(Object object) {
        return Config.yaml().serialize(object);
    }

    public static byte[] toBytes(Object object) {
        return Config.yaml().serialize(object, CHARSET);
    }
}

