/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.jackson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.jackson.JacksonList;
import cn.zhxu.data.jackson.JacksonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.List;

public class JacksonArray
implements Array {
    private final ObjectMapper om;
    private final ArrayNode json;

    public JacksonArray(ObjectMapper om, ArrayNode json) {
        this.om = om;
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isObject()) {
            return new JacksonMapper(this.om, (ObjectNode)subJson);
        }
        return null;
    }

    public Array getArray(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isArray()) {
            return new JacksonArray(this.om, (ArrayNode)subJson);
        }
        return null;
    }

    public boolean getBool(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asBoolean(false);
        }
        return false;
    }

    public int getInt(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asInt(0);
        }
        return 0;
    }

    public long getLong(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asLong(0L);
        }
        return 0L;
    }

    public float getFloat(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null && subJson.isNumber()) {
            return subJson.floatValue();
        }
        if (subJson != null) {
            return (float)subJson.asDouble(0.0);
        }
        return 0.0f;
    }

    public double getDouble(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson != null) {
            return subJson.asDouble(0.0);
        }
        return 0.0;
    }

    public String getString(int index) {
        JsonNode subJson = this.json.get(index);
        if (subJson == null || subJson.isNull()) {
            return null;
        }
        return subJson.asText();
    }

    public <T> List<T> toList(Class<T> type) {
        CollectionType listType = this.om.getTypeFactory().constructCollectionType(ArrayList.class, type);
        try {
            return (List)this.om.treeToValue((TreeNode)this.json, (JavaType)listType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> toList() {
        return new JacksonList(this.json);
    }

    public String toPretty() {
        return this.json.toPrettyString();
    }

    public String toString() {
        return this.json.toString();
    }
}

